/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.mixin;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.gl.GlStateTracker;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderDispatcher;
import com.jozufozu.flywheel.core.crumbling.CrumblingRenderer;
import com.jozufozu.flywheel.event.BeginFrameEvent;
import com.jozufozu.flywheel.event.ReloadRenderersEvent;
import com.jozufozu.flywheel.event.RenderLayerEvent;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Group;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={LevelRenderer.class}, priority=1001)
public class LevelRendererMixin {
    @Shadow
    private ClientLevel f_109465_;
    @Shadow
    @Final
    private RenderBuffers f_109464_;
    @Unique
    private boolean flywheel$LayerRendered;

    @Inject(at={@At(value="HEAD")}, method={"setupRender"})
    private void setupRender(Camera camera, Frustum frustum, boolean queue, boolean isSpectator, CallbackInfo ci) {
        MinecraftForge.EVENT_BUS.post((Event)new BeginFrameEvent(this.f_109465_, camera, frustum));
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/ShaderInstance;clear()V")}, method={"renderChunkLayer"})
    @Group(name="flywheel$renderLayer", min=1, max=2)
    private void renderLayer(RenderType type, PoseStack stack, double camX, double camY, double camZ, Matrix4f p_172999_, CallbackInfo ci) {
        this.flywheel$renderLayer(type, stack, camX, camY, camZ);
        this.flywheel$LayerRendered = true;
    }

    @Inject(at={@At(value="TAIL")}, method={"renderChunkLayer"})
    @Group(name="flywheel$renderLayer")
    private void renderLayerSodium(RenderType type, PoseStack stack, double camX, double camY, double camZ, Matrix4f p_172999_, CallbackInfo ci) {
        if (!this.flywheel$LayerRendered) {
            this.flywheel$renderLayer(type, stack, camX, camY, camZ);
        }
        this.flywheel$LayerRendered = false;
        BufferUploader.m_166835_();
    }

    @Unique
    private void flywheel$renderLayer(RenderType type, PoseStack stack, double camX, double camY, double camZ) {
        RenderBuffers renderBuffers = this.f_109464_;
        GlStateTracker.State restoreState = GlStateTracker.getRestoreState();
        MinecraftForge.EVENT_BUS.post((Event)new RenderLayerEvent(this.f_109465_, type, stack, renderBuffers, camX, camY, camZ));
        restoreState.restore();
    }

    @Inject(at={@At(value="TAIL")}, method={"allChanged"})
    private void refresh(CallbackInfo ci) {
        Backend.refresh();
        MinecraftForge.EVENT_BUS.post((Event)new ReloadRenderersEvent(this.f_109465_));
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;checkPoseStack(Lcom/mojang/blaze3d/vertex/PoseStack;)V", ordinal=2)}, method={"renderLevel"})
    private void renderBlockBreaking(PoseStack stack, float p_228426_2_, long p_228426_3_, boolean p_228426_5_, Camera info, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f p_228426_9_, CallbackInfo ci) {
        if (!Backend.isOn()) {
            return;
        }
        Vec3 cameraPos = info.m_90583_();
        GlStateTracker.State restoreState = GlStateTracker.getRestoreState();
        CrumblingRenderer.renderBreaking(new RenderLayerEvent(this.f_109465_, null, stack, null, cameraPos.f_82479_, cameraPos.f_82480_, cameraPos.f_82481_));
        restoreState.restore();
    }

    @Inject(at={@At(value="TAIL")}, method={"setBlockDirty(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;)V"})
    private void checkUpdate(BlockPos pos, BlockState lastState, BlockState newState, CallbackInfo ci) {
        if (Backend.isOn()) {
            InstancedRenderDispatcher.getBlockEntities((LevelAccessor)this.f_109465_).update(this.f_109465_.m_7702_(pos));
        }
    }
}

