/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.banner;

import com.yungnickyoung.minecraft.yungsapi.world.banner.BannerPattern;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.state.BlockState;

public class Banner {
    private List<BannerPattern> patterns;
    private BlockState state;
    private CompoundTag nbt;
    private boolean isWallBanner;

    public Banner(List<BannerPattern> patterns, BlockState state, CompoundTag nbt) {
        this.patterns = patterns;
        this.state = state;
        this.nbt = nbt;
        this.isWallBanner = this.state.m_60734_() instanceof WallBannerBlock;
    }

    public Banner(List<BannerPattern> patterns, BlockState state, CompoundTag nbt, boolean isWallBanner) {
        this.patterns = patterns;
        this.state = state;
        this.nbt = nbt;
        this.isWallBanner = isWallBanner;
    }

    public List<BannerPattern> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(List<BannerPattern> patterns) {
        this.patterns = patterns;
    }

    public BlockState getState() {
        return this.state;
    }

    public void setState(BlockState state) {
        this.state = state;
    }

    public CompoundTag getNbt() {
        return this.nbt;
    }

    public void setNbt(CompoundTag nbt) {
        this.nbt = nbt;
    }

    public boolean isWallBanner() {
        return this.isWallBanner;
    }

    public void setWallBanner(boolean wallBanner) {
        this.isWallBanner = wallBanner;
    }

    public static class Builder {
        private final List<BannerPattern> patterns = new ArrayList<BannerPattern>();
        private TranslatableComponent customNameTranslate;
        private String customColor;
        private BlockState state = Blocks.f_50393_.m_49966_();

        public Builder blockState(BlockState state) {
            this.state = state;
            return this;
        }

        public Builder pattern(BannerPattern pattern) {
            this.patterns.add(pattern);
            return this;
        }

        public Builder pattern(String pattern, int color) {
            this.patterns.add(new BannerPattern(pattern, color));
            return this;
        }

        public Builder customName(String translatableNamePath) {
            this.customNameTranslate = new TranslatableComponent(translatableNamePath);
            return this;
        }

        public Builder customColor(String colorString) {
            this.customColor = colorString;
            return this;
        }

        public Banner build() {
            CompoundTag nbt = this.createBannerNBT(this.patterns);
            return new Banner(this.patterns, this.state, nbt);
        }

        private CompoundTag createBannerNBT(List<BannerPattern> patterns) {
            CompoundTag nbt = new CompoundTag();
            ListTag patternList = new ListTag();
            for (BannerPattern pattern : patterns) {
                CompoundTag patternNBT = new CompoundTag();
                patternNBT.m_128359_("Pattern", pattern.getPattern());
                patternNBT.m_128405_("Color", pattern.getColor());
                patternList.add((Object)patternNBT);
            }
            if (this.customColor != null || this.customNameTranslate != null) {
                Object name;
                String color = this.customColor == null ? "" : String.format("\"color\":\"%s\"", this.customColor);
                Object object = name = this.customNameTranslate == null ? "" : String.format("\"translate\":\"%s\"", this.customNameTranslate.m_131328_());
                if (this.customColor != null && this.customNameTranslate != null) {
                    name = "," + (String)name;
                }
                String customNameString = "{" + color + (String)name + "}";
                nbt.m_128359_("CustomName", customNameString);
            }
            nbt.m_128365_("Patterns", (Tag)patternList);
            nbt.m_128359_("id", "minecraft:banner");
            return nbt;
        }
    }
}

