/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network;

import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.util.LevelUtils;
import com.refinedmods.refinedstorage.util.NetworkUtils;
import com.refinedmods.refinedstorage.util.PlayerUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class NetworkNodeListener {
    @SubscribeEvent
    public void onBlockPlace(BlockEvent.EntityPlaceEvent e) {
        if (!e.getWorld().m_5776_() && e.getEntity() instanceof Player) {
            Player player = (Player)e.getEntity();
            INetworkNode placed = NetworkUtils.getNodeFromBlockEntity(e.getWorld().m_7702_(e.getPos()));
            if (placed != null) {
                for (Direction facing : Direction.values()) {
                    INetworkNode node = NetworkUtils.getNodeFromBlockEntity(e.getWorld().m_7702_(e.getBlockSnapshot().getPos().m_142300_(facing)));
                    if (node == null || node.getNetwork() == null || node.getNetwork().getSecurityManager().hasPermission(Permission.BUILD, player)) continue;
                    LevelUtils.sendNoPermissionMessage(player);
                    e.setCanceled(true);
                    PlayerUtils.updateHeldItems((ServerPlayer)player);
                    return;
                }
                this.discoverNode(e.getWorld(), e.getPos());
                placed.setOwner(player.m_36316_().getId());
            }
        }
    }

    private void discoverNode(LevelAccessor world, BlockPos pos) {
        for (Direction facing : Direction.values()) {
            INetworkNode node = NetworkUtils.getNodeFromBlockEntity(world.m_7702_(pos.m_142300_(facing)));
            if (node == null || node.getNetwork() == null) continue;
            node.getNetwork().getNodeGraph().invalidate(Action.PERFORM, node.getNetwork().getLevel(), node.getNetwork().getPosition());
            return;
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent e) {
        INetworkNode node;
        if (!e.getWorld().m_5776_() && (node = NetworkUtils.getNodeFromBlockEntity(e.getWorld().m_7702_(e.getPos()))) != null && node.getNetwork() != null && !node.getNetwork().getSecurityManager().hasPermission(Permission.BUILD, e.getPlayer())) {
            LevelUtils.sendNoPermissionMessage(e.getPlayer());
            e.setCanceled(true);
        }
    }
}

