/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.INetworkNodeVisitor;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.ConnectivityStateChangeCause;
import com.refinedmods.refinedstorage.block.BaseBlock;
import com.refinedmods.refinedstorage.block.NetworkNodeBlock;
import com.refinedmods.refinedstorage.blockentity.config.RedstoneMode;
import com.refinedmods.refinedstorage.util.NetworkUtils;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;

public abstract class NetworkNode
implements INetworkNode,
INetworkNodeVisitor {
    private static final String NBT_OWNER = "Owner";
    private static final String NBT_VERSION = "Version";
    private static final int CURRENT_VERSION = 1;
    @Nullable
    protected INetwork network;
    protected Level level;
    protected BlockPos pos;
    protected int ticks;
    protected RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    @Nullable
    protected UUID owner;
    protected String version;
    private boolean redstonePowered = false;
    private Direction direction;
    private boolean throttlingDisabled = true;
    private boolean couldUpdate;
    private int ticksSinceUpdateChanged;

    protected NetworkNode(Level level, BlockPos pos) {
        if (level == null) {
            throw new IllegalArgumentException("World cannot be null");
        }
        this.level = level;
        this.pos = pos;
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneMode redstoneMode) {
        this.redstoneMode = redstoneMode;
        this.markDirty();
    }

    @Override
    @Nonnull
    public ItemStack getItemStack() {
        return new ItemStack((ItemLike)Item.f_41373_.get(this.level.m_8055_(this.pos).m_60734_()), 1);
    }

    @Override
    public void onConnected(INetwork network) {
        this.onConnectedStateChange(network, true, ConnectivityStateChangeCause.GRAPH_CHANGE);
        this.network = network;
    }

    @Override
    public void onDisconnected(INetwork network) {
        this.network = null;
        this.onConnectedStateChange(network, false, ConnectivityStateChangeCause.GRAPH_CHANGE);
    }

    protected void onConnectedStateChange(INetwork network, boolean state, ConnectivityStateChangeCause cause) {
    }

    @Override
    public void markDirty() {
        if (!this.level.f_46443_) {
            API.instance().getNetworkNodeManager((ServerLevel)this.level).markForSaving();
        }
    }

    @Override
    public boolean isActive() {
        return this.redstoneMode.isEnabled(this.redstonePowered);
    }

    protected final boolean canUpdate() {
        if (this.isActive() && this.network != null) {
            return this.network.canRun();
        }
        return false;
    }

    protected int getUpdateThrottleInactiveToActive() {
        return 20;
    }

    protected int getUpdateThrottleActiveToInactive() {
        return 4;
    }

    public void setRedstonePowered(boolean redstonePowered) {
        this.redstonePowered = redstonePowered;
    }

    @Override
    public void update() {
        if (this.ticks == 0) {
            this.redstonePowered = this.level.m_46753_(this.pos);
        }
        ++this.ticks;
        boolean canUpdate = this.canUpdate();
        if (this.couldUpdate != canUpdate) {
            ++this.ticksSinceUpdateChanged;
            if ((!canUpdate ? this.ticksSinceUpdateChanged > this.getUpdateThrottleActiveToInactive() : this.ticksSinceUpdateChanged > this.getUpdateThrottleInactiveToActive()) || this.throttlingDisabled) {
                this.ticksSinceUpdateChanged = 0;
                this.couldUpdate = canUpdate;
                this.throttlingDisabled = false;
                BlockState blockState = this.level.m_8055_(this.pos);
                if (blockState.m_60734_() instanceof NetworkNodeBlock && ((NetworkNodeBlock)blockState.m_60734_()).hasConnectedState()) {
                    this.level.m_46597_(this.pos, (BlockState)this.level.m_8055_(this.pos).m_61124_((Property)NetworkNodeBlock.CONNECTED, (Comparable)Boolean.valueOf(canUpdate)));
                }
                if (this.network != null) {
                    this.onConnectedStateChange(this.network, canUpdate, ConnectivityStateChangeCause.REDSTONE_MODE_OR_NETWORK_ENERGY_CHANGE);
                    if (this.shouldRebuildGraphOnChange()) {
                        this.network.getNodeGraph().invalidate(Action.PERFORM, this.network.getLevel(), this.network.getPosition());
                    }
                }
            }
        } else {
            this.ticksSinceUpdateChanged = 0;
        }
    }

    @Override
    public CompoundTag write(CompoundTag tag) {
        if (this.owner != null) {
            tag.m_128362_(NBT_OWNER, this.owner);
        }
        tag.m_128405_(NBT_VERSION, 1);
        this.writeConfiguration(tag);
        return tag;
    }

    public CompoundTag writeConfiguration(CompoundTag tag) {
        this.redstoneMode.write(tag);
        return tag;
    }

    public void read(CompoundTag tag) {
        if (tag.m_128403_(NBT_OWNER)) {
            this.owner = tag.m_128342_(NBT_OWNER);
        }
        if (tag.m_128441_(NBT_VERSION)) {
            this.version = tag.m_128461_(NBT_VERSION);
        }
        this.readConfiguration(tag);
    }

    public void readConfiguration(CompoundTag tag) {
        this.redstoneMode = RedstoneMode.read(tag);
    }

    @Override
    @Nullable
    public INetwork getNetwork() {
        return this.network;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public boolean canConduct(Direction direction) {
        return true;
    }

    @Override
    public void visit(INetworkNodeVisitor.Operator operator) {
        for (Direction facing : Direction.values()) {
            INetworkNode oppositeNode = NetworkUtils.getNodeFromBlockEntity(this.level.m_7702_(this.pos.m_142300_(facing)));
            if (oppositeNode == null || !this.canConduct(facing) || !oppositeNode.canReceive(facing.m_122424_())) continue;
            operator.apply(this.level, this.pos.m_142300_(facing), facing.m_122424_());
        }
    }

    @Nullable
    public BlockEntity getFacingBlockEntity() {
        BlockPos facingPos = this.pos.m_142300_(this.getDirection());
        if (!this.level.m_46749_(facingPos)) {
            return null;
        }
        return this.level.m_7702_(facingPos);
    }

    public Direction getDirection() {
        BlockState state;
        if (this.direction == null && (state = this.level.m_8055_(this.pos)).m_60734_() instanceof BaseBlock) {
            this.direction = (Direction)state.m_61143_((Property)((BaseBlock)state.m_60734_()).getDirection().getProperty());
        }
        return this.direction;
    }

    public void onDirectionChanged(Direction direction) {
        this.direction = direction;
    }

    @Nullable
    public IItemHandler getDrops() {
        return null;
    }

    public boolean shouldRebuildGraphOnChange() {
        return false;
    }

    @Override
    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(@Nullable UUID owner) {
        this.owner = owner;
        this.markDirty();
    }
}

