/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.block;

import com.refinedmods.refinedstorage.api.network.node.ICoverable;
import com.refinedmods.refinedstorage.api.network.node.INetworkNodeProxy;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.Cover;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverType;
import com.refinedmods.refinedstorage.block.BlockDirection;
import com.refinedmods.refinedstorage.block.NetworkNodeBlock;
import com.refinedmods.refinedstorage.block.shape.ShapeCache;
import com.refinedmods.refinedstorage.blockentity.CableBlockEntity;
import com.refinedmods.refinedstorage.capability.NetworkNodeProxyCapability;
import com.refinedmods.refinedstorage.render.ConstantsCable;
import com.refinedmods.refinedstorage.util.BlockUtils;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CableBlock
extends NetworkNodeBlock
implements SimpleWaterloggedBlock {
    protected static final VoxelShape HOLDER_NORTH = CableBlock.m_49796_((double)7.0, (double)7.0, (double)2.0, (double)9.0, (double)9.0, (double)6.0);
    protected static final VoxelShape HOLDER_EAST = CableBlock.m_49796_((double)10.0, (double)7.0, (double)7.0, (double)14.0, (double)9.0, (double)9.0);
    protected static final VoxelShape HOLDER_SOUTH = CableBlock.m_49796_((double)7.0, (double)7.0, (double)10.0, (double)9.0, (double)9.0, (double)14.0);
    protected static final VoxelShape HOLDER_WEST = CableBlock.m_49796_((double)2.0, (double)7.0, (double)7.0, (double)6.0, (double)9.0, (double)9.0);
    protected static final VoxelShape HOLDER_UP = CableBlock.m_49796_((double)7.0, (double)10.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0);
    protected static final VoxelShape HOLDER_DOWN = CableBlock.m_49796_((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)6.0, (double)9.0);
    private static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    private static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    private static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    private static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    private static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");
    private static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");
    private static final BooleanProperty WATERLOGGED = BooleanProperty.m_61465_((String)"waterlogged");
    private static final VoxelShape SHAPE_CORE = CableBlock.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape SHAPE_NORTH = CableBlock.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0);
    private static final VoxelShape SHAPE_EAST = CableBlock.m_49796_((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final VoxelShape SHAPE_SOUTH = CableBlock.m_49796_((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = CableBlock.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0);
    private static final VoxelShape SHAPE_UP = CableBlock.m_49796_((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_DOWN = CableBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);

    public CableBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public CableBlock() {
        super(BlockUtils.DEFAULT_GLASS_PROPERTIES);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected static VoxelShape getCableShape(BlockState state) {
        VoxelShape shape = SHAPE_CORE;
        if (Boolean.TRUE.equals(state.m_61143_((Property)NORTH))) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_NORTH);
        }
        if (Boolean.TRUE.equals(state.m_61143_((Property)EAST))) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_EAST);
        }
        if (Boolean.TRUE.equals(state.m_61143_((Property)SOUTH))) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_SOUTH);
        }
        if (Boolean.TRUE.equals(state.m_61143_((Property)WEST))) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_WEST);
        }
        if (Boolean.TRUE.equals(state.m_61143_((Property)UP))) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_UP);
        }
        if (Boolean.TRUE.equals(state.m_61143_((Property)DOWN))) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_DOWN);
        }
        return shape;
    }

    public static boolean hasVisualConnectionOnSide(BlockState state, Direction direction) {
        switch (direction) {
            case DOWN: {
                return (Boolean)state.m_61143_((Property)DOWN);
            }
            case UP: {
                return (Boolean)state.m_61143_((Property)UP);
            }
            case NORTH: {
                return (Boolean)state.m_61143_((Property)NORTH);
            }
            case SOUTH: {
                return (Boolean)state.m_61143_((Property)SOUTH);
            }
            case WEST: {
                return (Boolean)state.m_61143_((Property)WEST);
            }
            case EAST: {
                return (Boolean)state.m_61143_((Property)EAST);
            }
        }
        return false;
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        return this.getState(state, world, pos);
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return ConstantsCable.addCoverVoxelShapes(ShapeCache.getOrCreate(state, CableBlock::getCableShape), world, pos);
    }

    @Override
    protected void onDirectionChanged(Level level, BlockPos pos, Direction newDirection) {
        level.m_46597_(pos, this.getState(level.m_8055_(pos), (LevelAccessor)level, pos));
        BlockDirection dir = this.getDirection();
        if (dir != BlockDirection.NONE && this.isSideCovered(level.m_7702_(pos), newDirection)) {
            BlockState newState = this.m_6843_(level.m_8055_(pos), Rotation.CLOCKWISE_90);
            level.m_46597_(pos, newState);
        }
        super.onDirectionChanged(level, pos, newDirection);
    }

    @Override
    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, blockIn, fromPos, isMoving);
        level.m_46597_(pos, this.getState(level.m_8055_(pos), (LevelAccessor)level, pos));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return this.getState(this.m_49966_(), (LevelAccessor)ctx.m_43725_(), ctx.m_8083_());
    }

    public FluidState m_5888_(BlockState state) {
        return Boolean.TRUE.equals(state.m_61143_((Property)WATERLOGGED)) ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7361_(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return super.m_7361_(worldIn, pos, state, fluidStateIn);
    }

    public boolean m_6044_(BlockGetter worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return super.m_6044_(worldIn, pos, state, fluidIn);
    }

    private boolean hasNodeConnection(LevelAccessor world, BlockPos pos, BlockState state, Direction direction) {
        if (this.getDirection() != BlockDirection.NONE && ((Direction)state.m_61143_((Property)this.getDirection().getProperty())).m_122424_() == direction) {
            return false;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity == null) {
            return false;
        }
        return blockEntity.getCapability(NetworkNodeProxyCapability.NETWORK_NODE_PROXY_CAPABILITY, direction).isPresent() && !this.isSideCovered(blockEntity, direction) && !this.isSideCovered(world.m_7702_(pos.m_142300_(direction)), direction.m_122424_());
    }

    private boolean isSideCovered(BlockEntity blockEntity, Direction direction) {
        if (blockEntity == null) {
            return false;
        }
        Optional node = blockEntity.getCapability(NetworkNodeProxyCapability.NETWORK_NODE_PROXY_CAPABILITY, direction).map(INetworkNodeProxy::getNode);
        if (node.isPresent() && node.get() instanceof ICoverable) {
            Cover cover = ((ICoverable)node.get()).getCoverManager().getCover(direction);
            if (cover == null) {
                return false;
            }
            return cover.getType() == CoverType.NORMAL;
        }
        return false;
    }

    private BlockState getState(BlockState currentState, LevelAccessor world, BlockPos pos) {
        boolean north = this.hasNodeConnection(world, pos.m_142300_(Direction.NORTH), currentState, Direction.SOUTH);
        boolean east = this.hasNodeConnection(world, pos.m_142300_(Direction.EAST), currentState, Direction.WEST);
        boolean south = this.hasNodeConnection(world, pos.m_142300_(Direction.SOUTH), currentState, Direction.NORTH);
        boolean west = this.hasNodeConnection(world, pos.m_142300_(Direction.WEST), currentState, Direction.EAST);
        boolean up = this.hasNodeConnection(world, pos.m_142300_(Direction.UP), currentState, Direction.DOWN);
        boolean down = this.hasNodeConnection(world, pos.m_142300_(Direction.DOWN), currentState, Direction.UP);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)currentState.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(north))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(east))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(south))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(west))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(up))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(down));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CableBlockEntity(pos, state);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, WATERLOGGED});
    }
}

