/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.blockentity;

import com.refinedmods.refinedstorage.RSBlockEntities;
import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.api.storage.externalstorage.IExternalStorage;
import com.refinedmods.refinedstorage.apiimpl.network.node.ExternalStorageNetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.refinedmods.refinedstorage.blockentity.NetworkNodeBlockEntity;
import com.refinedmods.refinedstorage.blockentity.config.IAccessType;
import com.refinedmods.refinedstorage.blockentity.config.IComparable;
import com.refinedmods.refinedstorage.blockentity.config.IPrioritizable;
import com.refinedmods.refinedstorage.blockentity.config.IType;
import com.refinedmods.refinedstorage.blockentity.config.IWhitelistBlacklist;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationParameter;
import com.refinedmods.refinedstorage.blockentity.data.RSSerializers;
import com.refinedmods.refinedstorage.util.LevelUtils;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;

public class ExternalStorageBlockEntity
extends NetworkNodeBlockEntity<ExternalStorageNetworkNode> {
    public static final BlockEntitySynchronizationParameter<Integer, ExternalStorageBlockEntity> PRIORITY = IPrioritizable.createParameter();
    public static final BlockEntitySynchronizationParameter<Integer, ExternalStorageBlockEntity> COMPARE = IComparable.createParameter();
    public static final BlockEntitySynchronizationParameter<Integer, ExternalStorageBlockEntity> WHITELIST_BLACKLIST = IWhitelistBlacklist.createParameter();
    public static final BlockEntitySynchronizationParameter<Integer, ExternalStorageBlockEntity> TYPE = IType.createParameter();
    public static final BlockEntitySynchronizationParameter<AccessType, ExternalStorageBlockEntity> ACCESS_TYPE = IAccessType.createParameter();
    public static final BlockEntitySynchronizationParameter<Long, ExternalStorageBlockEntity> STORED = new BlockEntitySynchronizationParameter<Long, ExternalStorageBlockEntity>(RSSerializers.LONG_SERIALIZER, 0L, t -> {
        long stored = 0L;
        for (IExternalStorage<ItemStack> iExternalStorage : ((ExternalStorageNetworkNode)t.getNode()).getItemStorages()) {
            stored += (long)iExternalStorage.getStored();
        }
        for (IExternalStorage<ItemStack> iExternalStorage : ((ExternalStorageNetworkNode)t.getNode()).getFluidStorages()) {
            stored += (long)iExternalStorage.getStored();
        }
        return stored;
    });
    public static final BlockEntitySynchronizationParameter<Long, ExternalStorageBlockEntity> CAPACITY = new BlockEntitySynchronizationParameter<Long, ExternalStorageBlockEntity>(RSSerializers.LONG_SERIALIZER, 0L, t -> {
        long capacity = 0L;
        for (IExternalStorage<ItemStack> iExternalStorage : ((ExternalStorageNetworkNode)t.getNode()).getItemStorages()) {
            capacity += iExternalStorage.getCapacity();
        }
        for (IExternalStorage<ItemStack> iExternalStorage : ((ExternalStorageNetworkNode)t.getNode()).getFluidStorages()) {
            capacity += iExternalStorage.getCapacity();
        }
        return capacity;
    });
    public static final BlockEntitySynchronizationParameter<CompoundTag, ExternalStorageBlockEntity> COVER_MANAGER = new BlockEntitySynchronizationParameter<CompoundTag, ExternalStorageBlockEntity>(EntityDataSerializers.f_135042_, new CompoundTag(), t -> ((ExternalStorageNetworkNode)t.getNode()).getCoverManager().writeToNbt(), (t, v) -> ((ExternalStorageNetworkNode)t.getNode()).getCoverManager().readFromNbt((CompoundTag)v), (initial, p) -> {});

    public ExternalStorageBlockEntity(BlockPos pos, BlockState state) {
        super(RSBlockEntities.EXTERNAL_STORAGE, pos, state);
        this.dataManager.addWatchedParameter(PRIORITY);
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(WHITELIST_BLACKLIST);
        this.dataManager.addWatchedParameter(STORED);
        this.dataManager.addWatchedParameter(CAPACITY);
        this.dataManager.addWatchedParameter(TYPE);
        this.dataManager.addWatchedParameter(ACCESS_TYPE);
        this.dataManager.addWatchedParameter(COVER_MANAGER);
    }

    @Override
    @Nonnull
    public ExternalStorageNetworkNode createNode(Level level, BlockPos pos) {
        return new ExternalStorageNetworkNode(level, pos);
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(CoverManager.PROPERTY, (Object)((ExternalStorageNetworkNode)this.getNode()).getCoverManager()).build();
    }

    @Override
    public CompoundTag writeUpdate(CompoundTag tag) {
        super.writeUpdate(tag);
        tag.m_128365_(CoverManager.NBT_COVER_MANAGER, (Tag)((ExternalStorageNetworkNode)this.getNode()).getCoverManager().writeToNbt());
        return tag;
    }

    @Override
    public void readUpdate(CompoundTag tag) {
        super.readUpdate(tag);
        ((ExternalStorageNetworkNode)this.getNode()).getCoverManager().readFromNbt(tag.m_128469_(CoverManager.NBT_COVER_MANAGER));
        this.requestModelDataUpdate();
        LevelUtils.updateBlock(this.f_58857_, this.f_58858_);
    }
}

