/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.container;

import com.refinedmods.refinedstorage.RSContainerMenus;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.apiimpl.network.node.CrafterManagerNetworkNode;
import com.refinedmods.refinedstorage.blockentity.CrafterManagerBlockEntity;
import com.refinedmods.refinedstorage.container.BaseContainerMenu;
import com.refinedmods.refinedstorage.container.slot.CrafterManagerSlot;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.validator.PatternItemValidator;
import com.refinedmods.refinedstorage.item.PatternItem;
import com.refinedmods.refinedstorage.screen.IScreenInfoProvider;
import com.refinedmods.refinedstorage.screen.grid.filtering.GridFilterParser;
import com.refinedmods.refinedstorage.screen.grid.stack.IGridStack;
import com.refinedmods.refinedstorage.screen.grid.stack.ItemGridStack;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class CrafterManagerContainerMenu
extends BaseContainerMenu {
    private final CrafterManagerNetworkNode crafterManager;
    private final Map<String, IItemHandlerModifiable> dummyInventories = new HashMap<String, IItemHandlerModifiable>();
    private final Map<String, Integer> headings = new HashMap<String, Integer>();
    private IScreenInfoProvider screenInfoProvider;
    private Map<String, Integer> containerData;
    private int rows;

    public CrafterManagerContainerMenu(CrafterManagerBlockEntity crafterManager, Player player, int windowId) {
        super(RSContainerMenus.CRAFTER_MANAGER, crafterManager, player, windowId);
        this.crafterManager = (CrafterManagerNetworkNode)crafterManager.getNode();
    }

    public void setScreenInfoProvider(IScreenInfoProvider infoProvider) {
        this.screenInfoProvider = infoProvider;
    }

    public void initSlotsServer() {
        this.addPlayerInventory(8, this.screenInfoProvider.getYPlayerInventory());
        if (this.crafterManager.getNetwork() != null) {
            for (Map.Entry<Component, List<IItemHandlerModifiable>> entry : this.crafterManager.getNetwork().getCraftingManager().getNamedContainers().entrySet()) {
                for (IItemHandlerModifiable handler : entry.getValue()) {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        this.m_38897_((Slot)new CrafterManagerSlot((IItemHandler)handler, i, 0, 0, true, this.screenInfoProvider, this.crafterManager));
                    }
                }
            }
        }
    }

    public void initSlots(@Nullable Map<String, Integer> data) {
        if (data != null) {
            this.containerData = data;
        }
        this.f_38839_.clear();
        this.f_38841_.clear();
        this.headings.clear();
        this.rows = 0;
        this.addPlayerInventory(8, this.screenInfoProvider.getYPlayerInventory());
        int y = 37 - this.screenInfoProvider.getCurrentOffset() * 18;
        int x = 8;
        Predicate<IGridStack> filters = GridFilterParser.getFilters(null, this.screenInfoProvider.getSearchFieldText(), Collections.emptyList());
        for (Map.Entry<String, Integer> category : this.containerData.entrySet()) {
            Object dummy;
            if (data == null) {
                dummy = this.dummyInventories.get(category.getKey());
            } else {
                dummy = new BaseItemHandler(category.getValue()){

                    public int getSlotLimit(int slot) {
                        return 1;
                    }

                    @Override
                    @Nonnull
                    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                        if (new PatternItemValidator(CrafterManagerContainerMenu.this.getPlayer().m_20193_()).test(stack)) {
                            return super.insertItem(slot, stack, simulate);
                        }
                        return stack;
                    }
                };
                this.dummyInventories.put(category.getKey(), (IItemHandlerModifiable)dummy);
            }
            boolean foundItemsInCategory = false;
            int yHeading = y - 19;
            int slotFound = 0;
            for (int slot = 0; slot < category.getValue(); ++slot) {
                boolean visible = true;
                if (!this.screenInfoProvider.getSearchFieldText().trim().isEmpty()) {
                    ItemStack stack = dummy.getStackInSlot(slot);
                    if (stack.m_41619_()) {
                        visible = false;
                    } else {
                        ICraftingPattern pattern = PatternItem.fromCache(this.crafterManager.getLevel(), stack);
                        visible = false;
                        if (pattern.isValid()) {
                            for (ItemStack output : pattern.getOutputs()) {
                                ItemGridStack outputConverted = new ItemGridStack(output);
                                if (!filters.test(outputConverted)) continue;
                                visible = true;
                                break;
                            }
                        }
                    }
                }
                this.m_38897_((Slot)new CrafterManagerSlot((IItemHandler)dummy, slot, x, y, visible, this.screenInfoProvider, this.crafterManager));
                if (!visible) continue;
                foundItemsInCategory = true;
                x += 18;
                if ((slotFound + 1) % 9 == 0 && slot + 1 < category.getValue()) {
                    x = 8;
                    y += 18;
                    ++this.rows;
                }
                ++slotFound;
            }
            if (!foundItemsInCategory) continue;
            this.headings.put(category.getKey(), yHeading);
            x = 8;
            y += 36;
            this.rows += 2;
        }
    }

    public Map<String, Integer> getHeadings() {
        return this.headings;
    }

    public int getRows() {
        return this.rows;
    }

    @Override
    public ItemStack m_7648_(Player player, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = this.m_38853_(index);
        if (slot.m_6657_()) {
            stack = slot.m_7993_();
            if (!new PatternItemValidator(this.getPlayer().m_20193_()).test(stack)) {
                return ItemStack.f_41583_;
            }
            if (index < 36 ? !this.m_38903_(stack, 36, this.f_38839_.size(), false) : !this.m_38903_(stack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return stack;
    }
}

