/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.item;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.RSItems;
import com.refinedmods.refinedstorage.container.FilterContainerMenu;
import com.refinedmods.refinedstorage.inventory.fluid.ConfiguredFluidsInFilterItemHandler;
import com.refinedmods.refinedstorage.inventory.item.ConfiguredItemsInFilterItemHandler;
import com.refinedmods.refinedstorage.render.Styles;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class FilterItem
extends Item {
    public static final String NBT_FLUID_FILTERS = "FluidFilters";
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_MOD_FILTER = "ModFilter";
    private static final String NBT_NAME = "Name";
    private static final String NBT_ICON = "Icon";
    private static final String NBT_FLUID_ICON = "FluidIcon";
    private static final String NBT_TYPE = "Type";

    public FilterItem() {
        super(new Item.Properties().m_41491_(RS.CREATIVE_MODE_TAB).m_41487_(1));
    }

    public static int getCompare(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(NBT_COMPARE) ? stack.m_41783_().m_128451_(NBT_COMPARE) : 1;
    }

    public static void setCompare(ItemStack stack, int compare) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        stack.m_41783_().m_128405_(NBT_COMPARE, compare);
    }

    public static int getMode(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(NBT_MODE) ? stack.m_41783_().m_128451_(NBT_MODE) : 0;
    }

    public static void setMode(ItemStack stack, int mode) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        stack.m_41783_().m_128405_(NBT_MODE, mode);
    }

    public static boolean isModFilter(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(NBT_MOD_FILTER) && stack.m_41783_().m_128471_(NBT_MOD_FILTER);
    }

    public static void setModFilter(ItemStack stack, boolean modFilter) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        stack.m_41783_().m_128379_(NBT_MOD_FILTER, modFilter);
    }

    public static String getFilterName(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(NBT_NAME) ? stack.m_41783_().m_128461_(NBT_NAME) : "";
    }

    public static void setName(ItemStack stack, String name) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        stack.m_41783_().m_128359_(NBT_NAME, name);
    }

    @Nonnull
    public static ItemStack getIcon(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(NBT_ICON) ? ItemStack.m_41712_((CompoundTag)stack.m_41783_().m_128469_(NBT_ICON)) : ItemStack.f_41583_;
    }

    public static void setIcon(ItemStack stack, ItemStack icon) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        stack.m_41783_().m_128365_(NBT_ICON, (Tag)icon.serializeNBT());
    }

    public static void setFluidIcon(ItemStack stack, @Nullable FluidStack icon) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        if (icon == null) {
            stack.m_41783_().m_128473_(NBT_FLUID_ICON);
        } else {
            stack.m_41783_().m_128365_(NBT_FLUID_ICON, (Tag)icon.writeToNBT(new CompoundTag()));
        }
    }

    @Nonnull
    public static FluidStack getFluidIcon(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(NBT_FLUID_ICON) ? FluidStack.loadFluidStackFromNBT((CompoundTag)stack.m_41783_().m_128469_(NBT_FLUID_ICON)) : FluidStack.EMPTY;
    }

    public static int getType(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(NBT_TYPE) ? stack.m_41783_().m_128451_(NBT_TYPE) : 0;
    }

    public static void setType(ItemStack stack, int type) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        stack.m_41783_().m_128405_(NBT_TYPE, type);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_) {
            if (player.m_6047_()) {
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)new ItemStack((ItemLike)RSItems.FILTER.get()));
            }
            player.m_5893_(new MenuProvider(){

                public Component m_5446_() {
                    return new TranslatableComponent("gui.refinedstorage.filter");
                }

                public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
                    return new FilterContainerMenu(player, inventory.m_36056_(), windowId);
                }
            });
        }
        return new InteractionResultHolder(InteractionResult.CONSUME, (Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)new TranslatableComponent("sidebutton.refinedstorage.mode." + (FilterItem.getMode(stack) == 0 ? "whitelist" : "blacklist")).m_6270_(Styles.YELLOW));
        if (FilterItem.isModFilter(stack)) {
            tooltip.add((Component)new TranslatableComponent("gui.refinedstorage.filter.mod_filter").m_6270_(Styles.BLUE));
        }
        RenderUtils.addCombinedItemsToTooltip(tooltip, false, new ConfiguredItemsInFilterItemHandler(stack).getConfiguredItems());
        RenderUtils.addCombinedFluidsToTooltip(tooltip, false, new ConfiguredFluidsInFilterItemHandler(stack).getConfiguredFluids());
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }
}

