/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.network;

import com.google.common.primitives.Bytes;
import com.refinedmods.refinedstorage.network.PacketSplittingException;
import com.refinedmods.refinedstorage.network.SplitPacketMessage;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;

public class PacketSplitter {
    private static final int MAX_PACKET_SIZE = 943718;
    private static final Map<Integer, Map<Integer, byte[]>> PACKAGE_CACHE = new HashMap<Integer, Map<Integer, byte[]>>();
    private final ResourceLocation channelId;
    private final SimpleChannel channel;
    private final Map<Integer, ServerPlayer> messageTargets = new HashMap<Integer, ServerPlayer>();
    private final Map<Integer, Integer> packetMaximums = new HashMap<Integer, Integer>();
    private final Set<Class<?>> messagesToSplit = new HashSet();
    private final int maxNumberOfMessages;
    private int comId = 0;
    private int id;

    public PacketSplitter(int maxNumberOfMessages, SimpleChannel channel, ResourceLocation CHANNEL_ID) {
        this.maxNumberOfMessages = maxNumberOfMessages;
        this.channel = channel;
        this.channelId = CHANNEL_ID;
    }

    public boolean shouldMessageBeSplit(Class<?> clazz) {
        return this.messagesToSplit.contains(clazz);
    }

    public void sendToPlayer(ServerPlayer player, Object message) {
        if (this.id == 0) {
            ++this.id;
        }
        int id = this.id++;
        this.messageTargets.put(id, player);
        this.sendPacket(message, id, PacketDistributor.PLAYER.with(() -> player));
    }

    public void sendToServer(Object message) {
        this.messageTargets.put(0, null);
        this.sendPacket(message, 0, PacketDistributor.SERVER.noArg());
    }

    private void sendPacket(Object Message, int id, PacketDistributor.PacketTarget target) {
        FriendlyByteBuf bufIn = new FriendlyByteBuf(Unpooled.buffer());
        bufIn.writeInt(id);
        int index = this.channel.encodeMessage(Message, bufIn);
        target.send(target.getDirection().buildPacket(Pair.of((Object)bufIn, (Object)index), this.channelId).getThis());
    }

    public <MSG> void registerMessage(int index, Class<MSG> messageType, BiConsumer<MSG, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> messageConsumer) {
        this.registerMessage(index, this.maxNumberOfMessages, messageType, encoder, decoder, messageConsumer);
    }

    public <MSG> void registerMessage(int index, int maxNumberOfMessages, Class<MSG> messageType, BiConsumer<MSG, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> messageConsumer) {
        this.packetMaximums.put(index, maxNumberOfMessages);
        this.messagesToSplit.add(messageType);
        BiConsumer<Object, FriendlyByteBuf> wrappedEncoder = (msg, buffer) -> {
            int id = buffer.readInt();
            buffer.discardReadBytes();
            ServerPlayer player = this.messageTargets.get(id);
            this.messageTargets.remove(id);
            buffer.writeShort(0);
            encoder.accept((Object)msg, (FriendlyByteBuf)buffer);
            this.createSplittingConsumer(player).accept((Object)msg, (FriendlyByteBuf)buffer);
        };
        this.channel.registerMessage(index, messageType, wrappedEncoder, this.createPacketCombiner().andThen(decoder), messageConsumer);
    }

    private <MSG> BiConsumer<MSG, FriendlyByteBuf> createSplittingConsumer(ServerPlayer playerEntity) {
        return (MSG, buf) -> {
            int sliceSize;
            if (buf.writerIndex() < 943718) {
                return;
            }
            short packetId = buf.readUnsignedByte();
            buf.readShort();
            int packetIndex = 0;
            int comId = this.comId++;
            byte[] packetData = new byte[]{};
            int maximumPackets = this.packetMaximums.get(packetId);
            int expectedPackets = buf.writerIndex() / 943718 + 1;
            boolean failure = false;
            for (int currentIndex = buf.readerIndex(); currentIndex < buf.writerIndex(); currentIndex += sliceSize) {
                sliceSize = Math.min(943718, buf.writerIndex() - currentIndex);
                byte[] subPacketData = Arrays.copyOfRange(buf.array(), currentIndex, currentIndex + sliceSize);
                if (packetIndex == 0) {
                    packetData = subPacketData;
                    ++packetIndex;
                    continue;
                }
                SplitPacketMessage splitPacketMessage = new SplitPacketMessage(comId, packetIndex++, subPacketData);
                if (playerEntity == null) {
                    this.channel.send(PacketDistributor.SERVER.noArg(), (Object)splitPacketMessage);
                    continue;
                }
                this.channel.send(PacketDistributor.PLAYER.with(() -> playerEntity), (Object)splitPacketMessage);
                if (packetIndex <= maximumPackets) continue;
                LogManager.getLogger().error("Failure Splitting Packets on Channel \"" + this.channelId + "\". with " + MSG.getClass() + ".  Number of Packets sent " + (packetIndex - 1) + ", expected number of Packets " + expectedPackets + ", maximum number of packets for a message of this type " + this.packetMaximums.get(packetId));
                failure = true;
                break;
            }
            buf.setIndex(0, 0);
            buf.writeByte((int)packetId);
            buf.writeShort(failure ? expectedPackets : packetIndex);
            buf.writeInt(comId);
            buf.m_130087_(packetData);
            buf.capacity(buf.writerIndex());
        };
    }

    private Function<FriendlyByteBuf, FriendlyByteBuf> createPacketCombiner() {
        return buf -> {
            short size = buf.readShort();
            if (size < 2) {
                return buf;
            }
            int comId = buf.readInt();
            Map<Integer, byte[]> partsMap = PACKAGE_CACHE.get(comId);
            if (partsMap == null || partsMap.size() != size - 1) {
                int partSize = partsMap == null ? 0 : partsMap.size();
                short id = buf.readUnsignedByte();
                int max = this.packetMaximums.get(id) == null ? 0 : this.packetMaximums.get(id);
                throw new PacketSplittingException(this.channelId, partSize, size, max, id);
            }
            this.addPackagePart(comId, 0, buf.m_130052_());
            byte[] packetData = partsMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).reduce(new byte[0], (xva$0, xva$1) -> Bytes.concat((byte[][])new byte[][]{xva$0, xva$1}));
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])packetData));
            PACKAGE_CACHE.remove(comId);
            return buffer;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPackagePart(int communicationId, int packetIndex, byte[] payload) {
        Map<Integer, Map<Integer, byte[]>> map = PACKAGE_CACHE;
        synchronized (map) {
            PACKAGE_CACHE.computeIfAbsent(communicationId, id -> new ConcurrentHashMap());
            PACKAGE_CACHE.get(communicationId).put(packetIndex, payload);
        }
    }
}

