/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.render.model;

import com.google.common.collect.ImmutableList;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.TRSRTransformer;
import net.minecraftforge.common.model.TransformationHelper;

public final class QuadTransformer {
    private QuadTransformer() {
    }

    public static List<BakedQuad> getTransformedQuads(BakedModel model, Direction facing, @Nullable Vector3f translation, BlockState state, Random rand, Direction side) {
        double r = Math.PI * (double)(360 - facing.m_122424_().m_122416_() * 90) / 180.0;
        Transformation transformation = new Transformation(translation, TransformationHelper.quatFromXYZ((Vector3f)new Vector3f(0.0f, (float)r, 0.0f), (boolean)false), null, null);
        ImmutableList.Builder quads = ImmutableList.builder();
        if (side != null && side.m_122416_() > -1) {
            int faceOffset = 4 + Direction.NORTH.m_122416_() - facing.m_122416_();
            side = Direction.m_122407_((int)((side.m_122416_() + faceOffset) % 4));
        }
        for (BakedQuad quad : model.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE)) {
            BakedQuadBuilder builder = new BakedQuadBuilder(quad.m_173410_());
            TRSRTransformer transformer = new TRSRTransformer((IVertexConsumer)builder, transformation.blockCenterToCorner());
            quad.pipe((IVertexConsumer)transformer);
            quads.add((Object)builder.build());
        }
        return quads.build();
    }
}

