/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.RSKeyBindings;
import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.integration.jei.JeiIntegration;
import com.refinedmods.refinedstorage.integration.jei.RSJeiPlugin;
import com.refinedmods.refinedstorage.render.RenderSettings;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class SearchWidget
extends EditBox {
    private static final List<String> HISTORY = new ArrayList<String>();
    private int mode;
    private int historyIndex;

    public SearchWidget(Font fontRenderer, int x, int y, int width) {
        Objects.requireNonNull(fontRenderer);
        super(fontRenderer, x, y, width, 9, (Component)new TextComponent(""));
        this.historyIndex = -1;
        this.m_94182_(false);
        this.m_94194_(true);
        this.m_94202_(RenderSettings.INSTANCE.getSecondaryColor());
    }

    public void updateJei() {
        if (this.canSyncToJEINow()) {
            RSJeiPlugin.getRuntime().getIngredientFilter().setFilterText(this.m_94155_());
        }
    }

    private boolean canSyncToJEINow() {
        return IGrid.doesSearchBoxModeUseJEI(this.mode) && JeiIntegration.isLoaded();
    }

    private boolean canSyncFromJEINow() {
        return (this.mode == 4 || this.mode == 5) && JeiIntegration.isLoaded();
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        boolean clickedWidget;
        boolean wasFocused = this.m_93696_();
        boolean result = super.m_6375_(mouseX, mouseY, mouseButton);
        boolean bl = clickedWidget = mouseX >= (double)this.f_93620_ && mouseX < (double)(this.f_93620_ + this.f_93618_) && mouseY >= (double)this.f_93621_ && mouseY < (double)(this.f_93621_ + this.f_93619_);
        if (clickedWidget && mouseButton == 1) {
            this.m_94144_("");
            this.m_93692_(true);
        } else if (wasFocused != this.m_93696_()) {
            this.saveHistory();
        }
        return result;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifier) {
        boolean result = super.m_7933_(keyCode, scanCode, modifier);
        if (this.m_93696_()) {
            if (keyCode == 265) {
                this.updateHistory(-1);
                result = true;
            } else if (keyCode == 264) {
                this.updateHistory(1);
                result = true;
            } else if (keyCode == 257 || keyCode == 335) {
                this.saveHistory();
                if (this.f_94097_) {
                    this.m_93692_(false);
                }
                result = true;
            } else if (keyCode == 256) {
                this.saveHistory();
                if (!this.f_94097_) {
                    this.m_93692_(false);
                    result = false;
                } else {
                    this.m_93692_(false);
                    result = true;
                }
            }
        }
        if (BaseScreen.isKeyDown(RSKeyBindings.FOCUS_SEARCH_BAR) && this.f_94097_) {
            this.m_93692_(!this.m_93696_());
            this.saveHistory();
            result = true;
        }
        return result;
    }

    private void updateHistory(int delta) {
        if (HISTORY.isEmpty()) {
            return;
        }
        if (this.historyIndex == -1) {
            this.historyIndex = HISTORY.size();
        }
        this.historyIndex += delta;
        if (this.historyIndex < 0) {
            this.historyIndex = 0;
        } else if (this.historyIndex > HISTORY.size() - 1) {
            this.historyIndex = HISTORY.size() - 1;
            if (delta == 1) {
                this.m_94144_("");
                return;
            }
        }
        this.m_94144_(HISTORY.get(this.historyIndex));
    }

    private void saveHistory() {
        if (!HISTORY.isEmpty() && HISTORY.get(HISTORY.size() - 1).equals(this.m_94155_())) {
            return;
        }
        if (!this.m_94155_().trim().isEmpty()) {
            HISTORY.add(this.m_94155_());
        }
    }

    public void setMode(int mode) {
        this.mode = mode;
        this.m_94190_(!IGrid.isSearchBoxModeWithAutoselection(mode));
        this.m_93692_(IGrid.isSearchBoxModeWithAutoselection(mode));
        if (this.canSyncFromJEINow()) {
            this.setTextFromJEI();
        }
    }

    private void setTextFromJEI() {
        String filterText = RSJeiPlugin.getRuntime().getIngredientFilter().getFilterText();
        if (!this.m_94155_().equals(filterText)) {
            this.m_94144_(filterText);
        }
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.canSyncFromJEINow() && RSJeiPlugin.getRuntime().getIngredientListOverlay().hasKeyboardFocus()) {
            this.setTextFromJEI();
        }
        super.m_6303_(poseStack, mouseX, mouseY, partialTicks);
    }
}

