/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.util;

import com.google.common.collect.ImmutableMap;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.render.Styles;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fluids.FluidStack;

public final class RenderUtils {
    private static ImmutableMap<ItemTransforms.TransformType, Transformation> DEFAULT_BLOCK_TRANSFORM;

    private RenderUtils() {
    }

    public static String shorten(String text, int length) {
        if (((String)text).length() > length) {
            text = ((String)text).substring(0, length) + "...";
        }
        return text;
    }

    public static int getOffsetOnScale(int pos, float scale) {
        float multiplier = (float)pos / scale;
        return (int)multiplier;
    }

    public static void addCombinedItemsToTooltip(List<Component> tooltip, boolean displayAmount, List<ItemStack> stacks) {
        HashSet<Integer> combinedIndices = new HashSet<Integer>();
        for (int i = 0; i < stacks.size(); ++i) {
            if (stacks.get(i).m_41619_() || combinedIndices.contains(i)) continue;
            ItemStack stack = stacks.get(i);
            MutableComponent data = stack.m_41786_().m_6879_();
            int amount = stack.m_41613_();
            for (int j = i + 1; j < stacks.size(); ++j) {
                if (!API.instance().getComparer().isEqual(stack, stacks.get(j))) continue;
                amount += stacks.get(j).m_41613_();
                combinedIndices.add(j);
            }
            if (displayAmount) {
                data = new TextComponent(amount + "x ").m_7220_((Component)data);
            }
            tooltip.add((Component)data.m_6270_(Styles.GRAY));
        }
    }

    public static void addCombinedFluidsToTooltip(List<Component> tooltip, boolean displayMb, List<FluidStack> stacks) {
        HashSet<Integer> combinedIndices = new HashSet<Integer>();
        for (int i = 0; i < stacks.size(); ++i) {
            if (stacks.get(i).isEmpty() || combinedIndices.contains(i)) continue;
            FluidStack stack = stacks.get(i);
            MutableComponent data = stack.getDisplayName().m_6879_();
            int amount = stack.getAmount();
            for (int j = i + 1; j < stacks.size(); ++j) {
                if (!API.instance().getComparer().isEqual(stack, stacks.get(j), 1)) continue;
                amount += stacks.get(j).getAmount();
                combinedIndices.add(j);
            }
            if (displayMb) {
                data = new TextComponent(API.instance().getQuantityFormatter().formatInBucketForm(amount) + " ").m_7220_((Component)data);
            }
            tooltip.add((Component)data.m_6270_(Styles.GRAY));
        }
    }

    public static List<Component> getTooltipFromItem(ItemStack stack) {
        Minecraft minecraft = Minecraft.m_91087_();
        return stack.m_41651_((Player)minecraft.f_91074_, (TooltipFlag)(minecraft.f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
    }

    public static boolean inBounds(int x, int y, int w, int h, double ox, double oy) {
        return ox >= (double)x && ox <= (double)(x + w) && oy >= (double)y && oy <= (double)(y + h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TextureAtlasSprite getSprite(BakedModel coverModel, BlockState coverState, Direction facing, Random rand) {
        Iterator iterator;
        TextureAtlasSprite sprite = null;
        RenderType originalType = MinecraftForgeClient.getRenderType();
        try {
            iterator = RenderType.m_110506_().iterator();
            while (iterator.hasNext()) {
                RenderType layer = (RenderType)iterator.next();
                ForgeHooksClient.setRenderType((RenderType)layer);
                Iterator iterator2 = coverModel.m_6840_(coverState, facing, rand).iterator();
                if (iterator2.hasNext()) {
                    BakedQuad bakedQuad = (BakedQuad)iterator2.next();
                    TextureAtlasSprite textureAtlasSprite = bakedQuad.m_173410_();
                    return textureAtlasSprite;
                }
                for (BakedQuad bakedQuad : coverModel.m_6840_(coverState, null, rand)) {
                    if (sprite == null) {
                        sprite = bakedQuad.m_173410_();
                    }
                    if (bakedQuad.m_111306_() != facing) continue;
                    TextureAtlasSprite textureAtlasSprite = bakedQuad.m_173410_();
                    return textureAtlasSprite;
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            ForgeHooksClient.setRenderType((RenderType)originalType);
        }
        if (sprite == null) {
            try {
                sprite = coverModel.m_6160_();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (sprite == null && (iterator = Minecraft.m_91087_().m_91304_().m_119409_().m_6840_(coverState, facing, rand).iterator()).hasNext()) {
            BakedQuad quad = (BakedQuad)iterator.next();
            return quad.m_173410_();
        }
        return sprite;
    }

    public static ImmutableMap<ItemTransforms.TransformType, Transformation> getDefaultBlockTransforms() {
        if (DEFAULT_BLOCK_TRANSFORM != null) {
            return DEFAULT_BLOCK_TRANSFORM;
        }
        Transformation thirdperson = RenderUtils.getTransform(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f);
        DEFAULT_BLOCK_TRANSFORM = ImmutableMap.builder().put((Object)ItemTransforms.TransformType.GUI, (Object)RenderUtils.getTransform(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f)).put((Object)ItemTransforms.TransformType.GROUND, (Object)RenderUtils.getTransform(0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f)).put((Object)ItemTransforms.TransformType.FIXED, (Object)RenderUtils.getTransform(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f)).put((Object)ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)thirdperson).put((Object)ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)RenderUtils.leftifyTransform(thirdperson)).put((Object)ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)RenderUtils.getTransform(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f)).put((Object)ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)RenderUtils.getTransform(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f)).build();
        return DEFAULT_BLOCK_TRANSFORM;
    }

    private static Transformation leftifyTransform(Transformation transform) {
        return transform.blockCornerToCenter().blockCenterToCorner();
    }

    private static Transformation getTransform(float tx, float ty, float tz, float ax, float ay, float az, float s) {
        return new Transformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), new Quaternion(ax, ay, az, true), new Vector3f(s, s, s), null);
    }
}

