/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.block;

import com.google.common.collect.Lists;
import com.ldtteam.domumornamentum.block.ArchitectsCutterBlock;
import com.ldtteam.domumornamentum.block.IModBlocks;
import com.ldtteam.domumornamentum.block.ModCreativeTabs;
import com.ldtteam.domumornamentum.block.decorative.BarrelBlock;
import com.ldtteam.domumornamentum.block.decorative.BrickBlock;
import com.ldtteam.domumornamentum.block.decorative.ExtraBlock;
import com.ldtteam.domumornamentum.block.decorative.FancyDoorBlock;
import com.ldtteam.domumornamentum.block.decorative.FancyTrapdoorBlock;
import com.ldtteam.domumornamentum.block.decorative.FloatingCarpetBlock;
import com.ldtteam.domumornamentum.block.decorative.PanelBlock;
import com.ldtteam.domumornamentum.block.decorative.PaperWallBlock;
import com.ldtteam.domumornamentum.block.decorative.PillarBlock;
import com.ldtteam.domumornamentum.block.decorative.ShingleBlock;
import com.ldtteam.domumornamentum.block.decorative.ShingleSlabBlock;
import com.ldtteam.domumornamentum.block.decorative.TimberFrameBlock;
import com.ldtteam.domumornamentum.block.types.BrickType;
import com.ldtteam.domumornamentum.block.types.ExtraBlockType;
import com.ldtteam.domumornamentum.block.types.TimberFrameType;
import com.ldtteam.domumornamentum.block.vanilla.DoorBlock;
import com.ldtteam.domumornamentum.block.vanilla.FenceBlock;
import com.ldtteam.domumornamentum.block.vanilla.FenceGateBlock;
import com.ldtteam.domumornamentum.block.vanilla.SlabBlock;
import com.ldtteam.domumornamentum.block.vanilla.StairBlock;
import com.ldtteam.domumornamentum.block.vanilla.TrapdoorBlock;
import com.ldtteam.domumornamentum.block.vanilla.WallBlock;
import com.ldtteam.domumornamentum.recipe.ModRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="domum_ornamentum")
@Mod.EventBusSubscriber(modid="domum_ornamentum", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ModBlocks
implements IModBlocks {
    private static ArchitectsCutterBlock ARCHITECTS_CUTTER;
    private static final List<TimberFrameBlock> TIMBER_FRAMES;
    private static ShingleBlock SHINGLE;
    private static ShingleSlabBlock SHINGLE_SLAB;
    private static PaperWallBlock PAPER_WALL;
    private static final List<ExtraBlock> EXTRA_TOP_BLOCKS;
    private static final List<FloatingCarpetBlock> FLOATING_CARPETS;
    private static BarrelBlock STANDING_BARREL;
    private static BarrelBlock LAYING_BARREL;
    private static final List<BrickBlock> BRICK;
    private static PillarBlock PILLAR;
    private static FenceBlock FENCE;
    private static FenceGateBlock FENCE_GATE;
    private static SlabBlock SLAB;
    private static WallBlock WALL;
    private static StairBlock STAIR;
    private static TrapdoorBlock TRAPDOOR;
    private static DoorBlock DOOR;
    private static PanelBlock STATIC_TRAPDOOR;
    private static FancyDoorBlock FANCY_DOOR;
    private static FancyTrapdoorBlock FANCY_TRAPDOOR;
    private static final ModBlocks INSTANCE;

    public static ModBlocks getInstance() {
        return INSTANCE;
    }

    private ModBlocks() {
    }

    @Override
    public ArchitectsCutterBlock getArchitectsCutter() {
        return ARCHITECTS_CUTTER;
    }

    public ShingleBlock getShingle() {
        return SHINGLE;
    }

    public List<TimberFrameBlock> getTimberFrames() {
        return new ArrayList<TimberFrameBlock>(TIMBER_FRAMES);
    }

    @Override
    public PillarBlock getPillar() {
        return PILLAR;
    }

    public ShingleSlabBlock getShingleSlab() {
        return SHINGLE_SLAB;
    }

    public PaperWallBlock getPaperWall() {
        return PAPER_WALL;
    }

    public List<ExtraBlock> getExtraTopBlocks() {
        return EXTRA_TOP_BLOCKS;
    }

    public List<FloatingCarpetBlock> getFloatingCarpets() {
        return FLOATING_CARPETS;
    }

    @Override
    public BarrelBlock getStandingBarrel() {
        return STANDING_BARREL;
    }

    @Override
    public BarrelBlock getLayingBarrel() {
        return LAYING_BARREL;
    }

    public FenceBlock getFence() {
        return FENCE;
    }

    public FenceGateBlock getFenceGate() {
        return FENCE_GATE;
    }

    public SlabBlock getSlab() {
        return SLAB;
    }

    public List<BrickBlock> getBricks() {
        return BRICK;
    }

    public WallBlock getWall() {
        return WALL;
    }

    public StairBlock getStair() {
        return STAIR;
    }

    public TrapdoorBlock getTrapdoor() {
        return TRAPDOOR;
    }

    public PanelBlock getPanel() {
        return STATIC_TRAPDOOR;
    }

    public DoorBlock getDoor() {
        return DOOR;
    }

    public FancyDoorBlock getFancyDoor() {
        return FANCY_DOOR;
    }

    public FancyTrapdoorBlock getFancyTrapdoor() {
        return FANCY_TRAPDOOR;
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        ARCHITECTS_CUTTER = (ArchitectsCutterBlock)new ArchitectsCutterBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60999_().m_60978_(3.5f)).registerBlock(registry);
        for (TimberFrameType timberFrameType : TimberFrameType.values()) {
            TIMBER_FRAMES.add((TimberFrameBlock)new TimberFrameBlock(timberFrameType).registerBlock(registry));
        }
        SHINGLE = (ShingleBlock)new ShingleBlock().registerBlock(registry);
        SHINGLE_SLAB = (ShingleSlabBlock)new ShingleSlabBlock().registerBlock(registry);
        PAPER_WALL = (PaperWallBlock)new PaperWallBlock().registerBlock(registry);
        PILLAR = (PillarBlock)new PillarBlock().registerBlock(registry);
        for (Enum enum_ : ExtraBlockType.values()) {
            EXTRA_TOP_BLOCKS.add((ExtraBlock)new ExtraBlock((ExtraBlockType)enum_).registerBlock(registry));
        }
        for (Enum enum_ : DyeColor.values()) {
            FLOATING_CARPETS.add((FloatingCarpetBlock)new FloatingCarpetBlock((DyeColor)enum_).registerBlock(registry));
        }
        for (Enum enum_ : BrickType.values()) {
            BRICK.add((BrickBlock)new BrickBlock((BrickType)enum_).registerBlock(registry));
        }
        STANDING_BARREL = (BarrelBlock)new BarrelBlock(true).registerBlock(registry);
        LAYING_BARREL = (BarrelBlock)new BarrelBlock(false).registerBlock(registry);
        FENCE = (FenceBlock)new FenceBlock().registerBlock(registry);
        FENCE_GATE = (FenceGateBlock)new FenceGateBlock().registerBlock(registry);
        SLAB = (SlabBlock)new SlabBlock().registerBlock(registry);
        WALL = (WallBlock)new WallBlock().registerBlock(registry);
        STAIR = (StairBlock)new StairBlock().registerBlock(registry);
        TRAPDOOR = (TrapdoorBlock)new TrapdoorBlock().registerBlock(registry);
        DOOR = (DoorBlock)new DoorBlock().registerBlock(registry);
        STATIC_TRAPDOOR = (PanelBlock)new PanelBlock().registerBlock(registry);
        FANCY_DOOR = (FancyDoorBlock)new FancyDoorBlock().registerBlock(registry);
        FANCY_TRAPDOOR = (FancyTrapdoorBlock)new FancyTrapdoorBlock().registerBlock(registry);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        ARCHITECTS_CUTTER.registerItemBlock((IForgeRegistry<Item>)registry, new Item.Properties().m_41491_(ModCreativeTabs.GENERAL));
        Item.Properties timberframeProperties = new Item.Properties().m_41491_(ModCreativeTabs.GENERAL);
        for (TimberFrameBlock frame : TIMBER_FRAMES) {
            frame.registerItemBlock((IForgeRegistry<Item>)registry, timberframeProperties);
        }
        SHINGLE.registerItemBlock((IForgeRegistry<Item>)registry, new Item.Properties().m_41491_(ModCreativeTabs.GENERAL));
        SHINGLE_SLAB.registerItemBlock((IForgeRegistry<Item>)registry, new Item.Properties().m_41491_(ModCreativeTabs.GENERAL));
        PAPER_WALL.registerItemBlock((IForgeRegistry<Item>)registry, new Item.Properties().m_41491_(ModCreativeTabs.GENERAL));
        PILLAR.registerItemBlock((IForgeRegistry<Item>)registry, new Item.Properties().m_41491_(ModCreativeTabs.GENERAL));
        for (ExtraBlock block : EXTRA_TOP_BLOCKS) {
            block.registerItemBlock((IForgeRegistry<Item>)registry, new Item.Properties().m_41491_(ModCreativeTabs.EXTRA_BLOCKS));
        }
        for (FloatingCarpetBlock floatingCarpet : FLOATING_CARPETS) {
            floatingCarpet.registerItemBlock((IForgeRegistry<Item>)registry, new Item.Properties().m_41491_(ModCreativeTabs.FLOATING_CARPETS));
        }
        for (BrickBlock brickBlock : BRICK) {
            brickBlock.registerItemBlock((IForgeRegistry<Item>)registry, new Item.Properties().m_41491_(ModCreativeTabs.EXTRA_BLOCKS));
        }
        STANDING_BARREL.registerItemBlock((IForgeRegistry<Item>)registry, new Item.Properties().m_41491_(ModCreativeTabs.EXTRA_BLOCKS));
        LAYING_BARREL.registerItemBlock((IForgeRegistry<Item>)registry, new Item.Properties().m_41491_(ModCreativeTabs.EXTRA_BLOCKS));
        FENCE.registerItemBlock((IForgeRegistry<Item>)registry, new Item.Properties().m_41491_(ModCreativeTabs.GENERAL));
        FENCE_GATE.registerItemBlock((IForgeRegistry<Item>)registry, new Item.Properties().m_41491_(ModCreativeTabs.GENERAL));
        SLAB.registerItemBlock((IForgeRegistry<Item>)registry, new Item.Properties().m_41491_(ModCreativeTabs.GENERAL));
        WALL.registerItemBlock((IForgeRegistry<Item>)registry, new Item.Properties().m_41491_(ModCreativeTabs.GENERAL));
        STAIR.registerItemBlock((IForgeRegistry<Item>)registry, new Item.Properties().m_41491_(ModCreativeTabs.GENERAL));
        TRAPDOOR.registerItemBlock((IForgeRegistry<Item>)registry, new Item.Properties().m_41491_(ModCreativeTabs.GENERAL));
        DOOR.registerItemBlock((IForgeRegistry<Item>)registry, new Item.Properties().m_41491_(ModCreativeTabs.GENERAL));
        STATIC_TRAPDOOR.registerItemBlock((IForgeRegistry<Item>)registry, new Item.Properties().m_41491_(ModCreativeTabs.GENERAL));
        FANCY_DOOR.registerItemBlock((IForgeRegistry<Item>)registry, new Item.Properties().m_41491_(ModCreativeTabs.GENERAL));
        FANCY_TRAPDOOR.registerItemBlock((IForgeRegistry<Item>)registry, new Item.Properties().m_41491_(ModCreativeTabs.GENERAL));
        ModRecipeTypes.init();
    }

    static {
        TIMBER_FRAMES = Lists.newArrayList();
        EXTRA_TOP_BLOCKS = Lists.newArrayList();
        FLOATING_CARPETS = Lists.newArrayList();
        BRICK = new ArrayList<BrickBlock>();
        INSTANCE = new ModBlocks();
    }
}

