/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.client.model.baked;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.ldtteam.domumornamentum.client.model.baked.RetexturedBakedModelBuilder;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.client.model.properties.ModProperties;
import com.ldtteam.domumornamentum.util.MaterialTextureDataUtil;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MateriallyTexturedBakedModel
implements BakedModel {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Cache<MaterialTextureData, BakedModel> cache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).concurrencyLevel(4).maximumSize(10000L).build();
    private final Cache<Pair<MaterialTextureData, CompoundTag>, BakedModel> itemCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).concurrencyLevel(4).maximumSize(10000L).build();
    private final BakedModel innerModel;
    private final ItemOverrides overrideList = new OverrideList(this);

    public MateriallyTexturedBakedModel(BakedModel innerModel) {
        this.innerModel = innerModel;
    }

    public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        return this.innerModel.m_6840_(state, side, rand);
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull Random rand, @NotNull IModelData extraData) {
        BakedModel remappedModel = this.getBakedInnerModelFor(extraData);
        return remappedModel.getQuads(state, side, rand, extraData);
    }

    public boolean m_7541_() {
        return this.innerModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.innerModel.m_7539_();
    }

    public boolean m_7547_() {
        return this.innerModel.m_7547_();
    }

    public boolean m_7521_() {
        return this.innerModel.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.innerModel.m_6160_();
    }

    public TextureAtlasSprite getParticleIcon(@NotNull IModelData modelData) {
        if (!modelData.hasProperty(ModProperties.MATERIAL_TEXTURE_PROPERTY)) {
            return this.m_6160_();
        }
        MaterialTextureData textureData = (MaterialTextureData)modelData.getData(ModProperties.MATERIAL_TEXTURE_PROPERTY);
        if (textureData == null) {
            return this.m_6160_();
        }
        ResourceLocation particleTextureName = this.m_6160_().m_118413_();
        if (!textureData.getTexturedComponents().containsKey(particleTextureName)) {
            return this.m_6160_();
        }
        return Minecraft.m_91087_().m_91289_().m_110910_(textureData.getTexturedComponents().get(particleTextureName).m_49966_()).getParticleIcon(modelData);
    }

    public ItemOverrides m_7343_() {
        return this.overrideList;
    }

    public ItemTransforms m_7442_() {
        return this.innerModel.m_7442_();
    }

    private BakedModel getBakedInnerModelFor(IModelData modelData) {
        if (!modelData.hasProperty(ModProperties.MATERIAL_TEXTURE_PROPERTY)) {
            return this.getBakedInnerModelFor(MaterialTextureData.EMPTY);
        }
        return this.getBakedInnerModelFor((MaterialTextureData)modelData.getData(ModProperties.MATERIAL_TEXTURE_PROPERTY));
    }

    private BakedModel getBakedInnerModelFor(MaterialTextureData modelData) {
        try {
            return (BakedModel)this.cache.get((Object)modelData, () -> {
                RetexturedBakedModelBuilder builder = RetexturedBakedModelBuilder.createFor(this.innerModel);
                modelData.getTexturedComponents().forEach(builder::with);
                return builder.build();
            });
        }
        catch (Exception exception) {
            LOGGER.error(String.format("Failed to build baked materially textured model for: %s", modelData), (Throwable)exception);
            return Minecraft.m_91087_().m_91304_().m_119409_();
        }
    }

    private BakedModel getBakedInnerModelFor(ItemStack stack, MaterialTextureData textureData, @Nullable ClientLevel level, @Nullable LivingEntity entity, int random) {
        try {
            return (BakedModel)this.itemCache.get((Object)Pair.of((Object)textureData, (Object)stack.serializeNBT()), () -> {
                RetexturedBakedModelBuilder builder = RetexturedBakedModelBuilder.createFor(this.innerModel, this.innerModel.m_7343_().m_173464_(this.innerModel, stack, level, entity, random));
                textureData.getTexturedComponents().forEach(builder::with);
                return builder.build();
            });
        }
        catch (Exception exception) {
            LOGGER.error(String.format("Failed to build baked materially textured model for: %s for item: %s", textureData, stack), (Throwable)exception);
            return Minecraft.m_91087_().m_91304_().m_119409_();
        }
    }

    private static class OverrideList
    extends ItemOverrides {
        private final MateriallyTexturedBakedModel model;

        private OverrideList(MateriallyTexturedBakedModel model) {
            this.model = model;
        }

        @Nullable
        public BakedModel m_173464_(@NotNull BakedModel model, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int random) {
            MaterialTextureData textureData = MaterialTextureData.deserializeFromNBT(stack.m_41698_("textureData"));
            if (textureData.isEmpty()) {
                textureData = MaterialTextureDataUtil.generateRandomTextureDataFrom(stack);
            }
            return this.model.getBakedInnerModelFor(stack, textureData, level, entity, random);
        }
    }
}

