/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.frames.timber;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.IJsonSerializable;
import com.ldtteam.datagenerators.blockstate.BlockstateJson;
import com.ldtteam.datagenerators.blockstate.BlockstateModelJson;
import com.ldtteam.datagenerators.blockstate.BlockstateVariantJson;
import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.decorative.TimberFrameBlock;
import com.ldtteam.domumornamentum.util.DataGeneratorConstants;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class TimberFramesBlockStateProvider
implements DataProvider {
    private final DataGenerator generator;

    public TimberFramesBlockStateProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_6865_(@NotNull HashCache cache) throws IOException {
        for (TimberFrameBlock timberFrame : ModBlocks.getInstance().getTimberFrames()) {
            this.createBlockstateFile(cache, timberFrame);
        }
    }

    private void createBlockstateFile(HashCache cache, TimberFrameBlock timberFrame) throws IOException {
        if (timberFrame.getRegistryName() == null) {
            return;
        }
        HashMap<CallSite, BlockstateVariantJson> variants = new HashMap<CallSite, BlockstateVariantJson>();
        for (Direction direction : TimberFrameBlock.FACING.m_6908_()) {
            String modelLocation = new ResourceLocation("domum_ornamentum", "block/timber_frames/" + Objects.requireNonNull(timberFrame.getRegistryName()).m_135815_()).toString();
            int x = 0;
            int y = 0;
            if (timberFrame.getTimberFrameType().isRotatable()) {
                x = this.getXfromDirection(direction);
                y = this.getYfromDirection(direction);
            }
            BlockstateModelJson model = new BlockstateModelJson(modelLocation, x, y);
            BlockstateVariantJson variant = new BlockstateVariantJson(model);
            variants.put((CallSite)((Object)("facing=" + direction.m_7912_())), variant);
        }
        BlockstateJson blockstate = new BlockstateJson(variants);
        Path blockstateFolder = this.generator.m_123916_().resolve("assets/domum_ornamentum/blockstates/");
        Path blockstatePath = blockstateFolder.resolve(timberFrame.getRegistryName().m_135815_() + ".json");
        DataProvider.m_123920_((Gson)DataGeneratorConstants.GSON, (HashCache)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)blockstate), (Path)blockstatePath);
    }

    private int getXfromDirection(Direction direction) {
        switch (direction) {
            case UP: {
                return 0;
            }
            case DOWN: {
                return 180;
            }
        }
        return 90;
    }

    private int getYfromDirection(Direction direction) {
        switch (direction) {
            default: {
                return 0;
            }
            case EAST: {
                return 90;
            }
            case SOUTH: {
                return 180;
            }
            case WEST: 
        }
        return 270;
    }

    @NotNull
    public String m_6055_() {
        return "Timber Frames BlockStates Provider";
    }
}

