/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.global;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.loot_table.LootTableJson;
import com.ldtteam.datagenerators.loot_table.LootTableTypeEnum;
import com.ldtteam.datagenerators.loot_table.pool.PoolJson;
import com.ldtteam.datagenerators.loot_table.pool.conditions.survives_explosion.SurvivesExplosionConditionJson;
import com.ldtteam.datagenerators.loot_table.pool.entry.EntryJson;
import com.ldtteam.datagenerators.loot_table.pool.entry.EntryTypeEnum;
import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.decorative.BrickBlock;
import com.ldtteam.domumornamentum.block.decorative.ExtraBlock;
import com.ldtteam.domumornamentum.block.decorative.FloatingCarpetBlock;
import com.ldtteam.domumornamentum.util.DataGeneratorConstants;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class GlobalLootTableProvider
implements DataProvider {
    private final DataGenerator generator;

    public GlobalLootTableProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_6865_(@NotNull HashCache cache) throws IOException {
        for (BrickBlock brickBlock : ModBlocks.getInstance().getBricks()) {
            this.saveBlock(brickBlock, cache);
        }
        for (ExtraBlock extraBlock : ModBlocks.getInstance().getExtraTopBlocks()) {
            this.saveBlock(extraBlock, cache);
        }
        for (FloatingCarpetBlock floatingCarpetBlock : ModBlocks.getInstance().getFloatingCarpets()) {
            this.saveBlock(floatingCarpetBlock, cache);
        }
        this.saveBlock(ModBlocks.getInstance().getStandingBarrel(), cache);
        this.saveBlock(ModBlocks.getInstance().getLayingBarrel(), cache);
        this.saveBlock(ModBlocks.getInstance().getArchitectsCutter(), cache);
    }

    private void saveBlock(Block block, HashCache cache) throws IOException {
        EntryJson entryJson = new EntryJson();
        entryJson.setType(EntryTypeEnum.ITEM);
        entryJson.setName(block.getRegistryName().toString());
        PoolJson poolJson = new PoolJson();
        poolJson.setEntries(Collections.singletonList(entryJson));
        poolJson.setRolls(1);
        poolJson.setConditions(Collections.singletonList(new SurvivesExplosionConditionJson()));
        LootTableJson lootTableJson = new LootTableJson();
        lootTableJson.setType(LootTableTypeEnum.BLOCK);
        lootTableJson.setPools(Collections.singletonList(poolJson));
        Path savePath = this.generator.m_123916_().resolve("data/domum_ornamentum/loot_tables/blocks").resolve(block.getRegistryName().m_135815_() + ".json");
        DataProvider.m_123920_((Gson)DataGeneratorConstants.GSON, (HashCache)cache, (JsonElement)lootTableJson.serialize(), (Path)savePath);
    }

    @NotNull
    public String m_6055_() {
        return "Default Block Loot Tables Provider";
    }
}

