/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.io.FilenameUtils;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.BookContentLoader;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.xplat.XplatModContainer;

public final class BookContentClasspathLoader
implements BookContentLoader {
    public static final BookContentClasspathLoader INSTANCE = new BookContentClasspathLoader();

    private BookContentClasspathLoader() {
    }

    private BiFunction<Path, Path, Boolean> pred(String modId, List<ResourceLocation> list) {
        return (root, file) -> {
            Path rel = root.relativize((Path)file);
            String relName = rel.toString();
            if (relName.endsWith(".json")) {
                relName = FilenameUtils.removeExtension((String)FilenameUtils.separatorsToUnix((String)relName));
                ResourceLocation res = new ResourceLocation(modId, relName);
                list.add(res);
            }
            return true;
        };
    }

    @Override
    public void findFiles(Book book, String dir, List<ResourceLocation> list) {
        XplatModContainer mod = book.owner;
        String id = mod.getId();
        BookRegistry.findFiles(mod, String.format("data/%s/%s/%s/%s/%s", id, "patchouli_books", book.id.m_135815_(), "en_us", dir), path -> true, this.pred(id, list), false);
    }

    @Override
    @Nullable
    public JsonElement loadJson(Book book, ResourceLocation resloc, @Nullable ResourceLocation fallback) {
        String path = "data/" + resloc.m_135827_() + "/" + resloc.m_135815_();
        PatchouliAPI.LOGGER.debug("Loading {}", (Object)path);
        try {
            return BookContentLoader.streamToJson(Files.newInputStream(book.owner.getPath(path), new OpenOption[0]));
        }
        catch (IOException ex) {
            if (fallback != null) {
                return this.loadJson(book, fallback, null);
            }
            PatchouliAPI.LOGGER.warn("Failed to load {}.", (Object)resloc, (Object)ex);
            return null;
        }
    }
}

