/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.book;

import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.base.ClientAdvancements;
import vazkii.patchouli.client.book.BookContents;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookIcon;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.item.ItemModBook;
import vazkii.patchouli.common.util.ItemStackUtil;
import vazkii.patchouli.xplat.XplatModContainer;

public class Book {
    private static final String[] ORDINAL_SUFFIXES = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};
    public static final ResourceLocation DEFAULT_MODEL = new ResourceLocation("patchouli", "book_brown");
    private static final ResourceLocation UNICODE_FONT_ID = new ResourceLocation("patchouli", "unicode_font");
    private static final Map<String, String> DEFAULT_MACROS = (Map)Util.m_137537_(() -> {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("$(list", "$(li");
        ret.put("/$", "$()");
        ret.put("<br>", "$(br)");
        ret.put("$(item)", "$(#b0b)");
        ret.put("$(thing)", "$(#490)");
        return ret;
    });
    private transient BookContents contents;
    private transient boolean wasUpdated = false;
    public transient XplatModContainer owner;
    public transient ResourceLocation id;
    private transient ItemStack bookItem;
    public transient int textColor;
    public transient int headerColor;
    public transient int nameplateColor;
    public transient int linkColor;
    public transient int linkHoverColor;
    public transient int progressBarColor;
    public transient int progressBarBackground;
    public transient boolean isExtension = false;
    public transient List<Book> extensions = new LinkedList<Book>();
    public transient Book extensionTarget;
    public transient boolean isExternal;
    public String name = "";
    @SerializedName(value="landing_text")
    public String landingText = "patchouli.gui.lexicon.landing_info";
    @SerializedName(value="book_texture")
    public ResourceLocation bookTexture = new ResourceLocation("patchouli", "textures/gui/book_brown.png");
    @SerializedName(value="filler_texture")
    public ResourceLocation fillerTexture = new ResourceLocation("patchouli", "textures/gui/page_filler.png");
    @SerializedName(value="crafting_texture")
    public ResourceLocation craftingTexture = new ResourceLocation("patchouli", "textures/gui/crafting.png");
    public ResourceLocation model = DEFAULT_MODEL;
    @SerializedName(value="text_color")
    public String textColorRaw = "000000";
    @SerializedName(value="header_color")
    public String headerColorRaw = "333333";
    @SerializedName(value="nameplate_color")
    public String nameplateColorRaw = "FFDD00";
    @SerializedName(value="link_color")
    public String linkColorRaw = "0000EE";
    @SerializedName(value="link_hover_color")
    public String linkHoverColorRaw = "8800EE";
    @SerializedName(value="use_blocky_font")
    public boolean useBlockyFont = false;
    @SerializedName(value="progress_bar_color")
    public String progressBarColorRaw = "FFFF55";
    @SerializedName(value="progress_bar_background")
    public String progressBarBackgroundRaw = "DDDDDD";
    @SerializedName(value="open_sound")
    public ResourceLocation openSound = new ResourceLocation("patchouli", "book_open");
    @SerializedName(value="flip_sound")
    public ResourceLocation flipSound = new ResourceLocation("patchouli", "book_flip");
    @SerializedName(value="show_progress")
    public boolean showProgress = true;
    @SerializedName(value="index_icon")
    public String indexIconRaw = "";
    public String version = "0";
    public String subtitle = "";
    @SerializedName(value="creative_tab")
    public String creativeTab = "misc";
    @SerializedName(value="advancements_tab")
    public ResourceLocation advancementsTab;
    @SerializedName(value="dont_generate_book")
    public boolean noBook = false;
    @SerializedName(value="custom_book_item")
    public String customBookItem = "";
    @SerializedName(value="show_toasts")
    public boolean showToasts = true;
    @SerializedName(value="extend")
    public ResourceLocation extend;
    @SerializedName(value="allow_extensions")
    public boolean allowExtensions = true;
    @SerializedName(value="pause_game")
    public boolean pauseGame = false;
    @SerializedName(value="use_resource_pack")
    public boolean useResourcePack = false;
    public boolean i18n = false;
    public Map<String, String> macros = new HashMap<String, String>();

    public void build(XplatModContainer owner, ResourceLocation resource, boolean external) {
        this.owner = owner;
        this.id = resource;
        this.isExternal = external;
        boolean bl = this.isExtension = this.extend != null;
        if (!this.isExtension) {
            this.textColor = 0xFF000000 | Integer.parseInt(this.textColorRaw, 16);
            this.headerColor = 0xFF000000 | Integer.parseInt(this.headerColorRaw, 16);
            this.nameplateColor = 0xFF000000 | Integer.parseInt(this.nameplateColorRaw, 16);
            this.linkColor = 0xFF000000 | Integer.parseInt(this.linkColorRaw, 16);
            this.linkHoverColor = 0xFF000000 | Integer.parseInt(this.linkHoverColorRaw, 16);
            this.progressBarColor = 0xFF000000 | Integer.parseInt(this.progressBarColorRaw, 16);
            this.progressBarBackground = 0xFF000000 | Integer.parseInt(this.progressBarBackgroundRaw, 16);
            for (String m : DEFAULT_MACROS.keySet()) {
                if (this.macros.containsKey(m)) continue;
                this.macros.put(m, DEFAULT_MACROS.get(m));
            }
        }
    }

    public String getModNamespace() {
        return this.id.m_135827_();
    }

    public ItemStack getBookItem() {
        if (this.bookItem == null) {
            this.bookItem = this.noBook ? ItemStackUtil.loadStackFromString(this.customBookItem) : ItemModBook.forBook(this);
        }
        return this.bookItem;
    }

    public void markUpdated() {
        this.wasUpdated = true;
    }

    public boolean popUpdated() {
        boolean updated = this.wasUpdated;
        this.wasUpdated = false;
        return updated;
    }

    @Deprecated
    public void reloadContents() {
        this.reloadContents(false);
    }

    public void reloadContents(boolean singleBook) {
        if (!this.isExtension) {
            BookContentsBuilder builder = new BookContentsBuilder(singleBook);
            try {
                builder.loadFrom(this);
            }
            catch (Exception e) {
                PatchouliAPI.LOGGER.error("Error loading book {}, using empty contents and ignoring extensions", (Object)this.id, (Object)e);
                this.contents = BookContents.empty(this, e);
            }
            for (Book extension : this.extensions) {
                try {
                    builder.loadFrom(extension);
                }
                catch (Exception e) {
                    PatchouliAPI.LOGGER.error("Error loading extending book {} with addon book {}, skipping", (Object)this.id, (Object)extension.id, (Object)e);
                }
            }
            try {
                this.contents = builder.build(this);
            }
            catch (Exception e) {
                PatchouliAPI.LOGGER.error("Error compiling book {}, using empty contents", (Object)this.id, (Object)e);
                this.contents = BookContents.empty(this, e);
            }
        }
    }

    public final boolean advancementsEnabled() {
        return PatchouliConfig.get().disableAdvancementLocking().get() == false && !PatchouliConfig.get().noAdvancementBooks().get().contains(this.id.toString());
    }

    public void reloadLocks(boolean suppressToasts) {
        this.getContents().entries.values().forEach(BookEntry::updateLockStatus);
        this.getContents().categories.values().forEach(c -> c.updateLockStatus(true));
        boolean updated = this.popUpdated();
        if (updated && !suppressToasts && this.advancementsEnabled() && this.showToasts) {
            ClientAdvancements.sendBookToast(this);
        }
    }

    public String getOwnerName() {
        return this.owner.getName();
    }

    public Style getFontStyle() {
        if (this.useBlockyFont) {
            return Style.f_131099_;
        }
        return Style.f_131099_.m_131150_(UNICODE_FONT_ID);
    }

    public MutableComponent getSubtitle() {
        TranslatableComponent editionStr;
        try {
            int ver = Integer.parseInt(this.version);
            if (ver == 0) {
                return new TranslatableComponent(this.subtitle);
            }
            editionStr = new TextComponent(Book.numberToOrdinal(ver));
        }
        catch (NumberFormatException e) {
            editionStr = new TranslatableComponent("patchouli.gui.lexicon.dev_edition");
        }
        return new TranslatableComponent("patchouli.gui.lexicon.edition_str", new Object[]{editionStr});
    }

    public BookIcon getIcon() {
        if (this.indexIconRaw == null || this.indexIconRaw.isEmpty()) {
            return new BookIcon.StackIcon(this.getBookItem());
        }
        return BookIcon.from(this.indexIconRaw);
    }

    private static String numberToOrdinal(int i) {
        return i % 100 == 11 || i % 100 == 12 || i % 100 == 13 ? i + "th" : i + ORDINAL_SUFFIXES[i % 10];
    }

    public BookContents getContents() {
        if (this.isExtension) {
            return this.extensionTarget.getContents();
        }
        return this.contents != null ? this.contents : BookContents.empty(this, null);
    }
}

