/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshaftsCommon;
import com.yungnickyoung.minecraft.bettermineshafts.world.config.BetterMineshaftFeatureConfiguration;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftStructurePieceType;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.BetterMineshaftPiece;
import com.yungnickyoung.minecraft.yungsapi.world.BoundingBoxHelper;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class SideRoom
extends BetterMineshaftPiece {
    private boolean hasDownstairs;
    private static final int SECONDARY_AXIS_LEN = 10;
    private static final int Y_AXIS_LEN = 5;
    private static final int MAIN_AXIS_LEN = 5;
    private static final int LOCAL_X_END = 9;
    private static final int LOCAL_Y_END = 4;
    private static final int LOCAL_Z_END = 4;

    public SideRoom(CompoundTag compoundTag) {
        super(BetterMineshaftStructurePieceType.SIDE_ROOM, compoundTag);
        this.hasDownstairs = compoundTag.m_128471_("hasDownstairs");
    }

    public SideRoom(int pieceChainLen, Random random, BoundingBox blockBox, Direction direction, BetterMineshaftFeatureConfiguration config) {
        super(BetterMineshaftStructurePieceType.SIDE_ROOM, pieceChainLen, config, blockBox);
        this.m_73519_(direction);
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag compoundTag) {
        super.m_183620_(structurePieceSerializationContext, compoundTag);
        compoundTag.m_128379_("hasDownstairs", this.hasDownstairs);
    }

    public static BoundingBox determineBoxPosition(StructurePieceAccessor structurePiecesHolder, Random random, int x, int y, int z, Direction direction) {
        BoundingBox blockBox = BoundingBoxHelper.boxFromCoordsWithRotation((int)x, (int)y, (int)z, (int)10, (int)5, (int)5, (Direction)direction);
        StructurePiece intersectingPiece = structurePiecesHolder.m_141921_(blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void m_142537_(StructurePiece structurePiece, StructurePieceAccessor structurePieceAccessor, Random random) {
        if ((double)random.nextFloat() < BetterMineshaftsCommon.CONFIG.spawnRates.workstationDungeonSpawnRate) {
            Direction direction = this.m_73549_();
            if (direction == null) {
                return;
            }
            BetterMineshaftPiece newDungeonPiece = null;
            switch (direction) {
                case NORTH: {
                    newDungeonPiece = BetterMineshaftGenerator.generateAndAddSideRoomDungeonPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162395_() + 6, this.f_73383_.m_162396_() - 4, this.f_73383_.m_162401_(), this.m_73549_(), this.f_73384_);
                    break;
                }
                case SOUTH: {
                    newDungeonPiece = BetterMineshaftGenerator.generateAndAddSideRoomDungeonPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162395_() + 6, this.f_73383_.m_162396_() - 4, this.f_73383_.m_162398_(), this.m_73549_(), this.f_73384_);
                    break;
                }
                case WEST: {
                    newDungeonPiece = BetterMineshaftGenerator.generateAndAddSideRoomDungeonPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162399_(), this.f_73383_.m_162396_() - 4, this.f_73383_.m_162398_() + 6, this.m_73549_(), this.f_73384_);
                    break;
                }
                case EAST: {
                    newDungeonPiece = BetterMineshaftGenerator.generateAndAddSideRoomDungeonPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162395_(), this.f_73383_.m_162396_() - 4, this.f_73383_.m_162398_() + 6, this.m_73549_(), this.f_73384_);
                }
            }
            if (newDungeonPiece != null) {
                this.hasDownstairs = true;
            }
        }
    }

    public void m_183269_(WorldGenLevel world, StructureFeatureManager structureFeatureManager, ChunkGenerator chunkGenerator, Random random, BoundingBox box, ChunkPos chunkPos, BlockPos blockPos) {
        this.fill(world, box, random, 0, 0, 0, 9, 1, 4, this.config.blockStateRandomizers.brickRandomizer);
        this.chanceReplaceNonAir(world, box, random, 1.0f, 0, 2, 0, 9, 3, 4, this.config.blockStateRandomizers.brickRandomizer);
        this.fill(world, box, 1, 1, 1, 8, 3, 4, AIR);
        boolean[][] ceiling = new boolean[10][5];
        for (int x = 0; x <= 9; ++x) {
            for (int z = 0; z <= 4; ++z) {
                BlockState currState = this.getBlockAtFixed((BlockGetter)world, x, 4, z, box);
                if (currState == null || currState == AIR || currState == Blocks.f_50016_.m_49966_()) continue;
                this.m_73434_(world, this.config.blockStateRandomizers.brickRandomizer.get(random), x, 4, z, box);
                ceiling[x][z] = true;
            }
        }
        if (!this.hasDownstairs) {
            this.generateLegs(world, random, box);
        }
        if (random.nextInt(2) == 0) {
            this.m_73434_(world, (BlockState)Blocks.f_50094_.m_49966_().m_61124_((Property)FurnaceBlock.f_48683_, (Comparable)Direction.NORTH), 2, 1, 1, box);
            BlockEntity blockEntity = world.m_7702_((BlockPos)this.m_163582_(2, 1, 1));
            if (blockEntity instanceof FurnaceBlockEntity) {
                ((FurnaceBlockEntity)blockEntity).m_6836_(1, new ItemStack((ItemLike)Items.f_42413_, random.nextInt(33)));
            }
        }
        if (random.nextInt(2) == 0) {
            this.m_73434_(world, (BlockState)Blocks.f_50094_.m_49966_().m_61124_((Property)FurnaceBlock.f_48683_, (Comparable)Direction.NORTH), 1, 1, 1, box);
            BlockEntity blockEntity = world.m_7702_((BlockPos)this.m_163582_(1, 1, 1));
            if (blockEntity instanceof FurnaceBlockEntity) {
                ((FurnaceBlockEntity)blockEntity).m_6836_(1, new ItemStack((ItemLike)Items.f_42413_, random.nextInt(33)));
            }
        }
        this.chanceAddBlock(world, random, 0.5f, Blocks.f_50091_.m_49966_(), 3, 1, 1, box);
        if (random.nextInt(4) == 0) {
            this.addBarrel(world, box, random, 8, 1, 1, BuiltInLootTables.f_78759_);
        }
        if (this.hasDownstairs) {
            this.m_73434_(world, (BlockState)Blocks.f_50155_.m_49966_().m_61124_((Property)LadderBlock.f_54337_, (Comparable)Direction.NORTH), 6, 0, 1, box);
            this.m_73434_(world, (BlockState)this.config.blockStates.trapdoorBlockState.m_61124_((Property)TrapDoorBlock.f_54117_, (Comparable)Direction.NORTH), 6, 1, 1, box);
        }
        this.generateIronBarSupports(world, box, random, ceiling);
        this.addBiomeDecorations(world, box, random, 0, 0, 0, 9, 3, 4);
        this.addVines(world, box, random, this.config.decorationChances.vineChance, 1, 0, 1, 8, 4, 3);
    }

    private void generateLegs(WorldGenLevel world, Random random, BoundingBox box) {
        this.generateLeg(world, random, box, 1, 1, this.config.blockStateRandomizers.brickRandomizer);
        this.generateLeg(world, random, box, 1, 3, this.config.blockStateRandomizers.brickRandomizer);
        this.generateLeg(world, random, box, 8, 1, this.config.blockStateRandomizers.brickRandomizer);
        this.generateLeg(world, random, box, 8, 3, this.config.blockStateRandomizers.brickRandomizer);
    }

    private void generateIronBarSupports(WorldGenLevel world, BoundingBox box, Random random, boolean[][] ceiling) {
        ArrayList<Integer> invalidXs = new ArrayList<Integer>();
        for (int z = 2; z <= 3; ++z) {
            for (int x = 2; x <= 7; ++x) {
                if (invalidXs.contains(x) || !ceiling[x][z] || random.nextInt(5) != 0) continue;
                this.fill(world, box, x, 1, z, x, 3, z, Blocks.f_50183_.m_49966_());
                invalidXs.add(x);
                ++x;
            }
        }
    }
}

