/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.server.generation;

import com.github.alexthe666.citadel.Citadel;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class VillageHouseManager {
    public static final List<String> VILLAGE_REPLACEMENT_POOLS = List.of("minecraft:village/plains/houses", "minecraft:village/desert/houses", "minecraft:village/savanna/houses", "minecraft:village/snowy/houses", "minecraft:village/taiga/houses");
    private static final List<Pair<String, Consumer<StructureTemplatePool>>> REGISTRY = new ArrayList<Pair<String, Consumer<StructureTemplatePool>>>();

    public static StructureTemplatePool addAllPools(StructureTemplatePool poolIn) {
        String str = poolIn.m_210587_().toString();
        for (Pair<String, Consumer<StructureTemplatePool>> pair : REGISTRY) {
            if (!((String)pair.getFirst()).equals(str)) continue;
            ((Consumer)pair.getSecond()).accept(poolIn);
        }
        return poolIn;
    }

    public static void register(String pool, Consumer<StructureTemplatePool> addToPool) {
        REGISTRY.add((Pair<String, Consumer<StructureTemplatePool>>)new Pair((Object)pool, addToPool));
        Citadel.LOGGER.debug("registered addition to pool: " + pool);
    }

    public static StructureTemplatePool addToPool(StructureTemplatePool pool, StructurePoolElement element, int weight) {
        if (weight > 0 && pool != null) {
            ArrayList<StructurePoolElement> templates = new ArrayList<StructurePoolElement>(pool.f_210560_);
            for (int i = 0; i < weight; ++i) {
                templates.add(element);
            }
            ArrayList<Pair> rawTemplates = new ArrayList<Pair>(pool.f_210559_);
            rawTemplates.add(new Pair((Object)element, (Object)weight));
            pool.f_210560_ = templates;
            pool.f_210559_ = rawTemplates;
        }
        return pool;
    }

    public static void debugExample() {
    }
}

