/*
 * Decompiled with CFR 0.152.
 */
package nz.co.mirality.colony4cc;

import net.minecraftforge.common.ForgeConfigSpec;

public class Colony4CCConfig {
    private final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    private final ForgeConfigSpec spec;
    private final ForgeConfigSpec.BooleanValue freeCreativePocketPlayerCost;
    private final ForgeConfigSpec.IntValue highlightWorkerCostMultiplier;
    private final ForgeConfigSpec.IntValue highlightBuildingCostMultiplier;

    public Colony4CCConfig() {
        this.builder.push("balance");
        this.freeCreativePocketPlayerCost = this.builder.comment("True if creative players using a Pocket Computer don't get charged item costs").translation("config.colony4cc.freeCreativePocketPlayerCost").define("freeCreativePocketPlayerCost", true);
        this.highlightWorkerCostMultiplier = this.builder.comment("0 = highlightWorker is always free; 1 = normal price").translation("config.colony4cc.highlightWorkerCostMultiplier").defineInRange("highlightWorkerCostMultiplier", 1, 0, 2);
        this.highlightBuildingCostMultiplier = this.builder.comment("0 = highlightBuilding is always free; 1 = normal price; 2+ = cost multiplier").translation("config.colony4cc.highlightBuildingCostMultiplier").defineInRange("highlightBuildingCostMultiplier", 1, 0, 8);
        this.builder.pop();
        this.spec = this.builder.build();
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }

    public boolean getFreeCreativePocketPlayerCost() {
        return (Boolean)this.freeCreativePocketPlayerCost.get();
    }

    public int getHighlightWorkerCostMultiplier() {
        return (Integer)this.highlightWorkerCostMultiplier.get();
    }

    public int getHighlightBuildingCostMultiplier() {
        return (Integer)this.highlightBuildingCostMultiplier.get();
    }
}

