/*
 * Decompiled with CFR 0.152.
 */
package nz.co.mirality.colony4cc;

import dan200.computercraft.api.pocket.PocketUpgradeSerialiser;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import nz.co.mirality.colony4cc.block.PeripheralBlock;
import nz.co.mirality.colony4cc.block.PeripheralTile;
import nz.co.mirality.colony4cc.item.BaseBlockItem;
import nz.co.mirality.colony4cc.item.ColonyWirelessItem;
import nz.co.mirality.colony4cc.pocket.PocketColony;
import nz.co.mirality.colony4cc.pocket.PocketColonyWireless;

@Mod.EventBusSubscriber(modid="colony4cc", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Registry {
    public static final String MOD_ID = "colony4cc";
    public static final String CC_MOD_ID = "computercraft";
    public static final String PERIPHERAL_ID = "colony_peripheral";
    public static final String PERIPHERAL_NAME = "colony";
    public static final Supplier<CreativeModeTab> GROUP = Lazy.of(Registry::getComputerCraftGroup);

    private Registry() {
    }

    private static CreativeModeTab getComputerCraftGroup() {
        for (CreativeModeTab group : CreativeModeTab.f_40748_) {
            if (!group.m_40783_().equals(CC_MOD_ID)) continue;
            return group;
        }
        return CreativeModeTab.f_40753_;
    }

    public static void setup() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModBlocks.BLOCKS.register(bus);
        ModBlockEntities.BLOCK_ENTITIES.register(bus);
        ModItems.ITEMS.register(bus);
        ModPocketUpgradeSerialisers.SERIALISERS.register(bus);
    }

    public static class ModBlocks {
        static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"colony4cc");
        public static final RegistryObject<Block> PERIPHERAL_BLOCK = BLOCKS.register("colony_peripheral", PeripheralBlock::new);
    }

    public static class ModBlockEntities {
        static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"colony4cc");
        public static final RegistryObject<BlockEntityType<?>> PERIPHERAL_TILE = BLOCK_ENTITIES.register("colony_peripheral", () -> BlockEntityType.Builder.m_155273_(PeripheralTile::new, (Block[])new Block[0]).m_58966_(null));
    }

    public static class ModItems {
        static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"colony4cc");
        public static final RegistryObject<BaseBlockItem> PERIPHERAL_ITEM = ITEMS.register("colony_peripheral", () -> new BaseBlockItem((Block)ModBlocks.PERIPHERAL_BLOCK.get(), new Item.Properties().m_41491_(GROUP.get())));
        public static final RegistryObject<ColonyWirelessItem> UPGRADE_WIRELESS_NORMAL = ITEMS.register("colony_wireless_normal", () -> new ColonyWirelessItem(false, new Item.Properties().m_41491_(GROUP.get())));
        public static final RegistryObject<ColonyWirelessItem> UPGRADE_WIRELESS_ADVANCED = ITEMS.register("colony_wireless_advanced", () -> new ColonyWirelessItem(true, new Item.Properties().m_41491_(GROUP.get())));
        public static final RegistryObject<Item> RGB_CHARGE = ITEMS.register("rgb_charge", () -> new Item(new Item.Properties().m_41491_(GROUP.get())));
    }

    public static class ModPocketUpgradeSerialisers {
        static final DeferredRegister<PocketUpgradeSerialiser<?>> SERIALISERS = DeferredRegister.create((ResourceKey)PocketUpgradeSerialiser.REGISTRY_ID, (String)"colony4cc");
        public static final RegistryObject<PocketUpgradeSerialiser<PocketColony>> COLONY = SERIALISERS.register("pocket_colony", () -> PocketUpgradeSerialiser.simpleWithCustomItem(PocketColony::new));
        public static final RegistryObject<PocketUpgradeSerialiser<PocketColonyWireless>> WIRELESS_COLONY_NORMAL = SERIALISERS.register("pocket_colony_wireless_normal", () -> PocketUpgradeSerialiser.simpleWithCustomItem((id, item) -> new PocketColonyWireless((ResourceLocation)id, (ItemStack)item, false)));
        public static final RegistryObject<PocketUpgradeSerialiser<PocketColonyWireless>> WIRELESS_COLONY_ADVANCED = SERIALISERS.register("pocket_colony_wireless_advanced", () -> PocketUpgradeSerialiser.simpleWithCustomItem((id, item) -> new PocketColonyWireless((ResourceLocation)id, (ItemStack)item, true)));
    }
}

