/*
 * Decompiled with CFR 0.152.
 */
package nz.co.mirality.colony4cc.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkEvent;
import nz.co.mirality.colony4cc.client.CustomRenderTypes;
import nz.co.mirality.colony4cc.network.SAddBuildingOverlayPacket;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="colony4cc", value={Dist.CLIENT})
public class ClientRenderer {
    public static final RenderBuffers renderBuffers = new RenderBuffers();
    private static final MultiBufferSource.BufferSource renderBuffer = renderBuffers.m_110104_();
    private static final Supplier<VertexConsumer> linesWithCullAndDepth = () -> renderBuffer.m_6299_(RenderType.m_110504_());
    private static final Supplier<VertexConsumer> linesWithoutCullAndDepth = () -> renderBuffer.m_6299_(CustomRenderTypes.OVERLAY_LINES);
    private static final Supplier<VertexConsumer> claimArea = () -> renderBuffer.m_6299_(CustomRenderTypes.CLAIM_AREA);
    private static final ConcurrentMap<ResourceLocation, ConcurrentMap<BlockPos, Overlay>> overlays = new ConcurrentHashMap<ResourceLocation, ConcurrentMap<BlockPos, Overlay>>();

    public static void addBuildingOverlay(@NotNull SAddBuildingOverlayPacket msg, @NotNull Supplier<NetworkEvent.Context> ctx) {
        ConcurrentMap posMap = overlays.computeIfAbsent(msg.world(), k -> new ConcurrentHashMap());
        posMap.put(msg.pos(), new Overlay(msg.overlays()));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void clientTick(@NotNull TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !Minecraft.m_91087_().m_91104_()) {
            overlays.values().forEach(posMap -> posMap.entrySet().removeIf(e -> !((Overlay)e.getValue()).tick()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void clientDisconnected(@NotNull ClientPlayerNetworkEvent.LoggedOutEvent event) {
        overlays.clear();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderWorldLastEvent(@NotNull RenderLevelLastEvent event) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        ConcurrentMap posMap = (ConcurrentMap)overlays.get(world.m_46472_().m_135782_());
        if (posMap == null || posMap.isEmpty()) {
            return;
        }
        PoseStack matrixStack = event.getPoseStack();
        Vec3 viewPosition = Minecraft.m_91087_().m_91290_().f_114358_.m_90583_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(-viewPosition.f_82479_, -viewPosition.f_82480_, -viewPosition.f_82481_);
        for (Overlay overlays : posMap.values()) {
            RenderSystem.m_69465_();
            for (SAddBuildingOverlayPacket.Overlay overlay : overlays.overlays()) {
                if (!overlay.strong()) continue;
                ClientRenderer.renderOverlay(matrixStack, linesWithoutCullAndDepth.get(), overlay);
            }
            renderBuffer.m_109911_();
            RenderSystem.m_69482_();
            for (SAddBuildingOverlayPacket.Overlay overlay : overlays.overlays()) {
                if (overlay.strong()) continue;
                ClientRenderer.renderOverlay(matrixStack, linesWithCullAndDepth.get(), overlay);
            }
            renderBuffer.m_109911_();
        }
        renderBuffer.m_109911_();
        matrixStack.m_85849_();
    }

    private static void renderOverlay(@NotNull PoseStack matrixStack, @NotNull VertexConsumer borderVertexBuilder, @NotNull SAddBuildingOverlayPacket.Overlay overlay) {
        AABB box = AABB.m_82321_((BoundingBox)overlay.bounds()).m_82400_(0.002);
        float red = (float)FastColor.ARGB32.m_13665_((int)overlay.color()) / 255.0f;
        float green = (float)FastColor.ARGB32.m_13667_((int)overlay.color()) / 255.0f;
        float blue = (float)FastColor.ARGB32.m_13669_((int)overlay.color()) / 255.0f;
        if (overlay.fill()) {
            ClientRenderer.renderFilledBox(matrixStack, borderVertexBuilder, box, red, green, blue, 1.0f, red, green, blue, 0.2f);
        } else {
            ClientRenderer.renderBoxBorder(matrixStack, borderVertexBuilder, box, red, green, blue, 1.0f);
        }
    }

    private static void renderBoxBorder(@NotNull PoseStack matrixStack, @NotNull VertexConsumer vertexBuilder, @NotNull AABB box, float red, float green, float blue, float alpha) {
        LevelRenderer.m_109608_((PoseStack)matrixStack, (VertexConsumer)vertexBuilder, (double)box.f_82288_, (double)box.f_82289_, (double)box.f_82290_, (double)box.f_82291_, (double)box.f_82292_, (double)box.f_82293_, (float)red, (float)green, (float)blue, (float)alpha);
    }

    private static void renderBiQuad(@NotNull PoseStack matrixStack, @NotNull VertexConsumer vertexBuilder, @NotNull Vec3 p1, @NotNull Vec3 p2, @NotNull Vec3 p3, @NotNull Vec3 p4, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
        vertexBuilder.m_85982_(matrix4f, (float)p1.f_82479_, (float)p1.f_82480_, (float)p1.f_82481_).m_85950_(red, green, blue, alpha).m_5752_();
        vertexBuilder.m_85982_(matrix4f, (float)p2.f_82479_, (float)p2.f_82480_, (float)p2.f_82481_).m_85950_(red, green, blue, alpha).m_5752_();
        vertexBuilder.m_85982_(matrix4f, (float)p3.f_82479_, (float)p3.f_82480_, (float)p3.f_82481_).m_85950_(red, green, blue, alpha).m_5752_();
        vertexBuilder.m_85982_(matrix4f, (float)p4.f_82479_, (float)p4.f_82480_, (float)p4.f_82481_).m_85950_(red, green, blue, alpha).m_5752_();
        vertexBuilder.m_85982_(matrix4f, (float)p4.f_82479_, (float)p4.f_82480_, (float)p4.f_82481_).m_85950_(red, green, blue, alpha).m_5752_();
        vertexBuilder.m_85982_(matrix4f, (float)p3.f_82479_, (float)p3.f_82480_, (float)p3.f_82481_).m_85950_(red, green, blue, alpha).m_5752_();
        vertexBuilder.m_85982_(matrix4f, (float)p2.f_82479_, (float)p2.f_82480_, (float)p2.f_82481_).m_85950_(red, green, blue, alpha).m_5752_();
        vertexBuilder.m_85982_(matrix4f, (float)p1.f_82479_, (float)p1.f_82480_, (float)p1.f_82481_).m_85950_(red, green, blue, alpha).m_5752_();
    }

    private static void renderBoxFill(@NotNull PoseStack matrixStack, @NotNull AABB box, float red, float green, float blue, float alpha) {
        VertexConsumer vertexBuilder = claimArea.get();
        Vec3[] points = new Vec3[]{new Vec3(box.f_82288_, box.f_82289_, box.f_82290_), new Vec3(box.f_82291_, box.f_82289_, box.f_82290_), new Vec3(box.f_82291_, box.f_82289_, box.f_82293_), new Vec3(box.f_82288_, box.f_82289_, box.f_82293_), new Vec3(box.f_82288_, box.f_82292_, box.f_82290_), new Vec3(box.f_82291_, box.f_82292_, box.f_82290_), new Vec3(box.f_82291_, box.f_82292_, box.f_82293_), new Vec3(box.f_82288_, box.f_82292_, box.f_82293_)};
        ClientRenderer.renderBiQuad(matrixStack, vertexBuilder, points[0], points[4], points[5], points[1], red, green, blue, alpha);
        ClientRenderer.renderBiQuad(matrixStack, vertexBuilder, points[3], points[2], points[6], points[7], red, green, blue, alpha);
        ClientRenderer.renderBiQuad(matrixStack, vertexBuilder, points[0], points[1], points[2], points[3], red, green, blue, alpha);
        ClientRenderer.renderBiQuad(matrixStack, vertexBuilder, points[4], points[7], points[6], points[5], red, green, blue, alpha);
        ClientRenderer.renderBiQuad(matrixStack, vertexBuilder, points[0], points[3], points[7], points[4], red, green, blue, alpha);
        ClientRenderer.renderBiQuad(matrixStack, vertexBuilder, points[1], points[5], points[6], points[2], red, green, blue, alpha);
    }

    private static void renderFilledBox(@NotNull PoseStack matrixStack, @NotNull VertexConsumer borderVertexBuilder, @NotNull AABB box, float borderRed, float borderGreen, float borderBlue, float borderAlpha, float fillRed, float fillGreen, float fillBlue, float fillAlpha) {
        ClientRenderer.renderBoxBorder(matrixStack, borderVertexBuilder, box, borderRed, borderGreen, borderBlue, borderAlpha);
        ClientRenderer.renderBoxFill(matrixStack, box, fillRed, fillGreen, fillBlue, fillAlpha);
    }

    private static class Overlay {
        private final List<SAddBuildingOverlayPacket.Overlay> overlays;
        private int lifetime;

        public Overlay(@NotNull List<SAddBuildingOverlayPacket.Overlay> overlays) {
            this.overlays = overlays;
            this.lifetime = 2400;
        }

        public List<SAddBuildingOverlayPacket.Overlay> overlays() {
            return this.overlays;
        }

        public boolean tick() {
            return --this.lifetime > 0;
        }
    }
}

