/*
 * Decompiled with CFR 0.152.
 */
package nz.co.mirality.colony4cc.data;

import dan200.computercraft.api.lua.LuaFunction;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.Scanner;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.common.data.ExistingFileHelper;
import nz.co.mirality.colony4cc.Colony4CC;
import nz.co.mirality.colony4cc.data.LuaDoc;
import nz.co.mirality.colony4cc.peripheral.ColonyPeripheral;
import org.jetbrains.annotations.NotNull;

public class LuaHelpProvider
implements DataProvider {
    private final DataGenerator generator;
    private final ExistingFileHelper existingFileHelper;

    public LuaHelpProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        this.generator = generator;
        this.existingFileHelper = existingFileHelper;
    }

    public void m_6865_(@NotNull HashCache cache) {
        this.generateHelp(cache, "colony/", "colony", ColonyPeripheral.class);
    }

    @NotNull
    public String m_6055_() {
        return "LuaHelp";
    }

    private void generateHelp(@NotNull HashCache cache, @NotNull String prefix, @NotNull String name, @NotNull Class<?> klass) {
        try {
            String content;
            ResourceLocation location = new ResourceLocation("computercraft", "lua/rom/help/" + prefix + name + ".txt");
            Path path = this.generator.m_123916_().resolve("data").resolve(location.m_135827_()).resolve(location.m_135815_());
            Resource resource = this.existingFileHelper.getResource(location, PackType.SERVER_DATA);
            try (Scanner scanner = new Scanner(resource.m_6679_()).useDelimiter("(?<=\\n)|(?!\\n)(?<=\\r)");){
                StringWriter out = new StringWriter();
                while (scanner.hasNext()) {
                    String line = scanner.next();
                    if (line.startsWith("[API]")) {
                        line = LuaHelpProvider.generateApiHelp(name, klass, line.substring(5));
                    }
                    out.write(line);
                }
                content = out.toString();
            }
            String hash = f_123918_.hashUnencodedChars((CharSequence)content).toString();
            if (!Objects.equals(cache.m_123938_(path), hash) || !Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                    writer.write(content);
                }
            }
            cache.m_123940_(path, hash);
        }
        catch (IOException e) {
            Colony4CC.LOGGER.error("Error generating lua help for " + name, (Throwable)e);
        }
    }

    private static String generateApiHelp(@NotNull String name, @NotNull Class<?> klass, @NotNull String newline) {
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        for (Method method : klass.getMethods()) {
            LuaFunction function = method.getAnnotation(LuaFunction.class);
            if (function == null) continue;
            LuaDoc doc = method.getAnnotation(LuaDoc.class);
            String methodName = method.getName();
            String args = LuaHelpProvider.generateApiArgs(method, doc);
            Object returns = LuaHelpProvider.generateApiReturns(method, doc);
            if (!((String)returns).isEmpty()) {
                returns = " => " + (String)returns;
            }
            MethodInfo info = new MethodInfo();
            info.method = method;
            info.function = function;
            info.doc = doc;
            info.name = methodName;
            info.content = String.format("%s.%s(%s)%s%s", name, methodName, args, returns, newline);
            methods.add(info);
        }
        methods.sort((a, b) -> {
            if (a.doc == null) {
                return b.doc == null ? 0 : 1;
            }
            if (b.doc == null) {
                return -1;
            }
            if (a.doc.group() < b.doc.group()) {
                return -1;
            }
            if (a.doc.group() > b.doc.group()) {
                return 1;
            }
            if (a.doc.order() < b.doc.order()) {
                return -1;
            }
            if (a.doc.order() > b.doc.order()) {
                return 1;
            }
            return String.CASE_INSENSITIVE_ORDER.compare(a.name, b.name);
        });
        return methods.stream().map(m -> m.content).collect(Collectors.joining());
    }

    private static String generateApiArgs(Method method, LuaDoc doc) {
        if (doc != null && !doc.args().isEmpty()) {
            return doc.args();
        }
        if (method.getParameterCount() == 0) {
            return "";
        }
        Colony4CC.LOGGER.warn("Missing @LuaDoc args on " + method.getName());
        return "...";
    }

    private static String generateApiReturns(Method method, LuaDoc doc) {
        if (doc != null && !doc.returns().isEmpty()) {
            return doc.returns();
        }
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE) {
            return "";
        }
        if (returnType == String.class) {
            return "string";
        }
        if (returnType.isPrimitive()) {
            return returnType.getName().toLowerCase(Locale.ROOT);
        }
        return "table";
    }

    static class MethodInfo {
        public Method method;
        public LuaFunction function;
        public LuaDoc doc;
        public String name;
        public String content;

        MethodInfo() {
        }
    }
}

