/*
 * Decompiled with CFR 0.152.
 */
package nz.co.mirality.colony4cc.network;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import nz.co.mirality.colony4cc.client.ClientRenderer;
import org.jetbrains.annotations.NotNull;

public class SAddBuildingOverlayPacket {
    private final ResourceLocation world;
    private final BlockPos pos;
    private final List<Overlay> overlays;

    public SAddBuildingOverlayPacket(@NotNull ResourceLocation world, @NotNull BlockPos pos, @NotNull List<Overlay> overlays) {
        this.world = world;
        this.pos = pos;
        this.overlays = ImmutableList.copyOf(overlays);
    }

    public ResourceLocation world() {
        return this.world;
    }

    public BlockPos pos() {
        return this.pos;
    }

    public List<Overlay> overlays() {
        return this.overlays;
    }

    public void write(@NotNull FriendlyByteBuf buf) {
        buf.m_130085_(this.world);
        buf.m_130064_(this.pos);
        buf.m_130130_(this.overlays.size());
        for (Overlay overlay : this.overlays) {
            overlay.write(buf);
        }
    }

    @NotNull
    public static SAddBuildingOverlayPacket read(@NotNull FriendlyByteBuf buf) {
        ResourceLocation world = buf.m_130281_();
        BlockPos pos = buf.m_130135_();
        int size = buf.m_130242_();
        ArrayList<Overlay> overlays = new ArrayList<Overlay>();
        for (int i = 0; i < size; ++i) {
            overlays.add(Overlay.read(buf));
        }
        return new SAddBuildingOverlayPacket(world, pos, overlays);
    }

    public static void handle(@NotNull SAddBuildingOverlayPacket msg, @NotNull Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> SAddBuildingOverlayPacket.lambda$handle$1(msg, (Supplier)ctx)));
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ Runnable lambda$handle$1(SAddBuildingOverlayPacket msg, Supplier ctx) {
        return () -> SAddBuildingOverlayPacket.lambda$handle$0(msg, (Supplier)ctx);
    }

    private static /* synthetic */ void lambda$handle$0(SAddBuildingOverlayPacket msg, Supplier ctx) {
        ClientRenderer.addBuildingOverlay(msg, ctx);
    }

    public static class Overlay {
        private final BoundingBox bounds;
        private final int color;
        private final boolean fill;
        private final boolean strong;

        public Overlay(@NotNull BoundingBox bounds, @NotNull int color, boolean fill, boolean strong) {
            this.bounds = bounds;
            this.color = color;
            this.fill = fill;
            this.strong = strong;
        }

        public BoundingBox bounds() {
            return this.bounds;
        }

        public int color() {
            return this.color;
        }

        public boolean fill() {
            return this.fill;
        }

        public boolean strong() {
            return this.strong;
        }

        public void write(@NotNull FriendlyByteBuf buf) {
            buf.m_130130_(this.bounds.m_162395_());
            buf.m_130130_(this.bounds.m_162396_());
            buf.m_130130_(this.bounds.m_162398_());
            buf.m_130130_(this.bounds.m_162399_());
            buf.m_130130_(this.bounds.m_162400_());
            buf.m_130130_(this.bounds.m_162401_());
            buf.writeInt(this.color);
            buf.writeBoolean(this.fill);
            buf.writeBoolean(this.strong);
        }

        public static Overlay read(@NotNull FriendlyByteBuf buf) {
            int x1 = buf.m_130242_();
            int y1 = buf.m_130242_();
            int z1 = buf.m_130242_();
            int x2 = buf.m_130242_();
            int y2 = buf.m_130242_();
            int z2 = buf.m_130242_();
            int color = buf.readInt();
            boolean fill = buf.readBoolean();
            boolean strong = buf.readBoolean();
            return new Overlay(new BoundingBox(x1, y1, z1, x2, y2, z2), color, fill, strong);
        }
    }
}

