/*
 * Decompiled with CFR 0.152.
 */
package vazkii.neat;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.awt.Color;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.neat.NeatConfig;
import vazkii.neat.NeatRenderType;

public class HealthBarRenderer {
    public static Entity getEntityLookedAt(Entity e) {
        Entity foundEntity = null;
        double finalDistance = 32.0;
        double distance = 32.0;
        HitResult pos = HealthBarRenderer.raycast(e, 32.0);
        Vec3 positionVector = e.m_20182_();
        if (e instanceof Player) {
            positionVector = positionVector.m_82520_(0.0, (double)e.m_20236_(e.m_20089_()), 0.0);
        }
        if (pos != null) {
            distance = pos.m_82450_().m_82554_(positionVector);
        }
        Vec3 lookVector = e.m_20154_();
        Vec3 reachVector = positionVector.m_82520_(lookVector.f_82479_ * 32.0, lookVector.f_82480_ * 32.0, lookVector.f_82481_ * 32.0);
        Entity lookedEntity = null;
        List entitiesInBoundingBox = e.m_20193_().m_45933_(e, e.m_142469_().m_82377_(lookVector.f_82479_ * 32.0, lookVector.f_82480_ * 32.0, lookVector.f_82481_ * 32.0).m_82363_(1.0, 1.0, 1.0));
        double minDistance = distance;
        for (Entity entity : entitiesInBoundingBox) {
            if (entity.m_6087_()) {
                double distanceToEntity;
                AABB collisionBox = entity.m_6921_();
                Optional interceptPosition = collisionBox.m_82371_(positionVector, reachVector);
                if (collisionBox.m_82390_(positionVector)) {
                    if (0.0 < minDistance || minDistance == 0.0) {
                        lookedEntity = entity;
                        minDistance = 0.0;
                    }
                } else if (interceptPosition.isPresent() && ((distanceToEntity = positionVector.m_82554_((Vec3)interceptPosition.get())) < minDistance || minDistance == 0.0)) {
                    lookedEntity = entity;
                    minDistance = distanceToEntity;
                }
            }
            if (lookedEntity == null || !(minDistance < distance) && pos != null) continue;
            foundEntity = lookedEntity;
        }
        return foundEntity;
    }

    public static HitResult raycast(Entity e, double len) {
        Vec3 look;
        Vec3 vec = new Vec3(e.m_20185_(), e.m_20186_(), e.m_20189_());
        if (e instanceof Player) {
            vec = vec.m_82549_(new Vec3(0.0, (double)e.m_20236_(e.m_20089_()), 0.0));
        }
        if ((look = e.m_20154_()) == null) {
            return null;
        }
        return HealthBarRenderer.raycast(vec, look, e, len);
    }

    public static HitResult raycast(Vec3 origin, Vec3 ray, Entity e, double len) {
        Vec3 next = origin.m_82549_(ray.m_82541_().m_82490_(len));
        return e.f_19853_.m_45547_(new ClipContext(origin, next, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, e));
    }

    @Nonnull
    public static ItemStack getIcon(LivingEntity entity, boolean boss) {
        if (boss) {
            return new ItemStack((ItemLike)Items.f_42686_);
        }
        MobType type = entity.m_6336_();
        if (type == MobType.f_21642_) {
            return new ItemStack((ItemLike)Items.f_42591_);
        }
        if (type == MobType.f_21641_) {
            return new ItemStack((ItemLike)Items.f_42583_);
        }
        return ItemStack.f_41583_;
    }

    public static int getColor(LivingEntity entity, boolean colorByType, boolean boss) {
        if (colorByType) {
            int r = 0;
            int g = 255;
            int b = 0;
            if (boss) {
                r = 128;
                g = 0;
                b = 128;
            }
            if (entity instanceof Monster) {
                r = 255;
                g = 0;
                b = 0;
            }
            return 0xFF000000 | r << 16 | g << 8 | b;
        }
        float health = Mth.m_14036_((float)entity.m_21223_(), (float)0.0f, (float)entity.m_21233_());
        float hue = Math.max(0.0f, health / entity.m_21233_() / 3.0f - 0.07f);
        return Color.HSBtoRGB(hue, 1.0f, 1.0f);
    }

    @SubscribeEvent
    public void onRenderLevelLast(RenderLevelLastEvent event) {
        Entity cameraEntity;
        Minecraft mc = Minecraft.m_91087_();
        if (!NeatConfig.renderInF1 && !Minecraft.m_91404_() || !NeatConfig.draw) {
            return;
        }
        Camera camera = mc.f_91063_.m_109153_();
        PoseStack poseStack = event.getPoseStack();
        float partialTicks = event.getPartialTick();
        Object object = cameraEntity = camera.m_90592_() != null ? camera.m_90592_() : mc.f_91074_;
        if (NeatConfig.showOnlyFocused) {
            Entity focused = HealthBarRenderer.getEntityLookedAt((Entity)mc.f_91074_);
            if (focused != null && focused instanceof LivingEntity && focused.m_6084_()) {
                this.renderHealthBar((LivingEntity)focused, mc, poseStack, partialTicks, camera, cameraEntity);
            }
        } else {
            Vec3 cameraPos = camera.m_90583_();
            Frustum frustum = new Frustum(poseStack.m_85850_().m_85861_(), event.getProjectionMatrix());
            frustum.m_113002_(cameraPos.m_7096_(), cameraPos.m_7098_(), cameraPos.m_7094_());
            ClientLevel client = mc.f_91073_;
            if (client != null) {
                for (Entity entity : client.m_104735_()) {
                    if (entity == null || !(entity instanceof LivingEntity) || entity == cameraEntity || !entity.m_6084_() || entity.m_146897_().iterator().hasNext() || !entity.m_6000_(cameraPos.m_7096_(), cameraPos.m_7098_(), cameraPos.m_7094_()) || !entity.f_19811_ && !frustum.m_113029_(entity.m_142469_())) continue;
                    this.renderHealthBar((LivingEntity)entity, mc, poseStack, partialTicks, camera, cameraEntity);
                }
            }
        }
    }

    public void renderHealthBar(LivingEntity passedEntity, Minecraft mc, PoseStack poseStack, float partialTicks, Camera camera, Entity viewPoint) {
        Stack<LivingEntity> ridingStack = new Stack<LivingEntity>();
        LivingEntity entity = passedEntity;
        ridingStack.push(entity);
        while (entity.m_20202_() != null && entity.m_20202_() instanceof LivingEntity) {
            entity = (LivingEntity)entity.m_20202_();
            ridingStack.push(entity);
        }
        ShaderInstance prevShader = RenderSystem.m_157196_();
        RenderSystem.m_157427_(GameRenderer::m_172835_);
        poseStack.m_85836_();
        while (!ridingStack.isEmpty()) {
            float distance;
            boolean boss;
            entity = (LivingEntity)ridingStack.pop();
            boolean bl = boss = !entity.m_6072_();
            String entityID = entity.m_6095_().getRegistryName().toString();
            if (NeatConfig.blacklist.contains(entityID) || (distance = passedEntity.m_20270_(viewPoint)) > (float)NeatConfig.maxDistance || !passedEntity.m_142582_(viewPoint) || entity.m_20145_() || !NeatConfig.showOnBosses && !boss || !NeatConfig.showOnPlayers && entity instanceof Player || entity.m_21233_() <= 0.0f || !NeatConfig.showFullHealth && entity.m_21223_() == entity.m_21233_()) continue;
            double x = passedEntity.f_19854_ + (passedEntity.m_20185_() - passedEntity.f_19854_) * (double)partialTicks;
            double y = passedEntity.f_19855_ + (passedEntity.m_20186_() - passedEntity.f_19855_) * (double)partialTicks;
            double z = passedEntity.f_19856_ + (passedEntity.m_20189_() - passedEntity.f_19856_) * (double)partialTicks;
            EntityRenderDispatcher renderDispatcher = Minecraft.m_91087_().m_91290_();
            Vec3 renderPos = renderDispatcher.f_114358_.m_90583_();
            poseStack.m_85836_();
            poseStack.m_85837_((double)((float)(x - renderPos.m_7096_())), (double)((float)(y - renderPos.m_7098_() + (double)passedEntity.m_20206_() + NeatConfig.heightAbove)), (double)((float)(z - renderPos.m_7094_())));
            MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
            ItemStack icon = HealthBarRenderer.getIcon(entity, boss);
            int light = 0xF000F0;
            this.renderEntity(mc, poseStack, buffer, camera, entity, 0xF000F0, icon, boss);
            poseStack.m_85849_();
            poseStack.m_85837_(0.0, (double)(-(NeatConfig.backgroundHeight + NeatConfig.barHeight + NeatConfig.backgroundPadding)), 0.0);
        }
        poseStack.m_85849_();
    }

    private void renderEntity(Minecraft mc, PoseStack poseStack, MultiBufferSource.BufferSource buffer, Camera camera, LivingEntity entity, int light, ItemStack icon, boolean boss) {
        int armor;
        float namel;
        Quaternion rotation = camera.m_90591_().m_80161_();
        rotation.m_80141_(-1.0f);
        poseStack.m_85845_(rotation);
        float scale = 0.026666673f;
        poseStack.m_85841_(-scale, -scale, scale);
        float health = Mth.m_14036_((float)entity.m_21223_(), (float)0.0f, (float)entity.m_21233_());
        float percent = health / entity.m_21233_() * 100.0f;
        float size = NeatConfig.plateSize;
        float textScale = 0.5f;
        Object name = (entity.m_8077_() ? entity.m_7770_() : entity.m_5446_()).getString();
        if (entity.m_8077_()) {
            name = ChatFormatting.ITALIC + (String)name;
        }
        if ((namel = (float)mc.f_91062_.m_92895_((String)name) * textScale) + 20.0f > size * 2.0f) {
            size = namel / 2.0f + 10.0f;
        }
        float healthSize = size * (health / entity.m_21233_());
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f modelViewMatrix = pose.m_85861_();
        Vector3f normal = new Vector3f(0.0f, 1.0f, 0.0f);
        normal.m_122249_(pose.m_85864_());
        VertexConsumer builder = buffer.m_6299_(NeatRenderType.getHealthBarType(NeatRenderType.HEALTH_BAR_TEXTURE));
        float padding = NeatConfig.backgroundPadding;
        int bgHeight = NeatConfig.backgroundHeight;
        int barHeight = NeatConfig.barHeight;
        if (NeatConfig.drawBackground) {
            builder.m_85982_(modelViewMatrix, -size - padding, (float)(-bgHeight), 0.01f).m_6122_(0, 0, 0, 64).m_7421_(0.0f, 0.0f).m_85969_(light).m_5752_();
            builder.m_85982_(modelViewMatrix, -size - padding, (float)barHeight + padding, 0.01f).m_6122_(0, 0, 0, 64).m_7421_(0.0f, 0.5f).m_85969_(light).m_5752_();
            builder.m_85982_(modelViewMatrix, size + padding, (float)barHeight + padding, 0.01f).m_6122_(0, 0, 0, 64).m_7421_(1.0f, 0.5f).m_85969_(light).m_5752_();
            builder.m_85982_(modelViewMatrix, size + padding, (float)(-bgHeight), 0.01f).m_6122_(0, 0, 0, 64).m_7421_(1.0f, 0.0f).m_85969_(light).m_5752_();
        }
        int argb = HealthBarRenderer.getColor(entity, NeatConfig.colorByType, boss);
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        builder.m_85982_(modelViewMatrix, -size, 0.0f, 0.001f).m_6122_(r, g, b, 127).m_7421_(0.0f, 0.75f).m_85969_(light).m_5752_();
        builder.m_85982_(modelViewMatrix, -size, (float)barHeight, 0.001f).m_6122_(r, g, b, 127).m_7421_(0.0f, 1.0f).m_85969_(light).m_5752_();
        builder.m_85982_(modelViewMatrix, healthSize * 2.0f - size, (float)barHeight, 0.001f).m_6122_(r, g, b, 127).m_7421_(1.0f, 1.0f).m_85969_(light).m_5752_();
        builder.m_85982_(modelViewMatrix, healthSize * 2.0f - size, 0.0f, 0.001f).m_6122_(r, g, b, 127).m_7421_(1.0f, 0.75f).m_85969_(light).m_5752_();
        if (healthSize < size) {
            builder.m_85982_(modelViewMatrix, -size + healthSize * 2.0f, 0.0f, 0.001f).m_6122_(0, 0, 0, 127).m_7421_(0.0f, 0.5f).m_85969_(light).m_5752_();
            builder.m_85982_(modelViewMatrix, -size + healthSize * 2.0f, (float)barHeight, 0.001f).m_6122_(0, 0, 0, 127).m_7421_(0.0f, 0.75f).m_85969_(light).m_5752_();
            builder.m_85982_(modelViewMatrix, size, (float)barHeight, 0.001f).m_6122_(0, 0, 0, 127).m_7421_(1.0f, 0.75f).m_85969_(light).m_5752_();
            builder.m_85982_(modelViewMatrix, size, 0.0f, 0.001f).m_6122_(0, 0, 0, 127).m_7421_(1.0f, 0.5f).m_85969_(light).m_5752_();
        }
        int white = 0xFFFFFF;
        int black = 0;
        poseStack.m_85837_((double)(-size), -4.5, 0.0);
        poseStack.m_85841_(textScale, textScale, textScale);
        modelViewMatrix = poseStack.m_85850_().m_85861_();
        mc.f_91062_.m_92811_((String)name, 0.0f, 0.0f, white, false, modelViewMatrix, (MultiBufferSource)buffer, false, black, light);
        float s1 = 0.75f;
        poseStack.m_85836_();
        poseStack.m_85841_(s1, s1, s1);
        modelViewMatrix = poseStack.m_85850_().m_85861_();
        int h = NeatConfig.hpTextHeight;
        Object maxHpStr = "" + ChatFormatting.BOLD + (double)Math.round((double)entity.m_21233_() * 100.0) / 100.0;
        Object hpStr = "" + (double)Math.round((double)health * 100.0) / 100.0;
        String percStr = (int)percent + "%";
        if (((String)maxHpStr).endsWith(".00")) {
            maxHpStr = ((String)maxHpStr).substring(0, ((String)maxHpStr).length() - 3);
        }
        if (((String)hpStr).endsWith(".00")) {
            hpStr = ((String)hpStr).substring(0, ((String)hpStr).length() - 3);
        }
        if (NeatConfig.showCurrentHP) {
            mc.f_91062_.m_92811_((String)hpStr, 2.0f, (float)h, white, false, modelViewMatrix, (MultiBufferSource)buffer, false, black, light);
        }
        if (NeatConfig.showMaxHP) {
            mc.f_91062_.m_92811_((String)maxHpStr, (float)((int)(size / (textScale * s1) * 2.0f) - 2 - mc.f_91062_.m_92895_((String)maxHpStr)), (float)h, white, false, modelViewMatrix, (MultiBufferSource)buffer, false, black, light);
        }
        if (NeatConfig.showPercentage) {
            mc.f_91062_.m_92811_(percStr, (float)((int)(size / (textScale * s1)) - mc.f_91062_.m_92895_(percStr) / 2), (float)h, white, false, modelViewMatrix, (MultiBufferSource)buffer, false, black, light);
        }
        if (NeatConfig.enableDebugInfo && mc.f_91066_.f_92063_) {
            mc.f_91062_.m_92811_("ID: \"" + entity.m_6095_().getRegistryName().toString() + "\"", 0.0f, (float)(h + 16), white, false, modelViewMatrix, (MultiBufferSource)buffer, false, black, light);
        }
        poseStack.m_85849_();
        poseStack.m_85836_();
        int off = 0;
        s1 = 0.5f;
        poseStack.m_85841_(s1, s1, s1);
        poseStack.m_85837_((double)(size / (textScale * s1) * 2.0f), 0.0, 0.0);
        mc.f_90987_.m_174784_(InventoryMenu.f_39692_);
        if (NeatConfig.showAttributes) {
            this.renderIcon(mc, off, 0, icon, poseStack, (MultiBufferSource)buffer, light);
            off -= 16;
        }
        if ((armor = entity.m_21230_()) > 0 && NeatConfig.showArmor) {
            int i;
            int ironArmor = armor % 5;
            int diamondArmor = armor / 5;
            if (!NeatConfig.groupArmor) {
                ironArmor = armor;
                diamondArmor = 0;
            }
            icon = new ItemStack((ItemLike)Items.f_42469_);
            for (i = 0; i < ironArmor; ++i) {
                this.renderIcon(mc, off, 0, icon, poseStack, (MultiBufferSource)buffer, light);
                off -= 4;
            }
            icon = new ItemStack((ItemLike)Items.f_42473_);
            for (i = 0; i < diamondArmor; ++i) {
                this.renderIcon(mc, off, 0, icon, poseStack, (MultiBufferSource)buffer, light);
                off -= 4;
            }
        }
        poseStack.m_85849_();
    }

    private void renderIcon(Minecraft mc, int vertexX, int vertexY, @Nonnull ItemStack icon, PoseStack poseStack, MultiBufferSource buffer, int light) {
        poseStack.m_85836_();
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-90.0f));
        poseStack.m_85837_((double)(vertexY - 16), (double)(vertexX - 16), 0.0);
        poseStack.m_85841_(16.0f, 16.0f, 1.0f);
        try {
            VertexConsumer builder;
            ResourceLocation registryName = icon.m_41720_().getRegistryName();
            Pair pair = Pair.of((Object)InventoryMenu.f_39692_, (Object)new ResourceLocation(registryName.m_135827_(), "item/" + registryName.m_135815_()));
            TextureAtlasSprite sprite = (TextureAtlasSprite)mc.m_91258_((ResourceLocation)pair.getFirst()).apply((ResourceLocation)pair.getSecond());
            PoseStack.Pose pose = poseStack.m_85850_();
            Matrix4f modelViewMatrix = pose.m_85861_();
            Vector3f normal = new Vector3f(0.0f, 1.0f, 0.0f);
            normal.m_122249_(pose.m_85864_());
            if (icon.m_41619_()) {
                builder = buffer.m_6299_(NeatRenderType.getNoIconType());
                builder.m_85982_(modelViewMatrix, 0.0f, 0.0f, 0.0f).m_6122_(0, 0, 0, 0).m_5752_();
                builder.m_85982_(modelViewMatrix, 0.0f, 1.0f, 0.0f).m_6122_(0, 0, 0, 0).m_5752_();
                builder.m_85982_(modelViewMatrix, 1.0f, 1.0f, 0.0f).m_6122_(0, 0, 0, 0).m_5752_();
                builder.m_85982_(modelViewMatrix, 1.0f, 0.0f, 0.0f).m_6122_(0, 0, 0, 0).m_5752_();
            } else {
                builder = buffer.m_6299_(NeatRenderType.getHealthBarType(InventoryMenu.f_39692_));
                builder.m_85982_(modelViewMatrix, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_85969_(light).m_5752_();
                builder.m_85982_(modelViewMatrix, 0.0f, 1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_85969_(light).m_5752_();
                builder.m_85982_(modelViewMatrix, 1.0f, 1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_85969_(light).m_5752_();
                builder.m_85982_(modelViewMatrix, 1.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_85969_(light).m_5752_();
            }
            builder = buffer.m_6299_(NeatRenderType.getNoIconType());
            builder.m_85982_(modelViewMatrix, 0.0f, 0.0f, 0.0f).m_6122_(0, 0, 0, 0).m_5752_();
            builder.m_85982_(modelViewMatrix, 0.0f, 1.0f, 0.0f).m_6122_(0, 0, 0, 0).m_5752_();
            builder.m_85982_(modelViewMatrix, 1.0f, 1.0f, 0.0f).m_6122_(0, 0, 0, 0).m_5752_();
            builder.m_85982_(modelViewMatrix, 1.0f, 0.0f, 0.0f).m_6122_(0, 0, 0, 0).m_5752_();
        }
        catch (Exception ignored) {
            poseStack.m_85849_();
            return;
        }
        poseStack.m_85849_();
    }
}

