/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.api.util;

import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;

public class BlockPosStreamProvider {
    private BlockPosStreamProvider() {
        throw new IllegalStateException("Can not instantiate an instance of: BlockPosStreamProvider. This is a utility class");
    }

    public static Stream<BlockPos> getForRange(int size) {
        return BlockPosStreamProvider.getForRange(0, size - 1);
    }

    public static Stream<BlockPos> getForRange(int min, int max) {
        return BlockPosStreamProvider.getForRange(min, min, min, max, max, max);
    }

    public static Stream<BlockPos> getForRange(Vec3 min, Vec3 max) {
        BlockPos minPos = new BlockPos(min);
        BlockPos maxPos = new BlockPos(max);
        return BlockPosStreamProvider.getForRange(minPos.m_123341_(), minPos.m_123342_(), minPos.m_123343_(), maxPos.m_123341_(), maxPos.m_123342_(), maxPos.m_123343_());
    }

    public static Stream<BlockPos> getForRange(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return BlockPosStreamProvider.getForRange(new Vec3(minX, minY, minZ), new Vec3(maxX, maxY, maxZ));
    }

    public static Stream<BlockPos> getForRange(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (minX == maxX && minY == maxY && minZ == maxZ) {
            return Stream.of(new BlockPos(minX, minY, minZ));
        }
        return IntStream.range(minX, maxX + 1).mapToObj(xCoord -> IntStream.range(minY, maxY + 1).mapToObj(yCoord -> IntStream.range(minZ, maxZ + 1).mapToObj(zCoord -> new BlockPos(xCoord, yCoord, zCoord)))).flatMap(yBasedStream -> yBasedStream.flatMap(Function.identity()));
    }
}

