/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.change;

import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.IChiselsAndBitsAPI;
import mod.chiselsandbits.api.change.IChangeTracker;
import mod.chiselsandbits.api.change.changes.IChange;
import mod.chiselsandbits.api.change.changes.IllegalChangeAttempt;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.util.INBTSerializable;
import mod.chiselsandbits.change.changes.BitChange;
import mod.chiselsandbits.change.changes.CombinedChange;
import mod.chiselsandbits.network.packets.ChangeTrackerUpdatedPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ChangeTracker
implements IChangeTracker {
    protected final Player player;
    protected final LinkedList<CombinedChange> changes = new LinkedList();
    protected int currentIndex = 0;

    public ChangeTracker() {
        this.player = null;
    }

    public ChangeTracker(Player player) {
        this.player = player;
    }

    public void reset() {
        this.changes.clear();
        this.sendUpdate();
    }

    @Override
    public void onBlocksUpdated(Map<BlockPos, IMultiStateSnapshot> beforeStates, Map<BlockPos, IMultiStateSnapshot> afterState) {
        if (!beforeStates.keySet().containsAll(afterState.keySet()) || !afterState.keySet().containsAll(beforeStates.keySet())) {
            throw new IllegalArgumentException("Initial States and Target States reference difference block positions");
        }
        this.changes.addFirst(new CombinedChange(beforeStates.entrySet().stream().map(e -> new BitChange((BlockPos)e.getKey(), (IMultiStateSnapshot)e.getValue(), (IMultiStateSnapshot)afterState.get(e.getKey()))).collect(Collectors.toSet())));
        this.currentIndex = 0;
        int maxSize = IChiselsAndBitsAPI.getInstance().getConfiguration().getServer().getChangeTrackerSize().get();
        if (this.changes.size() > maxSize) {
            while (this.changes.size() > maxSize) {
                this.changes.removeLast();
            }
        }
        this.sendUpdate();
    }

    @Override
    public Deque<IChange> getChanges() {
        return new LinkedList<IChange>(this.changes);
    }

    @Override
    public void clear() {
        this.changes.clear();
        this.sendUpdate();
    }

    public Optional<IChange> getCurrentUndo() {
        if (this.getChanges().size() <= this.currentIndex || this.currentIndex < 0) {
            return Optional.empty();
        }
        return Optional.of((IChange)this.changes.get(this.currentIndex));
    }

    public Optional<IChange> getCurrentRedo() {
        if (this.getChanges().size() < this.currentIndex || this.currentIndex < 1) {
            return Optional.empty();
        }
        return Optional.of((IChange)this.changes.get(this.currentIndex - 1));
    }

    @Override
    public boolean canUndo(Player player) {
        return this.getCurrentUndo().map(c -> c.canUndo(player)).orElse(false);
    }

    @Override
    public boolean canRedo(Player player) {
        return this.getCurrentRedo().map(c -> c.canRedo(player)).orElse(false);
    }

    @Override
    public void undo(Player player) throws IllegalChangeAttempt {
        if (!this.canUndo(player)) {
            throw new IllegalChangeAttempt();
        }
        if (this.getCurrentUndo().isPresent()) {
            IChange change = this.getCurrentUndo().get();
            change.undo(player);
            this.currentIndex = Math.min(this.changes.size(), this.currentIndex + 1);
            this.sendUpdate();
        }
    }

    @Override
    public void redo(Player player) throws IllegalChangeAttempt {
        if (!this.canRedo(player)) {
            throw new IllegalChangeAttempt();
        }
        if (this.getCurrentRedo().isPresent()) {
            IChange change = this.getCurrentRedo().get();
            change.redo(player);
            this.currentIndex = Math.max(0, this.currentIndex - 1);
            this.sendUpdate();
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("changes", (Tag)this.changes.stream().map(INBTSerializable::serializeNBT).collect(Collectors.toCollection(ListTag::new)));
        tag.m_128405_("index", this.currentIndex);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.changes.clear();
        this.changes.addAll(nbt.m_128437_("changes", 10).stream().map(CombinedChange::new).collect(Collectors.toList()));
        this.currentIndex = nbt.m_128451_("index");
    }

    private void sendUpdate() {
        ServerPlayer serverPlayer;
        Player player;
        if (this.player != null && (player = this.player) instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)player).m_183503_().m_5776_()) {
            ChiselsAndBits.getInstance().getNetworkChannel().sendToPlayer(new ChangeTrackerUpdatedPacket(this.serializeNBT()), serverPlayer);
        }
    }
}

