/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling.modes.line;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import mod.chiselsandbits.api.axissize.CollisionType;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.platforms.core.registries.AbstractCustomRegistryEntry;
import mod.chiselsandbits.registrars.ModChiselModeGroups;
import mod.chiselsandbits.utils.BitInventoryUtils;
import mod.chiselsandbits.utils.ItemStackUtils;
import mod.chiselsandbits.voxelshape.VoxelShapeManager;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class LinedChiselMode
extends AbstractCustomRegistryEntry
implements IChiselMode {
    private final int bitsPerSide;
    private final MutableComponent displayName;
    private final MutableComponent multiLineDisplayName;
    private final ResourceLocation iconName;

    LinedChiselMode(int bitsPerSide, MutableComponent displayName, MutableComponent multiLineDisplayName, ResourceLocation iconName) {
        this.bitsPerSide = bitsPerSide;
        this.displayName = displayName;
        this.multiLineDisplayName = multiLineDisplayName;
        this.iconName = iconName;
    }

    @Override
    public ClickProcessingState onLeftClickBy(Player playerEntity, IChiselingContext context) {
        Optional<ClickProcessingState> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, face -> Vec3.m_82528_((Vec3i)face.m_122424_().m_122436_()), Direction::m_122424_, false);
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        return rayTraceHandle.orElseGet(() -> context.getMutator().map(mutator -> {
            try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                context.setComplete();
                HashMap resultingBitCount = Maps.newHashMap();
                mutator.inWorldMutableStream().forEach(state -> {
                    BlockState currentState = state.getState();
                    if (context.tryDamageItem()) {
                        resultingBitCount.putIfAbsent(currentState, 0);
                        resultingBitCount.computeIfPresent(currentState, (s, currentCount) -> currentCount + 1);
                        state.clear();
                    }
                });
                resultingBitCount.forEach((blockState, count) -> BitInventoryUtils.insertIntoOrSpawn(playerEntity, blockState, count));
            }
            return ClickProcessingState.ALLOW;
        }).orElse(ClickProcessingState.DEFAULT));
    }

    @Override
    public void onStoppedLeftClicking(Player playerEntity, IChiselingContext context) {
    }

    @Override
    public ClickProcessingState onRightClickBy(Player playerEntity, IChiselingContext context) {
        Optional<ClickProcessingState> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, face -> Vec3.m_82528_((Vec3i)face.m_122436_()), Function.identity(), true);
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        return rayTraceHandle.orElseGet(() -> context.getMutator().map(mutator -> {
            BlockPos heightPos;
            BlockState heldBlockState = ItemStackUtils.getHeldBitBlockStateFromPlayer(playerEntity);
            if (heldBlockState.m_60795_()) {
                return ClickProcessingState.DEFAULT;
            }
            int missingBitCount = (int)mutator.stream().filter(state -> state.getState().m_60795_()).count();
            IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(playerEntity);
            context.setComplete();
            if (playerBitInventory.canExtract(heldBlockState, missingBitCount) || playerEntity.m_7500_()) {
                if (!playerEntity.m_7500_()) {
                    playerBitInventory.extract(heldBlockState, missingBitCount);
                }
                try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                    mutator.inWorldMutableStream().filter(state -> state.getState().m_60795_()).forEach(state -> state.overrideState(heldBlockState));
                }
            } else {
                context.setError(LocalStrings.ChiselAttemptFailedNotEnoughBits.getText(heldBlockState.m_60734_().m_49954_()));
            }
            if (missingBitCount == 0 && (heightPos = new BlockPos(mutator.getInWorldEndPoint())).m_123342_() >= context.getWorld().m_151558_()) {
                MutableComponent component = new TranslatableComponent("build.tooHigh", new Object[]{context.getWorld().m_151558_() - 1}).m_130940_(ChatFormatting.RED);
                playerEntity.m_6352_((Component)component, Util.f_137441_);
            }
            return ClickProcessingState.ALLOW;
        }).orElse(ClickProcessingState.DEFAULT));
    }

    @Override
    public void onStoppedRightClicking(Player playerEntity, IChiselingContext context) {
    }

    @Override
    public Optional<IAreaAccessor> getCurrentAccessor(IChiselingContext context) {
        return context.getMutator().map(mutator -> mutator);
    }

    private Optional<ClickProcessingState> processRayTraceIntoContext(Player playerEntity, IChiselingContext context, Function<Direction, Vec3> placementFacingAdapter, Function<Direction, Direction> iterationAdaptor, boolean airOnly) {
        HitResult rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.m_6662_() != HitResult.Type.BLOCK || !(rayTraceResult instanceof BlockHitResult)) {
            context.setError(LocalStrings.ChiselAttemptFailedNoBlock.getText());
            return Optional.of(ClickProcessingState.DEFAULT);
        }
        BlockHitResult blockRayTraceResult = (BlockHitResult)rayTraceResult;
        Vec3 hitVector = blockRayTraceResult.m_82450_().m_82549_(placementFacingAdapter.apply(blockRayTraceResult.m_82434_()).m_82542_((double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit()));
        Vec3 hitBlockPosVector = Vec3.m_82528_((Vec3i)new BlockPos(hitVector));
        Vec3 inBlockHitVector = hitVector.m_82546_(hitBlockPosVector);
        Vec3 inBlockBitVector = inBlockHitVector.m_82542_((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide());
        Direction iterationDirection = iterationAdaptor.apply(blockRayTraceResult.m_82434_());
        switch (iterationDirection) {
            case DOWN: {
                this.includeDownAxis(context, airOnly, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case UP: {
                this.includeUpAxis(context, airOnly, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case NORTH: {
                this.includeNorthAxis(context, airOnly, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case SOUTH: {
                this.includeSouthAxis(context, airOnly, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case WEST: {
                this.includeWestAxis(context, airOnly, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case EAST: {
                this.includeEastAxis(context, airOnly, hitBlockPosVector, inBlockBitVector);
            }
        }
        return Optional.empty();
    }

    private void includeDownAxis(IChiselingContext context, boolean airOnly, Vec3 hitBlockPosVector, Vec3 inBlockBitVector) {
        if (this.bitsPerSide == 1) {
            int yOff = 0;
            while ((double)yOff < inBlockBitVector.m_7098_()) {
                Vec3 targetBit = inBlockBitVector.m_82492_(0.0, (double)yOff, 0.0);
                Vec3 inWorldOffset = this.clampVectorToBlock(targetBit.m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()));
                Vec3 inWorldTarget = hitBlockPosVector.m_82549_(inWorldOffset);
                if (!context.getInAreaTarget(inWorldTarget).map(state -> !state.getState().m_60795_() ^ airOnly).orElse(airOnly).booleanValue()) {
                    return;
                }
                context.include(inWorldTarget);
                ++yOff;
            }
            return;
        }
        for (int xOff = -this.bitsPerSide / 2; xOff < this.bitsPerSide / 2; ++xOff) {
            for (int zOff = -this.bitsPerSide / 2; zOff < this.bitsPerSide / 2; ++zOff) {
                Vec3 targetBit;
                Vec3 inWorldOffset;
                Vec3 inWorldTarget;
                int yOff = 0;
                while ((double)yOff < inBlockBitVector.m_7098_() && context.getInAreaTarget(inWorldTarget = hitBlockPosVector.m_82549_(inWorldOffset = this.clampVectorToBlock((targetBit = inBlockBitVector.m_82492_((double)xOff, (double)yOff, (double)zOff)).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())))).map(state -> !state.getState().m_60795_() ^ airOnly).orElse(airOnly).booleanValue()) {
                    context.include(inWorldTarget);
                    ++yOff;
                }
            }
        }
    }

    private void includeUpAxis(IChiselingContext context, boolean airOnly, Vec3 hitBlockPosVector, Vec3 inBlockBitVector) {
        if (this.bitsPerSide == 1) {
            int yOff = 0;
            while ((double)yOff < (double)StateEntrySize.current().getBitsPerBlockSide() - inBlockBitVector.m_7098_()) {
                Vec3 targetBit = inBlockBitVector.m_82492_(0.0, (double)(-yOff), 0.0);
                Vec3 inWorldOffset = this.clampVectorToBlock(targetBit.m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()));
                Vec3 inWorldTarget = hitBlockPosVector.m_82549_(inWorldOffset);
                if (!context.getInAreaTarget(inWorldTarget).map(state -> !state.getState().m_60795_() ^ airOnly).orElse(airOnly).booleanValue()) {
                    return;
                }
                context.include(inWorldTarget);
                ++yOff;
            }
            return;
        }
        for (int xOff = -this.bitsPerSide / 2; xOff < this.bitsPerSide / 2; ++xOff) {
            for (int zOff = -this.bitsPerSide / 2; zOff < this.bitsPerSide / 2; ++zOff) {
                Vec3 targetBit;
                Vec3 inWorldOffset;
                Vec3 inWorldTarget;
                int yOff = 0;
                while ((double)yOff < (double)StateEntrySize.current().getBitsPerBlockSide() - inBlockBitVector.m_7098_() && context.getInAreaTarget(inWorldTarget = hitBlockPosVector.m_82549_(inWorldOffset = this.clampVectorToBlock((targetBit = inBlockBitVector.m_82492_((double)xOff, (double)(-yOff), (double)zOff)).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())))).map(state -> !state.getState().m_60795_() ^ airOnly).orElse(airOnly).booleanValue()) {
                    context.include(inWorldTarget);
                    ++yOff;
                }
            }
        }
    }

    private void includeNorthAxis(IChiselingContext context, boolean airOnly, Vec3 hitBlockPosVector, Vec3 inBlockBitVector) {
        if (this.bitsPerSide == 1) {
            int zOff = 0;
            while ((double)zOff < inBlockBitVector.m_7094_()) {
                Vec3 targetBit = inBlockBitVector.m_82492_(0.0, 0.0, (double)zOff);
                Vec3 inWorldOffset = this.clampVectorToBlock(targetBit.m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()));
                Vec3 inWorldTarget = hitBlockPosVector.m_82549_(inWorldOffset);
                if (!context.getInAreaTarget(inWorldTarget).map(state -> !state.getState().m_60795_() ^ airOnly).orElse(airOnly).booleanValue()) {
                    return;
                }
                context.include(inWorldTarget);
                ++zOff;
            }
            return;
        }
        for (int xOff = -this.bitsPerSide / 2; xOff < this.bitsPerSide / 2; ++xOff) {
            for (int yOff = -this.bitsPerSide / 2; yOff < this.bitsPerSide / 2; ++yOff) {
                Vec3 targetBit;
                Vec3 inWorldOffset;
                Vec3 inWorldTarget;
                int zOff = 0;
                while ((double)zOff < inBlockBitVector.m_7094_() && context.getInAreaTarget(inWorldTarget = hitBlockPosVector.m_82549_(inWorldOffset = this.clampVectorToBlock((targetBit = inBlockBitVector.m_82492_((double)xOff, (double)yOff, (double)zOff)).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())))).map(state -> !state.getState().m_60795_() ^ airOnly).orElse(airOnly).booleanValue()) {
                    context.include(inWorldTarget);
                    ++zOff;
                }
            }
        }
    }

    private void includeSouthAxis(IChiselingContext context, boolean airOnly, Vec3 hitBlockPosVector, Vec3 inBlockBitVector) {
        if (this.bitsPerSide == 1) {
            int zOff = 0;
            while ((double)zOff < (double)StateEntrySize.current().getBitsPerBlockSide() - inBlockBitVector.m_7094_()) {
                Vec3 targetBit = inBlockBitVector.m_82492_(0.0, 0.0, (double)(-zOff));
                Vec3 inWorldOffset = this.clampVectorToBlock(targetBit.m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()));
                Vec3 inWorldTarget = hitBlockPosVector.m_82549_(inWorldOffset);
                if (!context.getInAreaTarget(inWorldTarget).map(state -> !state.getState().m_60795_() ^ airOnly).orElse(airOnly).booleanValue()) {
                    return;
                }
                context.include(inWorldTarget);
                ++zOff;
            }
            return;
        }
        for (int xOff = -this.bitsPerSide / 2; xOff < this.bitsPerSide / 2; ++xOff) {
            for (int yOff = -this.bitsPerSide / 2; yOff < this.bitsPerSide / 2; ++yOff) {
                Vec3 targetBit;
                Vec3 inWorldOffset;
                Vec3 inWorldTarget;
                int zOff = 0;
                while ((double)zOff < (double)StateEntrySize.current().getBitsPerBlockSide() - inBlockBitVector.m_7094_() && context.getInAreaTarget(inWorldTarget = hitBlockPosVector.m_82549_(inWorldOffset = this.clampVectorToBlock((targetBit = inBlockBitVector.m_82492_((double)xOff, (double)yOff, (double)(-zOff))).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())))).map(state -> !state.getState().m_60795_() ^ airOnly).orElse(airOnly).booleanValue()) {
                    context.include(inWorldTarget);
                    ++zOff;
                }
            }
        }
    }

    private void includeWestAxis(IChiselingContext context, boolean airOnly, Vec3 hitBlockPosVector, Vec3 inBlockBitVector) {
        if (this.bitsPerSide == 1) {
            int xOff = 0;
            while ((double)xOff < inBlockBitVector.m_7096_()) {
                Vec3 targetBit = inBlockBitVector.m_82492_((double)xOff, 0.0, 0.0);
                Vec3 inWorldOffset = this.clampVectorToBlock(targetBit.m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()));
                Vec3 inWorldTarget = hitBlockPosVector.m_82549_(inWorldOffset);
                if (!context.getInAreaTarget(inWorldTarget).map(state -> !state.getState().m_60795_() ^ airOnly).orElse(airOnly).booleanValue()) {
                    return;
                }
                context.include(inWorldTarget);
                ++xOff;
            }
            return;
        }
        for (int zOff = -this.bitsPerSide / 2; zOff < this.bitsPerSide / 2; ++zOff) {
            for (int yOff = -this.bitsPerSide / 2; yOff < this.bitsPerSide / 2; ++yOff) {
                Vec3 targetBit;
                Vec3 inWorldOffset;
                Vec3 inWorldTarget;
                int xOff = 0;
                while ((double)xOff < inBlockBitVector.m_7096_() && context.getInAreaTarget(inWorldTarget = hitBlockPosVector.m_82549_(inWorldOffset = this.clampVectorToBlock((targetBit = inBlockBitVector.m_82492_((double)xOff, (double)yOff, (double)zOff)).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())))).map(state -> !state.getState().m_60795_() ^ airOnly).orElse(airOnly).booleanValue()) {
                    context.include(inWorldTarget);
                    ++xOff;
                }
            }
        }
    }

    private void includeEastAxis(IChiselingContext context, boolean airOnly, Vec3 hitBlockPosVector, Vec3 inBlockBitVector) {
        if (this.bitsPerSide == 1) {
            int xOff = 0;
            while ((double)xOff < (double)StateEntrySize.current().getBitsPerBlockSide() - inBlockBitVector.m_7096_()) {
                Vec3 targetBit = inBlockBitVector.m_82492_((double)(-xOff), 0.0, 0.0);
                Vec3 inWorldOffset = this.clampVectorToBlock(targetBit.m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()));
                Vec3 inWorldTarget = hitBlockPosVector.m_82549_(inWorldOffset);
                if (!context.getInAreaTarget(inWorldTarget).map(state -> !state.getState().m_60795_() ^ airOnly).orElse(airOnly).booleanValue()) {
                    return;
                }
                context.include(inWorldTarget);
                ++xOff;
            }
            return;
        }
        for (int zOff = -this.bitsPerSide / 2; zOff < this.bitsPerSide / 2; ++zOff) {
            for (int yOff = -this.bitsPerSide / 2; yOff < this.bitsPerSide / 2; ++yOff) {
                Vec3 targetBit;
                Vec3 inWorldOffset;
                Vec3 inWorldTarget;
                int xOff = 0;
                while ((double)xOff < (double)StateEntrySize.current().getBitsPerBlockSide() - inBlockBitVector.m_7096_() && context.getInAreaTarget(inWorldTarget = hitBlockPosVector.m_82549_(inWorldOffset = this.clampVectorToBlock((targetBit = inBlockBitVector.m_82492_((double)(-xOff), (double)yOff, (double)zOff)).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())))).map(state -> !state.getState().m_60795_() ^ airOnly).orElse(airOnly).booleanValue()) {
                    context.include(inWorldTarget);
                    ++xOff;
                }
            }
        }
    }

    private Vec3 clampVectorToBlock(Vec3 v) {
        return new Vec3(v.m_7096_() < 0.0 ? 0.0 : (v.m_7096_() >= 1.0 ? (double)0.999f : v.m_7096_()), v.m_7098_() < 0.0 ? 0.0 : (v.m_7098_() >= 1.0 ? (double)0.999f : v.m_7098_()), v.m_7094_() < 0.0 ? 0.0 : (v.m_7094_() >= 1.0 ? (double)0.999f : v.m_7094_()));
    }

    @Override
    public VoxelShape getShape(IChiselingContext context) {
        if (context.getMutator().isEmpty()) {
            return Shapes.m_83040_();
        }
        return VoxelShapeManager.getInstance().get((IAreaAccessor)context.getMutator().get(), CollisionType.ALL);
    }

    @Override
    @NotNull
    public ResourceLocation getIcon() {
        return this.iconName;
    }

    @Override
    public Component getDisplayName() {
        return this.displayName;
    }

    public MutableComponent getMultiLineDisplayName() {
        return this.multiLineDisplayName;
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.of(ModChiselModeGroups.LINE);
    }
}

