/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.inventory.bit.IBitInventoryItem;
import mod.chiselsandbits.api.inventory.bit.IBitInventoryItemStack;
import mod.chiselsandbits.api.item.bit.IBitItem;
import mod.chiselsandbits.container.helper.MergeSupportingHelperContainer;
import mod.chiselsandbits.inventory.wrapping.WrappingInventory;
import mod.chiselsandbits.network.packets.BagGuiStackPacket;
import mod.chiselsandbits.registrars.ModContainerTypes;
import mod.chiselsandbits.slots.BitSlot;
import mod.chiselsandbits.slots.ReadonlySlot;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BagContainer
extends AbstractContainerMenu {
    static final int OUTER_SLOT_SIZE = 18;
    public final List<Slot> customSlots = new ArrayList<Slot>();
    public final List<ItemStack> customSlotsItems = new ArrayList<ItemStack>();
    final Player thePlayer;
    final WrappingInventory visibleInventory = new WrappingInventory();
    IBitInventoryItemStack bagInv;
    ReadonlySlot bagSlot;

    public BagContainer(int id, Inventory playerInventory) {
        super(ModContainerTypes.BIT_BAG.get(), id);
        this.thePlayer = playerInventory.f_35978_;
        int playerInventoryOffset = 54;
        ItemStack is = this.thePlayer.m_21205_();
        this.setBag(is);
        for (int yOffset = 0; yOffset < 7; ++yOffset) {
            for (int xOffset = 0; xOffset < 9; ++xOffset) {
                this.addCustomSlot(new BitSlot(this.visibleInventory, xOffset + yOffset * 9, 8 + xOffset * 18, 18 + yOffset * 18));
            }
        }
        for (int xPlayerInventory = 0; xPlayerInventory < 3; ++xPlayerInventory) {
            for (int yPlayerInventory = 0; yPlayerInventory < 9; ++yPlayerInventory) {
                this.m_38897_(new Slot((Container)this.thePlayer.m_150109_(), yPlayerInventory + xPlayerInventory * 9 + 9, 8 + yPlayerInventory * 18, 104 + xPlayerInventory * 18 + 54));
            }
        }
        for (int xToolbar = 0; xToolbar < 9; ++xToolbar) {
            if (this.thePlayer.m_150109_().f_35977_ == xToolbar) {
                this.bagSlot = new ReadonlySlot((Container)this.thePlayer.m_150109_(), xToolbar, 8 + xToolbar * 18, 216);
                this.m_38897_(this.bagSlot);
                continue;
            }
            this.m_38897_(new Slot((Container)this.thePlayer.m_150109_(), xToolbar, 8 + xToolbar * 18, 216));
        }
    }

    private void setBag(ItemStack bagItem) {
        Item item;
        if (!bagItem.m_41619_() && (item = bagItem.m_41720_()) instanceof IBitInventoryItem) {
            IBitInventoryItem bitInventoryItem = (IBitInventoryItem)item;
            this.bagInv = bitInventoryItem.create(bagItem);
            this.visibleInventory.setWrapped(this.bagInv);
        } else {
            this.bagInv = null;
        }
    }

    private void addCustomSlot(BitSlot newSlot) {
        newSlot.f_40219_ = this.customSlots.size();
        this.customSlots.add(newSlot);
        this.customSlotsItems.add(ItemStack.f_41583_);
    }

    public void handleCustomSlotAction(int slotNumber, int mouseButton, boolean duplicateButton, boolean holdingShift) {
        Slot slot = this.customSlots.get(slotNumber);
        ItemStack held = this.m_142621_();
        ItemStack slotStack = slot.m_7993_();
        if (duplicateButton && this.thePlayer.m_7500_()) {
            if (slot.m_6657_() && held.m_41619_()) {
                ItemStack is = slot.m_7993_().m_41777_();
                is.m_41764_(is.m_41741_());
                this.m_142503_(is);
            }
        } else if (holdingShift) {
            if (!slotStack.m_41619_()) {
                this.transferStack(slotNumber, false);
            }
        } else if (mouseButton == 0 && !duplicateButton) {
            if (held.m_41619_() && slot.m_6657_()) {
                ItemStack pulled = slotStack.m_41777_();
                pulled.m_41764_(Math.min(pulled.m_41741_(), pulled.m_41613_()));
                ItemStack newStackSlot = slotStack.m_41777_();
                newStackSlot.m_41764_(pulled.m_41613_() >= slotStack.m_41613_() ? 0 : slotStack.m_41613_() - pulled.m_41613_());
                slot.m_5852_(newStackSlot.m_41613_() <= 0 ? ItemStack.f_41583_ : newStackSlot);
                this.m_142503_(pulled);
            } else if (!held.m_41619_() && slot.m_6657_() && slot.m_5857_(held)) {
                if (held.m_41720_() == slotStack.m_41720_() && held.m_41773_() == slotStack.m_41773_() && ItemStack.m_41658_((ItemStack)held, (ItemStack)slotStack)) {
                    ItemStack newStackSlot = slotStack.m_41777_();
                    newStackSlot.m_41764_(newStackSlot.m_41613_() + held.m_41613_());
                    int held_stackSize = 0;
                    if (newStackSlot.m_41613_() > slot.m_6641_()) {
                        held_stackSize = newStackSlot.m_41613_() - slot.m_6641_();
                        newStackSlot.m_41764_(newStackSlot.m_41613_() - held_stackSize);
                    }
                    slot.m_5852_(newStackSlot);
                    held.m_41764_(held_stackSize);
                    this.m_142503_(held);
                } else if (!held.m_41619_() && slot.m_6657_() && slotStack.m_41613_() <= slotStack.m_41741_()) {
                    slot.m_5852_(held);
                    this.m_142503_(slotStack);
                }
            } else if (!held.m_41619_() && !slot.m_6657_() && slot.m_5857_(held)) {
                slot.m_5852_(held);
                this.m_142503_(ItemStack.f_41583_);
            }
        } else if (mouseButton == 1 && !duplicateButton) {
            if (held.m_41619_() && slot.m_6657_()) {
                ItemStack pulled = slotStack.m_41777_();
                pulled.m_41764_(Math.max(1, (Math.min(pulled.m_41741_(), pulled.m_41613_()) + 1) / 2));
                ItemStack newStackSlot = slotStack.m_41777_();
                newStackSlot.m_41764_(pulled.m_41613_() >= slotStack.m_41613_() ? 0 : slotStack.m_41613_() - pulled.m_41613_());
                slot.m_5852_(newStackSlot.m_41613_() <= 0 ? ItemStack.f_41583_ : newStackSlot);
                this.m_142503_(pulled);
            } else if (!held.m_41619_() && slot.m_6657_() && slot.m_5857_(held)) {
                if (held.m_41720_() == slotStack.m_41720_() && held.m_41773_() == slotStack.m_41773_() && ItemStack.m_41658_((ItemStack)held, (ItemStack)slotStack)) {
                    ItemStack newStackSlot = slotStack.m_41777_();
                    newStackSlot.m_41764_(newStackSlot.m_41613_() + 1);
                    int held_quantity = held.m_41613_() - 1;
                    if (newStackSlot.m_41613_() > slot.m_6641_()) {
                        int diff = newStackSlot.m_41613_() - slot.m_6641_();
                        held_quantity += diff;
                        newStackSlot.m_41764_(newStackSlot.m_41613_() - diff);
                    }
                    slot.m_5852_(newStackSlot);
                    held.m_41764_(held_quantity);
                    this.m_142503_(!held.m_41619_() ? held : ItemStack.f_41583_);
                }
            } else if (!held.m_41619_() && !slot.m_6657_() && slot.m_5857_(held)) {
                ItemStack newStackSlot = held.m_41777_();
                newStackSlot.m_41764_(newStackSlot.m_41613_() + 1);
                held.m_41764_(held.m_41613_() - 1);
                slot.m_5852_(newStackSlot);
                this.m_142503_(!held.m_41619_() ? held : ItemStack.f_41583_);
            }
        }
    }

    public void m_38946_() {
        super.m_38946_();
        for (int slotIdx = 0; slotIdx < this.customSlots.size(); ++slotIdx) {
            ItemStack realStack = this.customSlots.get(slotIdx).m_7993_();
            ItemStack clientStack = this.customSlotsItems.get(slotIdx);
            if (ItemStack.m_41728_((ItemStack)clientStack, (ItemStack)realStack)) continue;
            clientStack = realStack.m_41619_() ? ItemStack.f_41583_ : realStack.m_41777_();
            this.customSlotsItems.set(slotIdx, clientStack);
            for (ContainerListener cl : this.f_38848_) {
                if (!(cl instanceof ServerPlayer)) continue;
                BagGuiStackPacket packet = new BagGuiStackPacket(slotIdx, clientStack);
                ChiselsAndBits.getInstance().getNetworkChannel().sendToPlayer(packet, (ServerPlayer)cl);
            }
        }
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player playerIn, int index) {
        return this.transferStack(index, true);
    }

    public boolean m_6875_(@NotNull Player playerIn) {
        return this.bagInv != null && playerIn == this.thePlayer && this.hasBagInHand(this.thePlayer);
    }

    private boolean hasBagInHand(Player player) {
        if (this.bagInv.toItemStack() != player.m_21205_()) {
            this.setBag(player.m_21205_());
        }
        return this.bagInv != null && this.bagInv.toItemStack().m_41720_() instanceof IBitInventoryItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ItemStack transferStack(int index, boolean normalToBag) {
        ItemStack someReturnValue = ItemStack.f_41583_;
        boolean reverse = true;
        MergeSupportingHelperContainer helper = new MergeSupportingHelperContainer();
        if (!normalToBag) {
            helper.f_38839_.clear();
            helper.f_38839_.addAll(this.customSlots);
        } else {
            helper.f_38839_.clear();
            helper.f_38839_.addAll((Collection)this.f_38839_);
            reverse = false;
        }
        Slot slot = (Slot)helper.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            IBitItem bitItem;
            ItemStack transferStack = slot.m_7993_();
            someReturnValue = transferStack.m_41777_();
            int extraItems = 0;
            if (transferStack.m_41613_() > transferStack.m_41741_()) {
                extraItems = transferStack.m_41613_() - transferStack.m_41741_();
                transferStack.m_41764_(transferStack.m_41741_());
            }
            if (normalToBag) {
                helper.f_38839_.clear();
                helper.f_38839_.addAll(this.customSlots);
            } else {
                helper.f_38839_.clear();
                helper.f_38839_.addAll((Collection)this.f_38839_);
            }
            Item transferItem = transferStack.m_41720_();
            if (transferItem instanceof IBitItem) {
                bitItem = (IBitItem)transferItem;
                bitItem.onMergeOperationWithBagBeginning();
            }
            try {
                if (!helper.doMergeItemStack(transferStack, 0, helper.f_38839_.size(), reverse)) {
                    bitItem = ItemStack.f_41583_;
                    return bitItem;
                }
            }
            finally {
                transferStack.m_41764_(transferStack.m_41613_() + extraItems);
                if (transferItem instanceof IBitItem) {
                    IBitItem bitItem2 = (IBitItem)transferItem;
                    bitItem2.onMergeOperationWithBagEnding();
                }
            }
            if (transferStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return someReturnValue;
    }

    public void clear(ItemStack stack) {
        Item item;
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof IBitItem) {
            IBitItem bitItem = (IBitItem)item;
            this.bagInv.clear(bitItem.getBitState(stack));
        } else {
            this.bagInv.m_6211_();
        }
        this.m_142503_(ItemStack.f_41583_);
        this.m_150414_(this);
    }

    public void sort() {
        this.bagInv.sort();
        this.m_150414_(this);
    }
}

