/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.neighborhood;

import java.util.Objects;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import net.minecraft.world.level.block.state.BlockState;

public final class BlockNeighborhoodEntry {
    private final BlockState blockState;
    private final IAreaAccessor accessor;
    private final IAreaShapeIdentifier identifier;

    public BlockNeighborhoodEntry(BlockState blockState, IAreaAccessor accessor) {
        this.blockState = blockState;
        this.accessor = accessor;
        this.identifier = this.accessor.createNewShapeIdentifier();
    }

    public BlockNeighborhoodEntry(BlockState blockState) {
        this.blockState = blockState;
        this.accessor = null;
        this.identifier = IAreaShapeIdentifier.DUMMY;
    }

    public int hashCode() {
        int result = this.blockState != null ? this.blockState.hashCode() : 0;
        result = 31 * result + (this.identifier != null ? this.identifier.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockNeighborhoodEntry)) {
            return false;
        }
        BlockNeighborhoodEntry that = (BlockNeighborhoodEntry)o;
        if (!Objects.equals(this.blockState, that.blockState)) {
            return false;
        }
        return Objects.equals(this.identifier, that.identifier);
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public IAreaAccessor getAccessor() {
        return this.accessor;
    }

    public IAreaShapeIdentifier getIdentifier() {
        return this.identifier;
    }
}

