/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.pattern.placement;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.block.IMultiStateBlock;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.pattern.placement.IPatternPlacementType;
import mod.chiselsandbits.api.pattern.placement.PlacementResult;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.ColorUtils;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.platforms.core.registries.AbstractCustomRegistryEntry;
import mod.chiselsandbits.registrars.ModPatternPlacementTypes;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CarvePatternPlacementType
extends AbstractCustomRegistryEntry
implements IPatternPlacementType {
    @Override
    @NotNull
    public ResourceLocation getIcon() {
        return new ResourceLocation("chiselsandbits", "textures/icons/pattern_carve.png");
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.empty();
    }

    @Override
    public VoxelShape buildVoxelShapeForWireframe(IMultiStateSnapshot sourceSnapshot, Player player, Vec3 targetedPoint, Direction hitFace) {
        return ModPatternPlacementTypes.PLACEMENT.get().buildVoxelShapeForWireframe(sourceSnapshot, player, targetedPoint, hitFace);
    }

    @Override
    public PlacementResult performPlacement(IMultiStateSnapshot source, BlockPlaceContext context, boolean simulate) {
        boolean hasRequiredSpace;
        Vec3 targetedPosition = context.m_43723_().m_6047_() ? context.m_43720_() : Vec3.m_82528_((Vec3i)context.m_8083_().m_141952_(context.m_43719_().m_122424_().m_122436_()));
        IWorldAreaMutator areaMutator = IMutatorFactory.getInstance().covering((LevelAccessor)context.m_43725_(), targetedPosition, targetedPosition.m_82520_(0.9999, 0.9999, 0.9999));
        boolean isChiseledBlock = BlockPosStreamProvider.getForRange(areaMutator.getInWorldStartPoint(), areaMutator.getInWorldEndPoint()).map(pos -> context.m_43725_().m_8055_(pos)).allMatch(state -> state.m_60734_() instanceof IMultiStateBlock);
        if (!isChiseledBlock) {
            return PlacementResult.failure(ColorUtils.NOT_FITTING_PATTERN_PLACEMENT_COLOR, (Component)LocalStrings.PatternPlacementNotAChiseledBlock.getText());
        }
        Map<BlockState, Integer> totalRemovedBits = source.stream().filter(s -> !s.getState().m_60795_()).filter(s -> {
            Optional<IStateEntryInfo> o = areaMutator.getInAreaTarget(s.getStartPoint());
            return o.filter(os -> !os.getState().m_60795_()).map(os -> !os.getState().equals(s.getState())).orElse(false);
        }).map(s -> areaMutator.getInAreaTarget(s.getStartPoint())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(IStateEntryInfo::getState, s -> 1, Integer::sum));
        IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(context.m_43723_());
        boolean bl = hasRequiredSpace = context.m_43723_().m_7500_() || totalRemovedBits.entrySet().stream().allMatch(e -> playerBitInventory.canInsert((BlockState)e.getKey(), (Integer)e.getValue()));
        if (!hasRequiredSpace) {
            return PlacementResult.failure(ColorUtils.MISSING_BITS_OR_SPACE_PATTERN_PLACEMENT_COLOR, (Component)LocalStrings.PatternPlacementNoBitSpace.getText());
        }
        if (simulate) {
            return PlacementResult.success();
        }
        try (IBatchMutation ignored = areaMutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(context.m_43723_()));){
            source.stream().filter(s -> !s.getState().m_60795_()).forEach(stateEntryInfo -> areaMutator.clearInAreaTarget(stateEntryInfo.getStartPoint()));
        }
        if (!context.m_43723_().m_7500_()) {
            totalRemovedBits.forEach(playerBitInventory::insertOrDiscard);
        }
        return PlacementResult.success();
    }

    @Override
    public Vec3 getTargetedPosition(ItemStack heldStack, Player player, BlockHitResult blockRayTraceResult) {
        if (player.m_6047_()) {
            return blockRayTraceResult.m_82450_();
        }
        return Vec3.m_82528_((Vec3i)blockRayTraceResult.m_82425_());
    }

    @Override
    public Component getDisplayName() {
        return LocalStrings.PatternPlacementModeCarving.getText();
    }
}

