/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.platforms.core.network;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mod.chiselsandbits.platforms.core.IChiselsAndBitsPlatformCore;
import mod.chiselsandbits.platforms.core.network.INetworkChannelManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.LevelChunk;

public interface INetworkChannel {
    public static INetworkChannel create(ResourceLocation name, Supplier<String> networkProtocolVersion, Predicate<String> clientAcceptedVersions, Predicate<String> serverAcceptedVersions) {
        return INetworkChannelManager.getInstance().create(name, networkProtocolVersion, clientAcceptedVersions, serverAcceptedVersions);
    }

    public <T> void register(int var1, Class<T> var2, BiConsumer<T, FriendlyByteBuf> var3, Function<FriendlyByteBuf, T> var4, MessageExecutionHandler<T> var5);

    public void sendToServer(Object var1);

    public void sendToPlayer(Object var1, ServerPlayer var2);

    default public void sendToEveryone(Object msg) {
        IChiselsAndBitsPlatformCore.getInstance().getCurrentServer().m_6846_().m_11314_().forEach(player -> this.sendToPlayer(msg, (ServerPlayer)player));
    }

    default public void sendToTrackingChunk(Object msg, LevelChunk chunk) {
        ((ServerChunkCache)chunk.m_62953_().m_7726_()).f_8325_.m_183262_(chunk.m_7697_(), false).forEach(serverPlayer -> this.sendToPlayer(msg, (ServerPlayer)serverPlayer));
    }

    public static interface MessageExecutionHandler<T> {
        public void execute(T var1, boolean var2, Player var3, Consumer<Runnable> var4);
    }
}

