/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.reloading;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import mod.chiselsandbits.aabb.AABBManager;
import mod.chiselsandbits.api.reloading.ICacheClearingHandler;
import mod.chiselsandbits.change.ChangeTrackerManger;
import mod.chiselsandbits.chiseling.LocalChiselingContextCache;
import mod.chiselsandbits.voxelshape.VoxelShapeManager;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DataReloadingResourceManager
implements PreparableReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DataReloadingResourceManager INSTANCE = new DataReloadingResourceManager();
    private final Set<ICacheClearingHandler> cacheClearingHandlers = Sets.newConcurrentHashSet();

    public static DataReloadingResourceManager getInstance() {
        return INSTANCE;
    }

    private DataReloadingResourceManager() {
    }

    public DataReloadingResourceManager registerCacheClearer(ICacheClearingHandler cacheClearingHandler) {
        this.cacheClearingHandlers.add(cacheClearingHandler);
        return this;
    }

    public void onResourceManagerReload() {
        LOGGER.info("Resetting common caches");
        this.cacheClearingHandlers.forEach(ICacheClearingHandler::clear);
    }

    public void setup() {
        this.cacheClearingHandlers.clear();
        this.registerCacheClearer(AABBManager.getInstance()::clearCache).registerCacheClearer(VoxelShapeManager.getInstance()::clearCache).registerCacheClearer(LocalChiselingContextCache.getInstance()::clearCache).registerCacheClearer(ChangeTrackerManger.getInstance()::clearCache);
    }

    @NotNull
    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier barrier, @NotNull ResourceManager manager, @NotNull ProfilerFiller preparationProfiler, @NotNull ProfilerFiller reloadProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
        return barrier.m_6769_((Object)Unit.INSTANCE).thenRunAsync(() -> {
            reloadProfiler.m_7242_();
            reloadProfiler.m_6180_("C&B Data reload");
            this.onResourceManagerReload();
            reloadProfiler.m_7238_();
            reloadProfiler.m_7241_();
        }, gameExecutor);
    }
}

