/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import shadows.placebo.json.PlaceboJsonReloadListener;
import shadows.placebo.network.MessageHelper;
import shadows.placebo.network.MessageProvider;

public abstract class ReloadListenerPacket<T extends ReloadListenerPacket<T>>
implements MessageProvider<T> {
    final String path;

    public ReloadListenerPacket(String path) {
        this.path = path;
    }

    public static class End
    extends ReloadListenerPacket<End> {
        public End(String path) {
            super(path);
        }

        @Override
        public void write(End msg, FriendlyByteBuf buf) {
            buf.m_130072_(msg.path, 50);
        }

        @Override
        public End read(FriendlyByteBuf buf) {
            return new End(buf.m_130136_(50));
        }

        @Override
        public void handle(End msg, Supplier<NetworkEvent.Context> ctx) {
            MessageHelper.handlePacket(() -> () -> PlaceboJsonReloadListener.endSync(msg.path), ctx);
        }
    }

    public static class Content<V extends PlaceboJsonReloadListener.TypeKeyed<V>>
    extends ReloadListenerPacket<Content<V>> {
        final ResourceLocation key;
        final V item;

        public Content(String path, ResourceLocation key, V item) {
            super(path);
            this.key = key;
            this.item = item;
        }

        @Override
        public void write(Content<V> msg, FriendlyByteBuf buf) {
            buf.m_130072_(msg.path, 50);
            buf.m_130085_(msg.key);
            PlaceboJsonReloadListener.writeItem(msg.path, msg.item, buf);
        }

        @Override
        public Content<V> read(FriendlyByteBuf buf) {
            String path = buf.m_130136_(50);
            ResourceLocation key = buf.m_130281_();
            Object item = PlaceboJsonReloadListener.readItem(path, key, buf);
            return new Content(path, key, item);
        }

        @Override
        public void handle(Content<V> msg, Supplier<NetworkEvent.Context> ctx) {
            MessageHelper.handlePacket(() -> () -> PlaceboJsonReloadListener.acceptItem(msg.path, msg.key, msg.item), ctx);
        }
    }

    public static class Start
    extends ReloadListenerPacket<Start> {
        public Start(String path) {
            super(path);
        }

        @Override
        public void write(Start msg, FriendlyByteBuf buf) {
            buf.m_130072_(msg.path, 50);
        }

        @Override
        public Start read(FriendlyByteBuf buf) {
            return new Start(buf.m_130136_(50));
        }

        @Override
        public void handle(Start msg, Supplier<NetworkEvent.Context> ctx) {
            MessageHelper.handlePacket(() -> () -> PlaceboJsonReloadListener.initSync(msg.path), ctx);
        }
    }
}

