/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterstrongholds.world;

import com.yungnickyoung.minecraft.betterstrongholds.BetterStrongholdsCommon;
import com.yungnickyoung.minecraft.betterstrongholds.world.config.BetterStrongholdFeatureConfiguration;
import com.yungnickyoung.minecraft.betterstrongholds.world.jigsaw.BetterStrongholdsJigsawManager;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;

public class BetterStrongholdStructureFeature
extends StructureFeature<BetterStrongholdFeatureConfiguration> {
    public BetterStrongholdStructureFeature() {
        super(BetterStrongholdFeatureConfiguration.CODEC, context -> {
            if (!BetterStrongholdStructureFeature.checkLocation((PieceGeneratorSupplier.Context<BetterStrongholdFeatureConfiguration>)context)) {
                return Optional.empty();
            }
            int x = context.f_197355_().m_45604_() + 7;
            int z = context.f_197355_().m_45605_() + 7;
            int minY = BetterStrongholdsCommon.CONFIG.general.strongholdStartMinY;
            int maxY = BetterStrongholdsCommon.CONFIG.general.strongholdStartMaxY;
            WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
            worldgenRandom.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
            int y = worldgenRandom.nextInt(maxY - minY) + minY;
            BlockPos blockPos = new BlockPos(x, y, z);
            return BetterStrongholdsJigsawManager.assembleJigsawStructure((PieceGeneratorSupplier.Context<BetterStrongholdFeatureConfiguration>)context, PoolElementStructurePiece::new, blockPos, false, false, 80);
        });
    }

    private static boolean checkLocation(PieceGeneratorSupplier.Context<BetterStrongholdFeatureConfiguration> context) {
        ChunkPos chunkPos = context.f_197355_();
        int ringThickness = 96;
        int distanceToFirstRing = 80;
        int chunkDistance = (int)Math.sqrt(chunkPos.f_45578_ * chunkPos.f_45578_ + chunkPos.f_45579_ * chunkPos.f_45579_);
        int shiftedChunkDistance = chunkDistance + (ringThickness - distanceToFirstRing);
        int ringSection = shiftedChunkDistance / ringThickness;
        return ringSection % 2 == 1;
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.STRONGHOLDS;
    }
}

