/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis;

import java.io.File;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.IModBusEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import shadows.apotheosis.advancements.AdvancementTriggers;
import shadows.apotheosis.compat.PatchouliCompat;
import shadows.apotheosis.deadly.DeadlyModule;
import shadows.apotheosis.deadly.loot.affix.Affix;
import shadows.apotheosis.ench.EnchModule;
import shadows.apotheosis.ench.table.ClueMessage;
import shadows.apotheosis.garden.GardenModule;
import shadows.apotheosis.potion.PotionModule;
import shadows.apotheosis.spawn.SpawnerModule;
import shadows.apotheosis.util.EnchantmentIngredient;
import shadows.apotheosis.util.ModuleCondition;
import shadows.apotheosis.util.ParticleMessage;
import shadows.apotheosis.village.VillageModule;
import shadows.placebo.config.Configuration;
import shadows.placebo.network.MessageHelper;
import shadows.placebo.network.MessageProvider;
import shadows.placebo.recipe.NBTIngredient;
import shadows.placebo.recipe.RecipeHelper;
import shadows.placebo.util.RunnableReloader;

@Mod(value="apotheosis")
public class Apotheosis {
    public static final String MODID = "apotheosis";
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("apotheosis", "apotheosis")).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> "1.0.0").simpleChannel();
    public static final RecipeHelper HELPER = new RecipeHelper("apotheosis");
    public static final CreativeModeTab APOTH_GROUP = new CreativeModeTab("apotheosis"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)Items.f_42100_);
        }
    };
    public static File configDir;
    public static Configuration config;
    public static boolean enableSpawner;
    public static boolean enableGarden;
    public static boolean enableDeadly;
    public static boolean enableEnch;
    public static boolean enablePotion;
    public static boolean enableVillage;
    public static boolean giveBook;
    public static float localAtkStrength;

    public Apotheosis() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        if (enableEnch) {
            bus.register((Object)new EnchModule());
        }
        if (enableSpawner) {
            bus.register((Object)new SpawnerModule());
        }
        if (enableGarden) {
            bus.register((Object)new GardenModule());
        }
        if (enableDeadly) {
            bus.register((Object)new DeadlyModule());
        }
        if (enablePotion) {
            bus.register((Object)new PotionModule());
        }
        if (enableVillage) {
            bus.register((Object)new VillageModule());
        }
        if (config.hasChanged()) {
            config.save();
        }
        bus.post((Event)new ApotheosisConstruction());
        bus.addListener(this::init);
        MinecraftForge.EVENT_BUS.addListener(this::trackCooldown);
        MinecraftForge.EVENT_BUS.addListener(this::reloads);
        if (ModList.get().isLoaded("patchouli")) {
            PatchouliCompat.register();
        }
        Affix.classload();
    }

    @SubscribeEvent
    public void init(FMLCommonSetupEvent e) {
        MessageHelper.registerMessage((SimpleChannel)CHANNEL, (int)0, (MessageProvider)new ParticleMessage());
        MessageHelper.registerMessage((SimpleChannel)CHANNEL, (int)2, (MessageProvider)new ClueMessage(0, null, false));
        e.enqueueWork(AdvancementTriggers::init);
        CraftingHelper.register((IConditionSerializer)new ModuleCondition.Serializer());
        CraftingHelper.register((ResourceLocation)new ResourceLocation(MODID, "enchantment"), (IIngredientSerializer)EnchantmentIngredient.Serializer.INSTANCE);
    }

    public void reloads(AddReloadListenerEvent e) {
        e.addListener((PreparableReloadListener)RunnableReloader.of(() -> MinecraftForge.EVENT_BUS.post((Event)new ApotheosisReloadEvent())));
    }

    public void trackCooldown(AttackEntityEvent e) {
        Player p = e.getPlayer();
        localAtkStrength = p.m_36403_(0.5f);
    }

    public static Ingredient potionIngredient(Potion type) {
        return new NBTIngredient(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)type));
    }

    static {
        enableSpawner = true;
        enableGarden = true;
        enableDeadly = false;
        enableEnch = true;
        enablePotion = true;
        enableVillage = true;
        giveBook = true;
        localAtkStrength = 1.0f;
        configDir = new File(FMLPaths.CONFIGDIR.get().toFile(), MODID);
        config = new Configuration(new File(configDir, "apotheosis.cfg"));
        enableEnch = config.getBoolean("Enable Enchantment Module", "general", true, "If the enchantment module is enabled.");
        enableSpawner = config.getBoolean("Enable Spawner Module", "general", true, "If the spawner module is enabled.");
        enableGarden = config.getBoolean("Enable Garden Module", "general", true, "If the garden module is loaded.");
        enablePotion = config.getBoolean("Enable Potion Module", "general", true, "If the potion module is loaded.");
        enableVillage = config.getBoolean("Enable Village Module", "general", true, "If the village module is loaded.");
        giveBook = config.getBoolean("Give Book on First Join", "general", true, "If the Chronicle of Shadows is given to new players.");
        config.setTitle("Apotheosis Module Control");
        config.setComment("This file allows individual modules of Apotheosis to be enabled or disabled.\nChanges will have no effect until the next game restart.");
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static class ApotheosisConstruction
    extends Event
    implements IModBusEvent {
    }

    public static class ApotheosisReloadEvent
    extends Event {
    }
}

