/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import shadows.apotheosis.deadly.loot.affix.AffixHelper;
import shadows.apotheosis.util.ItemAccess;

public class DeadlyModuleClient {
    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(DeadlyModuleClient::tooltips);
    }

    public static void tooltips(ItemTooltipEvent e) {
        ItemStack stack = e.getItemStack();
        List list = e.getToolTip();
        int rmvIdx = -1;
        for (int i = 0; i < list.size(); ++i) {
            TextComponent tc;
            Object e2 = list.get(i);
            if (!(e2 instanceof TextComponent) || !(tc = (TextComponent)e2).m_131292_().equals("APOTH_REMOVE_MARKER")) continue;
            list.remove(i);
            rmvIdx = i;
            break;
        }
        if (rmvIdx == -1) {
            return;
        }
        int flags = DeadlyModuleClient.getHideFlags(stack);
        if (!DeadlyModuleClient.shouldShowInTooltip(flags, ItemStack.TooltipPart.MODIFIERS) && AffixHelper.getRarity(stack) != null) {
            int stupidLambdaFinal = rmvIdx;
            int oldSize = list.size();
            DeadlyModuleClient.applyModifierTooltips(e.getPlayer(), stack, c -> list.add(stupidLambdaFinal, c));
            Collections.reverse(list.subList(rmvIdx, rmvIdx + list.size() - oldSize));
        }
    }

    private static boolean shouldShowInTooltip(int pHideFlags, ItemStack.TooltipPart pPart) {
        return (pHideFlags & pPart.m_41809_()) == 0;
    }

    private static int getHideFlags(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128425_("HideFlags", 99) ? stack.m_41783_().m_128451_("HideFlags") : 0;
    }

    private static void applyModifierTooltips(@Nullable Player player, ItemStack stack, Consumer<Component> tooltip) {
        Multimap mainhand = stack.m_41638_(EquipmentSlot.MAINHAND);
        Multimap offhand = stack.m_41638_(EquipmentSlot.OFFHAND);
        HashMultimap dualHand = HashMultimap.create();
        for (Attribute atr : mainhand.keys()) {
            Collection modifMh = mainhand.get((Object)atr);
            Collection modifOh = offhand.get((Object)atr);
            modifMh.stream().filter(a1 -> modifOh.stream().anyMatch(a2 -> a1.m_22214_().equals(a2.m_22214_()))).forEach(arg_0 -> DeadlyModuleClient.lambda$applyModifierTooltips$3((Multimap)dualHand, atr, arg_0));
        }
        DeadlyModuleClient.applyTextFor(player, stack, tooltip, (Multimap<Attribute, AttributeModifier>)dualHand, "both_hands");
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            Multimap modifiers = stack.m_41638_(slot);
            if (slot.ordinal() < 2) {
                dualHand.entries().stream().forEach(e -> modifiers.remove(e.getKey(), e.getValue()));
            }
            DeadlyModuleClient.applyTextFor(player, stack, tooltip, (Multimap<Attribute, AttributeModifier>)modifiers, slot.m_20751_());
        }
    }

    private static void applyTextFor(@Nullable Player player, ItemStack stack, Consumer<Component> tooltip, Multimap<Attribute, AttributeModifier> modifiers, String group) {
        if (!modifiers.isEmpty()) {
            tooltip.accept(TextComponent.f_131282_);
            tooltip.accept((Component)new TranslatableComponent("item.modifiers." + group).m_130940_(ChatFormatting.GRAY));
            for (Map.Entry entry : modifiers.entries()) {
                AttributeModifier modifier = (AttributeModifier)entry.getValue();
                double amt = modifier.m_22218_();
                boolean isBase = false;
                if (player != null) {
                    if (modifier.m_22209_() == ItemAccess.getBaseAD()) {
                        amt += player.m_21172_(Attributes.f_22281_);
                        amt += (double)EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)MobType.f_21640_);
                        isBase = true;
                    } else if (modifier.m_22209_() == ItemAccess.getBaseAS()) {
                        amt += player.m_21172_(Attributes.f_22283_);
                        isBase = true;
                    }
                }
                double displayAmt = modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? (((Attribute)entry.getKey()).equals(Attributes.f_22278_) ? amt * 10.0 : amt) : amt * 100.0;
                if (isBase) {
                    tooltip.accept((Component)new TextComponent(" ").m_7220_((Component)new TranslatableComponent("attribute.modifier.equals." + modifier.m_22217_().m_22235_(), new Object[]{ItemStack.f_41584_.format(displayAmt), new TranslatableComponent(((Attribute)entry.getKey()).m_22087_())})).m_130940_(ChatFormatting.DARK_GREEN));
                    continue;
                }
                if (amt > 0.0) {
                    tooltip.accept((Component)new TranslatableComponent("attribute.modifier.plus." + modifier.m_22217_().m_22235_(), new Object[]{ItemStack.f_41584_.format(displayAmt), new TranslatableComponent(((Attribute)entry.getKey()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(amt < 0.0)) continue;
                tooltip.accept((Component)new TranslatableComponent("attribute.modifier.take." + modifier.m_22217_().m_22235_(), new Object[]{ItemStack.f_41584_.format(displayAmt *= -1.0), new TranslatableComponent(((Attribute)entry.getKey()).m_22087_())}).m_130940_(ChatFormatting.RED));
            }
        }
    }

    private static /* synthetic */ void lambda$applyModifierTooltips$3(Multimap dualHand, Attribute atr, AttributeModifier modif) {
        dualHand.put((Object)atr, (Object)modif);
    }
}

