/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.loot;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.server.ServerLifecycleHooks;

public enum LootCategory {
    BOW(s -> s.m_41720_() instanceof BowItem, s -> LootCategory.arr(EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND)),
    CROSSBOW(s -> s.m_41720_() instanceof CrossbowItem, s -> LootCategory.arr(EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND)),
    BREAKER(s -> s.canPerformAction(ToolActions.PICKAXE_DIG) || s.canPerformAction(ToolActions.SHOVEL_DIG), s -> LootCategory.arr(EquipmentSlot.MAINHAND)),
    HEAVY_WEAPON(new ShieldBreakerTest(), s -> LootCategory.arr(EquipmentSlot.MAINHAND)),
    ARMOR(s -> s.m_41720_() instanceof ArmorItem, s -> LootCategory.arr(((ArmorItem)s.m_41720_()).m_40402_())),
    SHIELD(s -> s.canPerformAction(ToolActions.SHIELD_BLOCK), s -> LootCategory.arr(EquipmentSlot.OFFHAND)),
    TRIDENT(s -> s.m_41720_() instanceof TridentItem, s -> LootCategory.arr(EquipmentSlot.MAINHAND)),
    SWORD(s -> s.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_).stream().anyMatch(m -> m.m_22218_() > 0.0), s -> LootCategory.arr(EquipmentSlot.MAINHAND));

    private final Predicate<ItemStack> validator;
    private final Function<ItemStack, EquipmentSlot[]> slotGetter;
    static final LootCategory[] VALUES;

    private LootCategory(Predicate<ItemStack> validator, Function<ItemStack, EquipmentSlot[]> slotGetter) {
        this.validator = validator;
        this.slotGetter = slotGetter;
    }

    static EquipmentSlot[] arr(EquipmentSlot ... s) {
        return s;
    }

    @Nullable
    public static LootCategory forItem(ItemStack item) {
        for (LootCategory c : VALUES) {
            if (!c.isValid(item)) continue;
            return c;
        }
        return null;
    }

    public EquipmentSlot[] getSlots(ItemStack stack) {
        return this.slotGetter.apply(stack);
    }

    public boolean isValid(ItemStack stack) {
        return this.validator.test(stack);
    }

    public boolean isRanged() {
        return this == BOW || this == CROSSBOW;
    }

    public boolean isDefensive() {
        return this == ARMOR || this == SHIELD;
    }

    static {
        VALUES = LootCategory.values();
    }

    private static class ShieldBreakerTest
    implements Predicate<ItemStack> {
        private ShieldBreakerTest() {
        }

        @Override
        public boolean test(ItemStack t) {
            try {
                Zombie holder;
                ItemStack shield = new ItemStack((ItemLike)Items.f_42740_);
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                Zombie attacker = server != null ? new Zombie((Level)server.m_129880_(Level.f_46428_)) : null;
                Zombie zombie = holder = server != null ? new Zombie((Level)server.m_129880_(Level.f_46428_)) : null;
                if (holder != null) {
                    holder.m_21008_(InteractionHand.OFF_HAND, shield);
                }
                return t.canDisableShield(shield, (LivingEntity)holder, (LivingEntity)attacker);
            }
            catch (Exception ex) {
                return false;
            }
        }
    }
}

