/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.loot.affix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import shadows.apotheosis.deadly.loot.LootCategory;
import shadows.apotheosis.deadly.loot.LootRarity;
import shadows.apotheosis.deadly.loot.affix.Affix;

public class AffixHelper {
    public static final String AFFIX_DATA = "AffixData";
    public static final String AFFIXES = "Affixes";

    public static void applyAffix(ItemStack stack, Affix affix, float level) {
        LootCategory cat = LootCategory.forItem(stack);
        if (cat == null || !affix.canApply(cat)) {
            return;
        }
        CompoundTag afxData = stack.m_41698_(AFFIX_DATA);
        if (!afxData.m_128441_(AFFIXES)) {
            afxData.m_128365_(AFFIXES, (Tag)new CompoundTag());
        }
        CompoundTag affixes = afxData.m_128469_(AFFIXES);
        affixes.m_128350_(affix.getRegistryName().toString(), level);
    }

    public static void setAffixes(ItemStack stack, Map<Affix, Float> affixes) {
        CompoundTag afxData = stack.m_41737_(AFFIX_DATA);
        if (afxData != null) {
            afxData.m_128473_(AFFIXES);
        }
        affixes.forEach((a, l) -> AffixHelper.applyAffix(stack, a, l.floatValue()));
    }

    public static Map<Affix, Float> getAffixes(ItemStack stack) {
        HashMap<Affix, Float> map = new HashMap<Affix, Float>();
        CompoundTag afxData = stack.m_41737_(AFFIX_DATA);
        if (afxData != null && afxData.m_128441_(AFFIXES)) {
            CompoundTag affixes = afxData.m_128469_(AFFIXES);
            for (String key : affixes.m_128431_()) {
                Affix affix = (Affix)Affix.REGISTRY.getValue(new ResourceLocation(key));
                if (affix == null) continue;
                float lvl = affixes.m_128457_(key);
                map.put(affix, Float.valueOf(lvl));
            }
        }
        return map;
    }

    public static boolean hasAffixes(ItemStack stack) {
        CompoundTag afxData = stack.m_41737_(AFFIX_DATA);
        return afxData != null && !afxData.m_128469_(AFFIXES).m_128456_();
    }

    public static void addLore(ItemStack stack, Component lore) {
        CompoundTag display = stack.m_41698_("display");
        ListTag tag = display.m_128437_("Lore", 8);
        tag.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)lore)));
        display.m_128365_("Lore", (Tag)tag);
    }

    public static List<Affix> getAffixesFor(LootCategory type, LootRarity rarity) {
        ArrayList<Affix> affixes = new ArrayList<Affix>();
        Affix.REGISTRY.getValues().stream().filter(t -> t.canApply(type) && t.getRarity() == rarity).forEach(affixes::add);
        return affixes;
    }

    public static void setRarity(ItemStack stack, LootRarity rarity) {
        MutableComponent comp = new TranslatableComponent("%s", new Object[]{new TextComponent("")}).m_130948_(Style.f_131099_.m_131148_(rarity.getColor()));
        CompoundTag afxData = stack.m_41698_(AFFIX_DATA);
        afxData.m_128359_("Name", Component.Serializer.m_130703_((Component)comp));
        if (!stack.m_41698_("display").m_128441_("Lore")) {
            AffixHelper.addLore(stack, (Component)new TranslatableComponent("info.apotheosis.affix_item").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY).m_131155_(Boolean.valueOf(false))));
        }
        afxData.m_128359_("Rarity", rarity.name());
        stack.m_41654_(ItemStack.TooltipPart.MODIFIERS);
    }

    @Nullable
    public static LootRarity getRarity(ItemStack stack) {
        CompoundTag afxData = stack.m_41737_(AFFIX_DATA);
        if (afxData != null) {
            try {
                return LootRarity.valueOf(afxData.m_128461_("Rarity"));
            }
            catch (IllegalArgumentException e) {
                afxData.m_128473_("Rarity");
                return null;
            }
        }
        return null;
    }
}

