/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.loot.affix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import shadows.apotheosis.deadly.DeadlyModule;
import shadows.apotheosis.deadly.loot.LootCategory;
import shadows.apotheosis.deadly.loot.LootRarity;
import shadows.apotheosis.deadly.loot.affix.Affix;

public class AttributeAffix
extends Affix {
    @Nullable
    protected final Predicate<LootCategory> types;
    protected final List<ModifierInst> modifiers;

    public AttributeAffix(LootRarity rarity, @Nullable Predicate<LootCategory> types, ModifierInst ... modifiers) {
        super(rarity);
        this.types = types;
        this.modifiers = Arrays.asList(modifiers);
    }

    @Override
    public void addInformation(ItemStack stack, float level, Consumer<Component> list) {
    }

    @Override
    public Component getDisplayName(float level) {
        return new TranslatableComponent("affix." + this.getRegistryName() + ".name", new Object[]{AttributeAffix.fmt(level * 100.0f)}).m_130940_(ChatFormatting.GRAY);
    }

    @Override
    public void addModifiers(ItemStack stack, float level, EquipmentSlot type, BiConsumer<Attribute, AttributeModifier> map) {
        LootCategory cat = LootCategory.forItem(stack);
        if (cat == null) {
            DeadlyModule.LOGGER.debug("Attempted to apply the attributes of affix {} on item {}, but it is not an affix-compatible item!", (Object)this.getRegistryName(), (Object)stack.m_41786_());
            return;
        }
        for (EquipmentSlot slot : cat.getSlots(stack)) {
            if (slot != type) continue;
            this.modifiers.forEach(ins -> map.accept(ins.attr.get(), ins.build(slot, this.getRegistryName(), level)));
        }
    }

    @Override
    public boolean canApply(LootCategory type) {
        return this.types == null ? true : this.types.test(type);
    }

    public record ModifierInst(Supplier<Attribute> attr, AttributeModifier.Operation op, Function<Float, Float> valueFactory, Map<EquipmentSlot, UUID> cache) {
        public AttributeModifier build(EquipmentSlot slot, ResourceLocation id, float level) {
            return new AttributeModifier(this.cache.computeIfAbsent(slot, k -> UUID.randomUUID()), "affix:" + id, (double)this.valueFactory.apply(Float.valueOf(level)).floatValue(), this.op);
        }
    }

    public static class Builder {
        private final LootRarity rarity;
        private final List<ModifierInst> modifiers = new ArrayList<ModifierInst>();
        private Predicate<LootCategory> types;

        public Builder(LootRarity rarity) {
            this.rarity = rarity;
        }

        public Builder types(Predicate<LootCategory> types) {
            this.types = types;
            return this;
        }

        public Builder with(Supplier<Attribute> attr, AttributeModifier.Operation op, Function<Float, Float> valueFactory) {
            this.modifiers.add(new ModifierInst(attr, op, valueFactory, new HashMap<EquipmentSlot, UUID>()));
            return this;
        }

        public Builder with(Attribute attr, AttributeModifier.Operation op, Function<Float, Float> valueFactory) {
            return this.with(() -> attr, op, valueFactory);
        }

        public Builder with(Supplier<Attribute> attr, AttributeModifier.Operation op, float min, float max) {
            return this.with(attr, op, (Float level) -> Float.valueOf(min + level.floatValue() * max));
        }

        public Builder with(Attribute attr, AttributeModifier.Operation op, float min, float max) {
            return this.with(attr, op, (Float level) -> Float.valueOf(min + level.floatValue() * max));
        }

        public AttributeAffix build(String id) {
            return (AttributeAffix)new AttributeAffix(this.rarity, this.types, this.modifiers.toArray(new ModifierInst[0])).setRegistryName(id);
        }
    }
}

