/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.compat;

import it.unimi.dsi.fastutil.floats.Float2FloatMap;
import it.unimi.dsi.fastutil.floats.Float2FloatOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import shadows.apotheosis.ench.table.EnchantingStatManager;

public class CommonTooltipUtil {
    public static void appendBlockStats(Level world, BlockState state, Consumer<Component> tooltip) {
        float maxEterna = EnchantingStatManager.getMaxEterna(state, world, BlockPos.f_121853_);
        float eterna = EnchantingStatManager.getEterna(state, world, BlockPos.f_121853_);
        float quanta = EnchantingStatManager.getQuanta(state, world, BlockPos.f_121853_);
        float arcana = EnchantingStatManager.getArcana(state, world, BlockPos.f_121853_);
        float rectification = EnchantingStatManager.getQuantaRectification(state, world, BlockPos.f_121853_);
        int clues = EnchantingStatManager.getBonusClues(state, world, BlockPos.f_121853_);
        if (eterna != 0.0f || quanta != 0.0f || arcana != 0.0f || rectification != 0.0f || clues != 0) {
            tooltip.accept((Component)new TranslatableComponent("info.apotheosis.ench_stats").m_130940_(ChatFormatting.GOLD));
        }
        if (eterna != 0.0f) {
            if (eterna > 0.0f) {
                tooltip.accept((Component)new TranslatableComponent("info.apotheosis.eterna.p", new Object[]{String.format("%.2f", Float.valueOf(eterna)), String.format("%.2f", Float.valueOf(maxEterna))}).m_130940_(ChatFormatting.GREEN));
            } else {
                tooltip.accept((Component)new TranslatableComponent("info.apotheosis.eterna", new Object[]{String.format("%.2f", Float.valueOf(eterna))}).m_130940_(ChatFormatting.GREEN));
            }
        }
        if (quanta != 0.0f) {
            tooltip.accept((Component)new TranslatableComponent("info.apotheosis.quanta" + (quanta > 0.0f ? ".p" : ""), new Object[]{String.format("%.2f", Float.valueOf(quanta))}).m_130940_(ChatFormatting.RED));
        }
        if (arcana != 0.0f) {
            tooltip.accept((Component)new TranslatableComponent("info.apotheosis.arcana" + (arcana > 0.0f ? ".p" : ""), new Object[]{String.format("%.2f", Float.valueOf(arcana))}).m_130940_(ChatFormatting.DARK_PURPLE));
        }
        if (rectification != 0.0f) {
            tooltip.accept((Component)new TranslatableComponent("info.apotheosis.rectification" + (rectification > 0.0f ? ".p" : ""), new Object[]{String.format("%.2f", Float.valueOf(rectification))}).m_130940_(ChatFormatting.YELLOW));
        }
        if (clues != 0) {
            tooltip.accept((Component)new TranslatableComponent("info.apotheosis.clues" + (clues > 0 ? ".p" : ""), new Object[]{String.format("%d", clues)}).m_130940_(ChatFormatting.DARK_AQUA));
        }
    }

    public static void appendTableStats(Level world, BlockPos pos, Consumer<Component> tooltip) {
        Float2FloatOpenHashMap eternaMap = new Float2FloatOpenHashMap();
        float[] stats = new float[]{0.0f, 15.0f, 0.0f, 0.0f, 0.0f};
        for (int j = -1; j <= 1; ++j) {
            for (int k = -1; k <= 1; ++k) {
                if (j == 0 && k == 0 || !world.m_46859_(pos.m_142082_(k, 0, j)) || !world.m_46859_(pos.m_142082_(k, 1, j))) continue;
                CommonTooltipUtil.gatherStats((Float2FloatMap)eternaMap, stats, world, pos.m_142082_(k * 2, 0, j * 2));
                CommonTooltipUtil.gatherStats((Float2FloatMap)eternaMap, stats, world, pos.m_142082_(k * 2, 1, j * 2));
                if (k == 0 || j == 0) continue;
                CommonTooltipUtil.gatherStats((Float2FloatMap)eternaMap, stats, world, pos.m_142082_(k * 2, 0, j));
                CommonTooltipUtil.gatherStats((Float2FloatMap)eternaMap, stats, world, pos.m_142082_(k * 2, 1, j));
                CommonTooltipUtil.gatherStats((Float2FloatMap)eternaMap, stats, world, pos.m_142082_(k, 0, j * 2));
                CommonTooltipUtil.gatherStats((Float2FloatMap)eternaMap, stats, world, pos.m_142082_(k, 1, j * 2));
            }
        }
        ArrayList entries = new ArrayList(eternaMap.float2FloatEntrySet());
        Collections.sort(entries, Comparator.comparing(Float2FloatMap.Entry::getFloatKey));
        for (Float2FloatMap.Entry e : entries) {
            if (e.getFloatKey() > 0.0f) {
                stats[0] = Math.min(e.getFloatKey(), stats[0] + e.getFloatValue());
                continue;
            }
            stats[0] = stats[0] + e.getFloatValue();
        }
        tooltip.accept((Component)new TranslatableComponent("info.apotheosis.eterna.t", new Object[]{String.format("%.2f", Float.valueOf(stats[0])), String.format("%.2f", Float.valueOf(EnchantingStatManager.getAbsoluteMaxEterna()))}).m_130940_(ChatFormatting.GREEN));
        tooltip.accept((Component)new TranslatableComponent("info.apotheosis.quanta.t", new Object[]{String.format("%.2f", Float.valueOf(Math.min(100.0f, stats[1])))}).m_130940_(ChatFormatting.RED));
        tooltip.accept((Component)new TranslatableComponent("info.apotheosis.arcana.t", new Object[]{String.format("%.2f", Float.valueOf(Math.min(100.0f, stats[2])))}).m_130940_(ChatFormatting.DARK_PURPLE));
        tooltip.accept((Component)new TranslatableComponent("info.apotheosis.rectification.t", new Object[]{String.format("%.2f", Float.valueOf(Mth.m_14036_((float)stats[3], (float)-100.0f, (float)100.0f)))}).m_130940_(ChatFormatting.YELLOW));
        tooltip.accept((Component)new TranslatableComponent("info.apotheosis.clues.t", new Object[]{String.format("%d", (int)stats[4] + 1)}).m_130940_(ChatFormatting.DARK_AQUA));
    }

    public static void gatherStats(Float2FloatMap eternaMap, float[] stats, Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60795_()) {
            return;
        }
        float max = EnchantingStatManager.getMaxEterna(state, world, pos);
        float eterna = EnchantingStatManager.getEterna(state, world, pos);
        eternaMap.put(max, eternaMap.getOrDefault(max, 0.0f) + eterna);
        float quanta = EnchantingStatManager.getQuanta(state, world, pos);
        stats[1] = stats[1] + quanta;
        float arcana = EnchantingStatManager.getArcana(state, world, pos);
        stats[2] = stats[2] + arcana;
        float quantaRec = EnchantingStatManager.getQuantaRectification(state, world, pos);
        stats[3] = stats[3] + quantaRec;
        int clues = EnchantingStatManager.getBonusClues(state, world, pos);
        stats[4] = stats[4] + (float)clues;
    }
}

