/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientReloadShadersEvent;
import dev.architectury.event.events.client.ClientScreenInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.hooks.client.screen.ScreenAccess;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.platform.Platform;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.ftb.mods.ftbchunks.ColorMapLoader;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBChunksCommon;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.client.EntityIcons;
import dev.ftb.mods.ftbchunks.client.EntityMapIcon;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import dev.ftb.mods.ftbchunks.client.FTBChunksRenderTypes;
import dev.ftb.mods.ftbchunks.client.LargeMapScreen;
import dev.ftb.mods.ftbchunks.client.MapIconComparator;
import dev.ftb.mods.ftbchunks.client.MapType;
import dev.ftb.mods.ftbchunks.client.MinimapBlurMode;
import dev.ftb.mods.ftbchunks.client.MinimapPosition;
import dev.ftb.mods.ftbchunks.client.WaypointMapIcon;
import dev.ftb.mods.ftbchunks.client.forge.FTBChunksClientImpl;
import dev.ftb.mods.ftbchunks.client.map.ChunkUpdateTask;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.MapRegion;
import dev.ftb.mods.ftbchunks.client.map.MapRegionData;
import dev.ftb.mods.ftbchunks.client.map.MapTask;
import dev.ftb.mods.ftbchunks.client.map.RegionSyncKey;
import dev.ftb.mods.ftbchunks.client.map.UpdateChunkFromServerTask;
import dev.ftb.mods.ftbchunks.client.map.Waypoint;
import dev.ftb.mods.ftbchunks.client.map.WaypointType;
import dev.ftb.mods.ftbchunks.client.map.color.ColorUtils;
import dev.ftb.mods.ftbchunks.data.PlayerLocation;
import dev.ftb.mods.ftbchunks.integration.InWorldMapIcon;
import dev.ftb.mods.ftbchunks.integration.MapIcon;
import dev.ftb.mods.ftbchunks.integration.MapIconEvent;
import dev.ftb.mods.ftbchunks.integration.RefreshMinimapIconsEvent;
import dev.ftb.mods.ftbchunks.net.LoginDataPacket;
import dev.ftb.mods.ftbchunks.net.PartialPackets;
import dev.ftb.mods.ftbchunks.net.PlayerDeathPacket;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftbchunks.net.SendManyChunksPacket;
import dev.ftb.mods.ftbchunks.net.SendVisiblePlayerListPacket;
import dev.ftb.mods.ftblibrary.icon.FaceIcon;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.ui.CustomClickEvent;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.event.ClientTeamPropertiesChangedEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FTBChunksClient
extends FTBChunksCommon {
    private static final ResourceLocation BUTTON_ID = new ResourceLocation("ftbchunks:open_gui");
    public static final ResourceLocation CIRCLE_MASK = new ResourceLocation("ftbchunks:textures/circle_mask.png");
    public static final ResourceLocation CIRCLE_BORDER = new ResourceLocation("ftbchunks:textures/circle_border.png");
    public static final ResourceLocation PLAYER = new ResourceLocation("ftbchunks:textures/player.png");
    public static final ResourceLocation[] COMPASS = new ResourceLocation[]{new ResourceLocation("ftbchunks:textures/compass_e.png"), new ResourceLocation("ftbchunks:textures/compass_n.png"), new ResourceLocation("ftbchunks:textures/compass_w.png"), new ResourceLocation("ftbchunks:textures/compass_s.png")};
    private static final List<Component> MINIMAP_TEXT_LIST = new ArrayList<Component>(3);
    private static final ArrayDeque<MapTask> taskQueue = new ArrayDeque();
    public static long taskQueueTicks = 0L;
    public static Map<ChunkPos, IntOpenHashSet> rerenderCache = new HashMap<ChunkPos, IntOpenHashSet>();
    public static KeyMapping openMapKey;
    public static KeyMapping zoomInKey;
    public static KeyMapping zoomOutKey;
    public static int minimapTextureId;
    private int currentPlayerChunkX;
    private int currentPlayerChunkZ;
    private double currentPlayerX;
    private double currentPlayerY;
    private double currentPlayerZ;
    private double prevPlayerX;
    private double prevPlayerY;
    private double prevPlayerZ;
    private static int renderedDebugCount;
    public static boolean updateMinimap;
    public static boolean alwaysRenderChunksOnMap;
    public static SendGeneralDataPacket generalData;
    private long nextRegionSave = 0L;
    private double prevZoom = (Double)FTBChunksClientConfig.MINIMAP_ZOOM.get();
    private long lastZoomTime = 0L;
    private final List<MapIcon> mapIcons = new ArrayList<MapIcon>();
    private final List<InWorldMapIcon> inWorldMapIcons = new ArrayList<InWorldMapIcon>();
    private long lastMapIconUpdate = 0L;
    private final List<WaypointMapIcon> visibleWaypoints = new ArrayList<WaypointMapIcon>();
    private static Matrix4f worldMatrix;
    private static Vec3 cameraPos;

    public static void queue(MapTask task) {
        taskQueue.addLast(task);
    }

    @Override
    public void init() {
        if (Minecraft.m_91087_() == null) {
            return;
        }
        FTBChunksClientConfig.init();
        FTBChunksClient.registerKeys();
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)new EntityIcons());
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)new ColorMapLoader());
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(this::loggedOut);
        CustomClickEvent.EVENT.register(this::customClick);
        ClientRawInputEvent.KEY_PRESSED.register(this::keyPressed);
        ClientScreenInputEvent.KEY_PRESSED_PRE.register(this::keyPressed);
        ClientGuiEvent.RENDER_HUD.register(this::renderHud);
        ClientGuiEvent.INIT_PRE.register(this::screenOpened);
        ClientTickEvent.CLIENT_PRE.register(this::clientTick);
        TeamEvent.CLIENT_PROPERTIES_CHANGED.register(this::teamPropertiesChanged);
        MapIconEvent.LARGE_MAP.register(this::mapIcons);
        MapIconEvent.MINIMAP.register(this::mapIcons);
        RefreshMinimapIconsEvent.EVENT.register(this::refreshMinimapIcons);
        ClientReloadShadersEvent.EVENT.register(this::reloadShaders);
        FTBChunksClient.registerPlatform();
    }

    private static void registerKeys() {
        openMapKey = new KeyMapping("key.ftbchunks.map", InputConstants.Type.KEYSYM, 77, "key.categories.ui");
        KeyMappingRegistry.register((KeyMapping)openMapKey);
        zoomInKey = new KeyMapping("key.ftbchunks.minimap.zoomIn", InputConstants.Type.KEYSYM, 61, "key.categories.ui");
        KeyMappingRegistry.register((KeyMapping)zoomInKey);
        zoomOutKey = new KeyMapping("key.ftbchunks.minimap.zoomOut", InputConstants.Type.KEYSYM, 45, "key.categories.ui");
        KeyMappingRegistry.register((KeyMapping)zoomOutKey);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerPlatform() {
        FTBChunksClientImpl.registerPlatform();
    }

    public static void openGui() {
        new LargeMapScreen().openGui();
    }

    public static void saveAllRegions() {
        if (MapManager.inst == null) {
            return;
        }
        for (MapDimension dimension : MapManager.inst.getDimensions().values()) {
            for (MapRegion region : dimension.getLoadedRegions()) {
                if (!region.saveData) continue;
                FTBChunksClient.queue(region);
                region.saveData = false;
            }
            if (!dimension.saveData) continue;
            FTBChunksClient.queue(dimension);
            dimension.saveData = false;
        }
        if (MapManager.inst.saveData) {
            FTBChunksClient.queue(MapManager.inst);
            MapManager.inst.saveData = false;
        }
    }

    @Override
    public void login(LoginDataPacket loginData) {
        FTBChunks.LOGGER.info("Loading FTB Chunks client data from world " + loginData.serverId);
        FTBChunksWorldConfig.CONFIG.read(loginData.config);
        Path dir = Platform.getGameFolder().resolve("local/ftbchunks/data/" + loginData.serverId);
        if (Files.notExists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        MapManager.inst = new MapManager(loginData.serverId, dir);
        updateMinimap = true;
        renderedDebugCount = 0;
        ChunkUpdateTask.debugLastTime = 0L;
    }

    public void loggedOut(@Nullable LocalPlayer player) {
        MapManager manager = MapManager.inst;
        if (manager != null) {
            MapTask task;
            FTBChunksClient.saveAllRegions();
            while ((task = taskQueue.pollFirst()) != null) {
                try {
                    task.runMapTask();
                }
                catch (Exception ex) {
                    FTBChunks.LOGGER.error("Failed to run task " + task);
                    ex.printStackTrace();
                }
            }
            MapDimension.updateCurrent();
            manager.release();
        }
        MapManager.inst = null;
    }

    @Override
    public void updateGeneralData(SendGeneralDataPacket packet) {
        generalData = packet;
    }

    @Override
    public void updateChunk(SendChunkPacket packet) {
        if (MapManager.inst == null) {
            return;
        }
        MapDimension dimension = MapManager.inst.getDimension(packet.dimension);
        Date now = new Date();
        FTBChunksClient.queue(new UpdateChunkFromServerTask(dimension, packet.chunk, packet.teamId, now));
    }

    @Override
    public void updateAllChunks(SendManyChunksPacket packet) {
        if (MapManager.inst == null) {
            return;
        }
        MapDimension dimension = MapManager.inst.getDimension(packet.dimension);
        Date now = new Date();
        for (SendChunkPacket.SingleChunk c : packet.chunks) {
            FTBChunksClient.queue(new UpdateChunkFromServerTask(dimension, c, packet.teamId, now));
        }
    }

    @Override
    public void updateVisiblePlayerList(SendVisiblePlayerListPacket packet) {
        PlayerLocation.CLIENT_LIST.clear();
        PlayerLocation.currentDimension = packet.dim;
        PlayerLocation.CLIENT_LIST.addAll(packet.players);
    }

    @Override
    public void syncRegion(RegionSyncKey key, int offset, int total, byte[] data) {
        PartialPackets.REGION.read(key, offset, total, data);
    }

    @Override
    public void playerDeath(PlayerDeathPacket packet) {
        if (((Boolean)FTBChunksClientConfig.DEATH_WAYPOINTS.get()).booleanValue()) {
            MapDimension dimension = MapManager.inst.getDimension(packet.dimension);
            for (Waypoint w : dimension.getWaypoints()) {
                if (w.type != WaypointType.DEATH) continue;
                w.hidden = true;
                w.update();
            }
            Waypoint w = new Waypoint(dimension);
            w.name = "Death #" + packet.number;
            w.x = packet.x;
            w.y = packet.y;
            w.z = packet.z;
            w.type = WaypointType.DEATH;
            w.color = 0xFF0000;
            dimension.getWaypoints().add(w);
            w.update();
            dimension.saveData = true;
            RefreshMinimapIconsEvent.trigger();
        }
    }

    @Override
    public int blockColor() {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_18707_(() -> {
            mc.m_91152_(null);
            new Thread(() -> {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                mc.m_18707_(() -> {
                    if (mc.f_91077_ instanceof BlockHitResult) {
                        ResourceLocation id = Registry.f_122824_.m_7981_((Object)mc.f_91073_.m_8055_(((BlockHitResult)mc.f_91077_).m_82425_()).m_60734_());
                        Window window = mc.m_91268_();
                        NativeImage image = Screenshot.m_92279_((RenderTarget)mc.m_91385_());
                        int col = image.m_84985_(image.m_84982_() / 2 - (int)(2.0 * window.m_85449_()), image.m_85084_() / 2 - (int)(2.0 * window.m_85449_()));
                        String s = String.format("\"%s\": \"#%06X\"", id.m_135815_(), ColorUtils.convertFromNative(col) & 0xFFFFFF);
                        mc.f_91074_.m_6352_((Component)new TextComponent(id.m_135827_() + " - " + s).m_130948_(Style.f_131099_.m_131157_(ChatFormatting.GOLD).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, s)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Click to copy")))), Util.f_137441_);
                    }
                });
            }, "Color getter").start();
        });
        return 1;
    }

    @Override
    public void updateLoadedChunkView(ResourceKey<Level> dimension, Long2IntMap chunks) {
        MapDimension dim = MapManager.inst.getDimension(dimension);
        dim.loadedChunkView = chunks;
        MapManager.inst.updateAllRegions(false);
    }

    @Override
    public boolean skipBlock(BlockState state) {
        ResourceLocation id = FTBChunks.BLOCK_REGISTRY.getId((Object)state.m_60734_());
        return id == null || ColorMapLoader.getBlockColor(id).isIgnored();
    }

    public EventResult customClick(CustomClickEvent event) {
        if (event.id().equals((Object)BUTTON_ID)) {
            FTBChunksClient.openGui();
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    /*
     * Enabled aggressive block sorting
     */
    public EventResult keyPressed(Minecraft client, int keyCode, int scanCode, int action, int modifiers) {
        if (openMapKey.m_90857_()) {
            if (Screen.m_96637_()) {
                SNBTCompoundTag tag = new SNBTCompoundTag();
                tag.m_128379_(FTBChunksClientConfig.MINIMAP_ENABLED.key, (Boolean)FTBChunksClientConfig.MINIMAP_ENABLED.get() == false);
                FTBChunksClientConfig.MINIMAP_ENABLED.read(tag);
                FTBChunksClientConfig.saveConfig();
                return EventResult.pass();
            }
            if (((Boolean)FTBChunksClientConfig.DEBUG_INFO.get()).booleanValue() && Screen.m_96639_()) {
                FTBChunks.LOGGER.info("=== Task Queue: " + taskQueue.size());
                Iterator<MapTask> iterator = taskQueue.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        FTBChunks.LOGGER.info("===");
                        return EventResult.pass();
                    }
                    MapTask task = iterator.next();
                    FTBChunks.LOGGER.info(task.toString());
                }
            }
            FTBChunksClient.openGui();
            return EventResult.interruptTrue();
        }
        if (zoomInKey.m_90857_()) {
            return this.changeZoom(true);
        }
        if (!zoomOutKey.m_90857_()) return EventResult.pass();
        return this.changeZoom(false);
    }

    public EventResult keyPressed(Minecraft client, Screen screen, int keyCode, int scanCode, int modifiers) {
        LargeMapScreen gui;
        if (openMapKey.m_90857_() && (gui = (LargeMapScreen)((Object)ClientUtils.getCurrentGuiAs(LargeMapScreen.class))) != null) {
            gui.closeGui(false);
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    private EventResult changeZoom(boolean zoomIn) {
        double zoomFactor;
        double zoom = this.prevZoom = ((Double)FTBChunksClientConfig.MINIMAP_ZOOM.get()).doubleValue();
        double d = zoomFactor = zoomIn ? 1.0 : -1.0;
        zoom = zoom + zoomFactor > 4.0 ? 4.0 : (zoom + zoomFactor < 1.0 ? 1.0 : (zoom += zoomFactor));
        this.lastZoomTime = System.currentTimeMillis();
        FTBChunksClientConfig.MINIMAP_ZOOM.set(Double.valueOf(zoom));
        return EventResult.interruptTrue();
    }

    public float getZoom() {
        double z = (Double)FTBChunksClientConfig.MINIMAP_ZOOM.get();
        if (this.prevZoom != z) {
            long max = (long)(400.0 / z);
            long t = Mth.m_14053_((long)(System.currentTimeMillis() - this.lastZoomTime), (long)0L, (long)max);
            if (t == max) {
                this.lastZoomTime = 0L;
                return (float)z;
            }
            return (float)Mth.m_14139_((double)((double)t / (double)max), (double)this.prevZoom, (double)z);
        }
        return (float)z;
    }

    public static int generateTextureId(int w, int h) {
        int textureId = GlStateManager.m_84111_();
        RenderSystem.m_157184_((int)textureId);
        GlStateManager.m_84331_((int)3553, (int)33085, (int)0);
        GlStateManager.m_84331_((int)3553, (int)33082, (int)0);
        GlStateManager.m_84331_((int)3553, (int)33083, (int)0);
        GlStateManager.m_84160_((int)3553, (int)34049, (float)0.0f);
        GlStateManager.m_84209_((int)3553, (int)0, (int)NativeImage.InternalGlFormat.RGBA.m_85191_(), (int)w, (int)h, (int)0, (int)6408, (int)5121, null);
        return textureId;
    }

    public void renderHud(PoseStack matrixStack, float tickDelta) {
        ClientTeam team;
        MapRegionData data;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null || MapManager.inst == null) {
            return;
        }
        double playerX = Mth.m_14139_((double)tickDelta, (double)this.prevPlayerX, (double)this.currentPlayerX);
        double playerY = Mth.m_14139_((double)tickDelta, (double)this.prevPlayerY, (double)this.currentPlayerY);
        double playerZ = Mth.m_14139_((double)tickDelta, (double)this.prevPlayerZ, (double)this.currentPlayerZ);
        double guiScale = mc.m_91268_().m_85449_();
        int ww = mc.m_91268_().m_85445_();
        int wh = mc.m_91268_().m_85446_();
        MapDimension dim = MapDimension.getCurrent();
        if (dim.dimension != mc.f_91073_.m_46472_()) {
            MapDimension.updateCurrent();
            dim = MapDimension.getCurrent();
        }
        long now = System.currentTimeMillis();
        if (this.nextRegionSave == 0L || now >= this.nextRegionSave) {
            this.nextRegionSave = now + 60000L;
            FTBChunksClient.saveAllRegions();
        }
        if (minimapTextureId == -1) {
            minimapTextureId = FTBChunksClient.generateTextureId(240, 240);
            updateMinimap = true;
        }
        float zoom0 = this.getZoom();
        float zoom = zoom0 / 3.5f;
        MinimapBlurMode blurMode = (MinimapBlurMode)((Object)FTBChunksClientConfig.MINIMAP_BLUR_MODE.get());
        boolean minimapBlur = blurMode == MinimapBlurMode.AUTO ? zoom0 < 1.5f : blurMode == MinimapBlurMode.ON;
        int filter = minimapBlur ? 9729 : 9728;
        RenderSystem.m_69493_();
        RenderSystem.m_157184_((int)minimapTextureId);
        RenderSystem.m_69937_((int)3553, (int)10241, (int)filter);
        RenderSystem.m_69937_((int)3553, (int)10240, (int)filter);
        int cx = Mth.m_14107_((double)playerX) >> 4;
        int cz = Mth.m_14107_((double)playerZ) >> 4;
        if (cx != this.currentPlayerChunkX || cz != this.currentPlayerChunkZ) {
            updateMinimap = true;
        }
        if (updateMinimap) {
            updateMinimap = false;
            for (int mz = 0; mz < 15; ++mz) {
                for (int mx = 0; mx < 15; ++mx) {
                    int ox = cx + mx - 7;
                    int oz = cz + mz - 7;
                    MapRegion region = dim.getRegion(XZ.regionFromChunk((int)ox, (int)oz));
                    region.getRenderedMapImage().m_85013_(0, mx * 16, mz * 16, (ox & 0x1F) * 16, (oz & 0x1F) * 16, 16, 16, minimapBlur, false, false, false);
                }
            }
            this.currentPlayerChunkX = cx;
            this.currentPlayerChunkZ = cz;
        }
        if (mc.f_91066_.f_92063_ || !((Boolean)FTBChunksClientConfig.MINIMAP_ENABLED.get()).booleanValue() || (Integer)FTBChunksClientConfig.MINIMAP_VISIBILITY.get() == 0 || ((Boolean)FTBChunksWorldConfig.FORCE_DISABLE_MINIMAP.get()).booleanValue()) {
            return;
        }
        float scale = (float)((Double)FTBChunksClientConfig.MINIMAP_SCALE.get() * 4.0 / guiScale);
        float minimapRotation = ((Boolean)FTBChunksClientConfig.MINIMAP_LOCKED_NORTH.get() != false ? 180.0f : -mc.f_91074_.m_146908_()) % 360.0f;
        int s = (int)(64.0 * (double)scale);
        double s2d = (double)s / 2.0;
        float s2f = (float)s / 2.0f;
        int x = ((MinimapPosition)((Object)FTBChunksClientConfig.MINIMAP_POSITION.get())).getX(ww, s);
        int y = ((MinimapPosition)((Object)FTBChunksClientConfig.MINIMAP_POSITION.get())).getY(wh, s);
        int z = 0;
        float border = 0.0f;
        int alpha = (Integer)FTBChunksClientConfig.MINIMAP_VISIBILITY.get();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69481_();
        RenderSystem.m_69493_();
        RenderSystem.m_69482_();
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)x + s2d, (double)y + s2d, (double)(490 + z));
        Matrix4f m = matrixStack.m_85850_().m_85861_();
        RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)CIRCLE_MASK);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        buffer.m_85982_(m, -s2f + border, -s2f + border, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_85982_(m, -s2f + border, s2f - border, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_85982_(m, s2f - border, s2f - border, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_85982_(m, s2f - border, -s2f + border, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(minimapRotation + 180.0f));
        RenderSystem.m_69456_((int)518);
        float s2fb = s2f - border;
        float offX = 0.5f + (float)((MathUtils.mod((double)playerX, (double)16.0) / 16.0 - 0.5) / 15.0);
        float offZ = 0.5f + (float)((MathUtils.mod((double)playerZ, (double)16.0) / 16.0 - 0.5) / 15.0);
        float zws = 2.0f / (15.0f * zoom);
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157453_((int)0, (int)minimapTextureId);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        buffer.m_85982_(m, -s2fb, -s2fb, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(offX - zws, offZ - zws).m_5752_();
        buffer.m_85982_(m, -s2fb, s2fb, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(offX - zws, offZ + zws).m_5752_();
        buffer.m_85982_(m, s2fb, s2fb, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(offX + zws, offZ + zws).m_5752_();
        buffer.m_85982_(m, s2fb, -s2fb, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(offX + zws, offZ - zws).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69465_();
        RenderSystem.m_69456_((int)515);
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)CIRCLE_BORDER);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        buffer.m_85982_(m, -s2f, -s2f, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_85982_(m, -s2f, s2f, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_85982_(m, s2f, s2f, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_85982_(m, s2f, -s2f, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(1.0f, 0.0f).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_69472_();
        buffer.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        buffer.m_85982_(m, -s2f, 0.0f, 0.0f).m_6122_(0, 0, 0, 30).m_5752_();
        buffer.m_85982_(m, s2f, 0.0f, 0.0f).m_6122_(0, 0, 0, 30).m_5752_();
        buffer.m_85982_(m, 0.0f, -s2f, 0.0f).m_6122_(0, 0, 0, 30).m_5752_();
        buffer.m_85982_(m, 0.0f, s2f, 0.0f).m_6122_(0, 0, 0, 30).m_5752_();
        tessellator.m_85914_();
        matrixStack.m_85849_();
        m = matrixStack.m_85850_().m_85861_();
        RenderSystem.m_69493_();
        if (((Boolean)FTBChunksClientConfig.MINIMAP_COMPASS.get()).booleanValue()) {
            for (int face = 0; face < 4; ++face) {
                double d = (double)s / 2.2;
                double angle = ((double)minimapRotation + 180.0 - (double)face * 90.0) * Math.PI / 180.0;
                float wx = (float)((double)x + s2d + Math.cos(angle) * d);
                float wy = (float)((double)y + s2d + Math.sin(angle) * d);
                float ws = (float)s / 32.0f;
                RenderSystem.m_157427_(GameRenderer::m_172814_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)COMPASS[face]);
                buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
                buffer.m_85982_(m, wx - ws, wy - ws, (float)z).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_5752_();
                buffer.m_85982_(m, wx - ws, wy + ws, (float)z).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_5752_();
                buffer.m_85982_(m, wx + ws, wy + ws, (float)z).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_5752_();
                buffer.m_85982_(m, wx + ws, wy - ws, (float)z).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_5752_();
                tessellator.m_85914_();
            }
        }
        if (this.lastMapIconUpdate == 0L || now - this.lastMapIconUpdate >= (long)((Integer)FTBChunksClientConfig.MINIMAP_ICON_UPDATE_TIMER.get()).intValue()) {
            this.lastMapIconUpdate = now;
            this.mapIcons.clear();
            ((Consumer)MapIconEvent.MINIMAP.invoker()).accept(new MapIconEvent(mc, dim, this.mapIcons, MapType.MINIMAP));
            if (this.mapIcons.size() >= 2) {
                this.mapIcons.sort(new MapIconComparator(mc.f_91074_.m_20182_(), tickDelta));
            }
        }
        for (MapIcon icon : this.mapIcons) {
            double distance;
            Vec3 pos = icon.getPos(tickDelta);
            double d = (distance = MathUtils.dist((double)playerX, (double)playerZ, (double)pos.f_82479_, (double)pos.f_82481_)) * (double)scale * (double)zoom;
            if (!icon.isVisible(MapType.MINIMAP, distance, d > s2d)) continue;
            if (d > s2d) {
                d = s2d;
            }
            double angle = Math.atan2(playerZ - pos.f_82481_, playerX - pos.f_82479_) + (double)minimapRotation * Math.PI / 180.0;
            double ws = (double)s / (32.0 / icon.getIconScale(MapType.MINIMAP));
            double wx = (double)x + s2d + Math.cos(angle) * d;
            double wy = (double)y + s2d + Math.sin(angle) * d;
            float wsf = (float)(ws * 2.0);
            matrixStack.m_85836_();
            matrixStack.m_85837_(wx - ws, wy - ws - (icon.isIconOnEdge(MapType.MINIMAP, d >= s2d) ? ws / 2.0 : 0.0), (double)z);
            matrixStack.m_85841_(wsf, wsf, 1.0f);
            icon.draw(MapType.MINIMAP, matrixStack, 0, 0, 1, 1, d >= s2d);
            matrixStack.m_85849_();
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_LOCKED_NORTH.get()).booleanValue()) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)PLAYER);
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)x + s2d, (double)y + s2d, (double)z);
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(mc.f_91074_.m_146908_() + 180.0f));
            matrixStack.m_85841_((float)s / 16.0f, (float)s / 16.0f, 1.0f);
            m = matrixStack.m_85850_().m_85861_();
            RenderSystem.m_157427_(GameRenderer::m_172814_);
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
            buffer.m_85982_(m, -1.0f, -1.0f, 0.0f).m_6122_(255, 255, 255, 200).m_7421_(0.0f, 0.0f).m_5752_();
            buffer.m_85982_(m, -1.0f, 1.0f, 0.0f).m_6122_(255, 255, 255, 200).m_7421_(0.0f, 1.0f).m_5752_();
            buffer.m_85982_(m, 1.0f, 1.0f, 0.0f).m_6122_(255, 255, 255, 200).m_7421_(1.0f, 1.0f).m_5752_();
            buffer.m_85982_(m, 1.0f, -1.0f, 0.0f).m_6122_(255, 255, 255, 200).m_7421_(1.0f, 0.0f).m_5752_();
            tessellator.m_85914_();
            matrixStack.m_85849_();
        }
        MINIMAP_TEXT_LIST.clear();
        if (((Boolean)FTBChunksClientConfig.MINIMAP_ZONE.get()).booleanValue() && (data = dim.getRegion(XZ.regionFromChunk((int)this.currentPlayerChunkX, (int)this.currentPlayerChunkZ)).getData()) != null && (team = data.getChunk(XZ.of((int)this.currentPlayerChunkX, (int)this.currentPlayerChunkZ)).getTeam()) != null) {
            MINIMAP_TEXT_LIST.add(team.getColoredName());
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_XYZ.get()).booleanValue()) {
            MINIMAP_TEXT_LIST.add((Component)new TextComponent(Mth.m_14107_((double)playerX) + " " + Mth.m_14107_((double)playerY) + " " + Mth.m_14107_((double)playerZ)));
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_BIOME.get()).booleanValue()) {
            Holder biome = mc.f_91073_.m_204166_(mc.f_91074_.m_142538_());
            biome.m_203543_().ifPresent(e -> MINIMAP_TEXT_LIST.add((Component)new TranslatableComponent("biome." + e.m_135782_().m_135827_() + "." + e.m_135782_().m_135815_())));
        }
        if (((Boolean)FTBChunksClientConfig.DEBUG_INFO.get()).booleanValue()) {
            XZ r = XZ.regionFromChunk((int)this.currentPlayerChunkX, (int)this.currentPlayerChunkZ);
            MINIMAP_TEXT_LIST.add((Component)new TextComponent("Queued tasks: " + taskQueue.size()));
            MINIMAP_TEXT_LIST.add((Component)new TextComponent(r.toRegionString()));
            MINIMAP_TEXT_LIST.add((Component)new TextComponent("Total updates: " + renderedDebugCount));
            if (ChunkUpdateTask.debugLastTime > 0L) {
                MINIMAP_TEXT_LIST.add((Component)new TextComponent(String.format("LU: %,d ns", ChunkUpdateTask.debugLastTime)));
            }
        }
        if (!MINIMAP_TEXT_LIST.isEmpty()) {
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)x + s2d, (double)(y + s) + 3.0, 0.0);
            matrixStack.m_85841_((float)(0.5 * (double)scale), (float)(0.5 * (double)scale), 1.0f);
            for (int i = 0; i < MINIMAP_TEXT_LIST.size(); ++i) {
                FormattedCharSequence bs = MINIMAP_TEXT_LIST.get(i).m_7532_();
                int bsw = mc.f_91062_.m_92724_(bs);
                mc.f_91062_.m_92744_(matrixStack, bs, (float)(-bsw) / 2.0f, (float)(i * 11), -1);
            }
            matrixStack.m_85849_();
        }
        RenderSystem.m_69482_();
        if (worldMatrix != null) {
            GuiHelper.setupDrawing();
            float ww2 = (float)ww / 2.0f;
            float wh2 = (float)wh / 2.0f;
            InWorldMapIcon iconOver = null;
            for (MapIcon mapIcon : this.mapIcons) {
                Vec3 pos = mapIcon.getPos(tickDelta);
                double playerDist = MathUtils.dist((double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_, (double)playerX, (double)playerY, (double)playerZ);
                if (!mapIcon.isVisible(MapType.WORLD_ICON, playerDist, false)) continue;
                Vector4f v = new Vector4f((float)(pos.f_82479_ - FTBChunksClient.cameraPos.f_82479_), (float)(pos.f_82480_ - FTBChunksClient.cameraPos.f_82480_), (float)(pos.f_82481_ - FTBChunksClient.cameraPos.f_82481_), 1.0f);
                v.m_123607_(worldMatrix);
                v.m_123621_();
                if (!(v.m_123616_() > 0.0f) || !(v.m_123616_() < 1.0f)) continue;
                float ix = ww2 + v.m_123601_() * ww2;
                float iy = wh2 - v.m_123615_() * wh2;
                double mouseDist = MathUtils.dist((double)ix, (double)iy, (double)ww2, (double)wh2);
                InWorldMapIcon inWorldMapIcon = new InWorldMapIcon(mapIcon, ix, iy, playerDist, mouseDist);
                if (mouseDist <= 5.0 && (iconOver == null || iconOver.distanceToMouse() > mouseDist)) {
                    iconOver = inWorldMapIcon;
                }
                this.inWorldMapIcons.add(inWorldMapIcon);
            }
            for (InWorldMapIcon inWorldMapIcon : this.inWorldMapIcons) {
                float iconScale = inWorldMapIcon == iconOver ? 0.5f : 0.25f;
                matrixStack.m_85836_();
                matrixStack.m_85837_((double)inWorldMapIcon.x(), (double)inWorldMapIcon.y(), inWorldMapIcon == iconOver ? 50.0 : -100.0);
                matrixStack.m_85841_(iconScale, iconScale, 1.0f);
                inWorldMapIcon.icon().draw(MapType.WORLD_ICON, matrixStack, -8, -8, 16, 16, inWorldMapIcon != iconOver);
                matrixStack.m_85849_();
            }
            this.inWorldMapIcons.clear();
        }
    }

    public void renderWorldLast(PoseStack poseStack, Matrix4f projectionMatrix, Camera camera, float tickDelta) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_ || MapManager.inst == null || mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        worldMatrix = projectionMatrix.m_27658_();
        worldMatrix.m_27644_(poseStack.m_85850_().m_85861_());
        cameraPos = camera.m_90583_();
        if (!((Boolean)FTBChunksClientConfig.IN_WORLD_WAYPOINTS.get()).booleanValue()) {
            return;
        }
        MapDimension dim = MapDimension.getCurrent();
        if (dim.getWaypoints().isEmpty()) {
            return;
        }
        double playerX = mc.f_91074_.m_20185_();
        double playerZ = mc.f_91074_.m_20189_();
        for (Waypoint waypoint : dim.getWaypoints()) {
            if (waypoint.hidden) continue;
            double faceOutDistance = (Double)FTBChunksClientConfig.WAYPOINT_FADE_DISTANCE.get();
            double faceOutDistanceP = faceOutDistance * 2.0 / 3.0;
            double distance = MathUtils.dist((double)playerX, (double)playerZ, (double)((double)waypoint.x + 0.5), (double)((double)waypoint.z + 0.5));
            if (distance <= faceOutDistanceP || distance > waypoint.inWorldDistance) continue;
            int alpha = 150;
            if (distance < faceOutDistance) {
                alpha = (int)((double)alpha * ((distance - faceOutDistanceP) / (faceOutDistance - faceOutDistanceP)));
            }
            if (alpha <= 0) continue;
            waypoint.mapIcon.distance = distance;
            waypoint.mapIcon.alpha = alpha;
            this.visibleWaypoints.add(waypoint.mapIcon);
        }
        if (this.visibleWaypoints.isEmpty()) {
            return;
        }
        if (this.visibleWaypoints.size() >= 2) {
            this.visibleWaypoints.sort(new MapIconComparator(mc.f_91074_.m_20182_(), tickDelta));
        }
        Vec3 cameraPos = camera.m_90583_();
        poseStack.m_85836_();
        poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        VertexConsumer depthBuffer = mc.m_91269_().m_110104_().m_6299_(FTBChunksRenderTypes.WAYPOINTS_DEPTH);
        float h = (float)(cameraPos.f_82480_ + 30.0);
        float h2 = h + 70.0f;
        for (WaypointMapIcon waypoint : this.visibleWaypoints) {
            double angle = Math.atan2(cameraPos.f_82481_ - waypoint.pos.f_82481_, cameraPos.f_82479_ - waypoint.pos.f_82479_) * 180.0 / Math.PI;
            int r = waypoint.waypoint.color >> 16 & 0xFF;
            int g = waypoint.waypoint.color >> 8 & 0xFF;
            int b = waypoint.waypoint.color >> 0 & 0xFF;
            poseStack.m_85836_();
            poseStack.m_85837_(waypoint.pos.f_82479_, 0.0, waypoint.pos.f_82481_);
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_((float)(-angle - 135.0)));
            float s = 0.6f;
            Matrix4f m = poseStack.m_85850_().m_85861_();
            depthBuffer.m_85982_(m, -s, 0.0f, s).m_6122_(r, g, b, waypoint.alpha).m_7421_(0.0f, 1.0f).m_5752_();
            depthBuffer.m_85982_(m, -s, h, s).m_6122_(r, g, b, waypoint.alpha).m_7421_(0.0f, 0.0f).m_5752_();
            depthBuffer.m_85982_(m, s, h, -s).m_6122_(r, g, b, waypoint.alpha).m_7421_(1.0f, 0.0f).m_5752_();
            depthBuffer.m_85982_(m, s, 0.0f, -s).m_6122_(r, g, b, waypoint.alpha).m_7421_(1.0f, 1.0f).m_5752_();
            depthBuffer.m_85982_(m, -s, h, s).m_6122_(r, g, b, waypoint.alpha).m_7421_(0.0f, 1.0f).m_5752_();
            depthBuffer.m_85982_(m, -s, h2, s).m_6122_(r, g, b, 0).m_7421_(0.0f, 0.0f).m_5752_();
            depthBuffer.m_85982_(m, s, h2, -s).m_6122_(r, g, b, 0).m_7421_(1.0f, 0.0f).m_5752_();
            depthBuffer.m_85982_(m, s, h, -s).m_6122_(r, g, b, waypoint.alpha).m_7421_(1.0f, 1.0f).m_5752_();
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
        mc.m_91269_().m_110104_().m_109912_(FTBChunksRenderTypes.WAYPOINTS_DEPTH);
        this.visibleWaypoints.clear();
    }

    private EventResult screenOpened(Screen screen, ScreenAccess access) {
        if (screen instanceof PauseScreen) {
            this.nextRegionSave = System.currentTimeMillis() + 60000L;
            FTBChunksClient.saveAllRegions();
        }
        return EventResult.pass();
    }

    private void clientTick(Minecraft mc) {
        MapManager manager = MapManager.inst;
        if (manager != null && mc.f_91073_ != null) {
            int s;
            if (mc.f_91074_ != null) {
                this.prevPlayerX = this.currentPlayerX;
                this.prevPlayerY = this.currentPlayerY;
                this.prevPlayerZ = this.currentPlayerZ;
                this.currentPlayerX = mc.f_91074_.m_20185_();
                this.currentPlayerY = mc.f_91074_.m_20186_();
                this.currentPlayerZ = mc.f_91074_.m_20189_();
            }
            if (taskQueueTicks % (long)((Integer)FTBChunksClientConfig.RERENDER_QUEUE_TICKS.get()).intValue() == 0L && !rerenderCache.isEmpty()) {
                ClientLevel level = mc.f_91073_;
                long biomeZoomSeed = level.m_7062_().f_47863_;
                for (Map.Entry<ChunkPos, IntOpenHashSet> pos : rerenderCache.entrySet()) {
                    ChunkAccess chunkAccess = level.m_6522_(pos.getKey().f_45578_, pos.getKey().f_45579_, ChunkStatus.f_62326_, false);
                    if (chunkAccess == null) continue;
                    FTBChunksClient.queueOrExecute(new ChunkUpdateTask(manager, (Level)level, chunkAccess, pos.getKey(), biomeZoomSeed, pos.getValue().toIntArray()));
                }
                rerenderCache = new HashMap<ChunkPos, IntOpenHashSet>();
            }
            if (taskQueueTicks % (long)((Integer)FTBChunksClientConfig.TASK_QUEUE_TICKS.get()).intValue() == 0L && (s = Math.min(taskQueue.size(), (Integer)FTBChunksClientConfig.TASK_QUEUE_MAX.get())) > 0) {
                MapTask[] tasks = new MapTask[s];
                for (int i = 0; i < s; ++i) {
                    tasks[i] = taskQueue.pollFirst();
                    if (tasks[i] == null || tasks[i].cancelOtherTasks()) break;
                }
                for (MapTask task : tasks) {
                    if (task == null) continue;
                    try {
                        task.runMapTask();
                    }
                    catch (Exception ex) {
                        FTBChunks.LOGGER.error("Failed to run task " + task);
                        ex.printStackTrace();
                    }
                }
            }
            ++taskQueueTicks;
        }
    }

    private void teamPropertiesChanged(ClientTeamPropertiesChangedEvent event) {
        if (MapManager.inst != null) {
            MapManager.inst.updateAllRegions(false);
        }
    }

    private void mapIcons(MapIconEvent event) {
        Minecraft mc = event.mc;
        if (((Boolean)FTBChunksClientConfig.MINIMAP_WAYPOINTS.get()).booleanValue()) {
            for (Waypoint w : event.mapDimension.getWaypoints()) {
                if (w.hidden && event.mapType.isMinimap()) continue;
                event.add(w.mapIcon);
            }
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_ENTITIES.get()).booleanValue()) {
            for (Entity entity : mc.f_91073_.m_104735_()) {
                Icon icon;
                if (entity instanceof AbstractClientPlayer || entity.m_6095_().m_20674_() == MobCategory.MISC || entity.m_20177_((Player)mc.f_91074_) || (icon = EntityIcons.get(entity)) == Icon.EMPTY) continue;
                if (((Boolean)FTBChunksClientConfig.ONLY_SURFACE_ENTITIES.get()).booleanValue() && !mc.f_91073_.m_6042_().m_63946_()) {
                    int z;
                    int x = Mth.m_14107_((double)entity.m_20185_());
                    MapRegion region = event.mapDimension.getRegion(XZ.regionFromBlock((int)x, (int)(z = Mth.m_14107_((double)entity.m_20189_()))));
                    MapRegionData data = region.getData();
                    if (data == null) continue;
                    short y = data.height[(x & 0x1FF) + (z & 0x1FF) * 512];
                    if (!(entity.m_20186_() >= (double)(y - 10))) continue;
                    event.add(new EntityMapIcon(entity, icon));
                    continue;
                }
                event.add(new EntityMapIcon(entity, icon));
            }
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_PLAYER_HEADS.get()).booleanValue() && mc.f_91073_.m_6907_().size() > 1) {
            for (AbstractClientPlayer player : mc.f_91073_.m_6907_()) {
                if (player == mc.f_91074_ || player.m_20177_((Player)mc.f_91074_)) continue;
                event.add(new EntityMapIcon((Entity)player, (Icon)FaceIcon.getFace((GameProfile)player.m_36316_())));
            }
        }
        if (!event.mapType.isMinimap()) {
            event.add(new EntityMapIcon((Entity)mc.f_91074_, (Icon)FaceIcon.getFace((GameProfile)mc.f_91074_.m_36316_())));
        }
    }

    public void refreshMinimapIcons() {
        this.lastMapIconUpdate = 0L;
    }

    private void reloadShaders(ResourceManager resourceManager, ClientReloadShadersEvent.ShadersSink sink) {
    }

    public static void rerender(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        IntOpenHashSet set = rerenderCache.get(chunkPos);
        if (set == null) {
            set = new IntOpenHashSet();
            rerenderCache.put(chunkPos, set);
        }
        if (set.add((pos.m_123341_() & 0xF) + (pos.m_123343_() & 0xF) * 16) && ((Boolean)FTBChunksClientConfig.DEBUG_INFO.get()).booleanValue()) {
            ++renderedDebugCount;
        }
    }

    public static void handlePacket(ClientboundSectionBlocksUpdatePacket p) {
        short[] positions;
        SectionPos sectionPos = p.f_132980_;
        for (short position : positions = p.f_132981_) {
            FTBChunksClient.rerender(sectionPos.m_123245_(position));
        }
    }

    public static void handlePacket(ClientboundLevelChunkWithLightPacket p) {
        ChunkAccess chunkAccess;
        MapManager manager = MapManager.inst;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && (chunkAccess = level.m_6522_(p.m_195717_(), p.m_195718_(), ChunkStatus.f_62326_, false)) != null) {
            long biomeZoomSeed = level.m_7062_().f_47863_;
            FTBChunksClient.queueOrExecute(new ChunkUpdateTask(manager, (Level)level, chunkAccess, new ChunkPos(p.m_195717_(), p.m_195718_()), biomeZoomSeed, ChunkUpdateTask.ALL_BLOCKS));
        }
    }

    public static void queueOrExecute(MapTask task) {
        FTBChunks.EXECUTOR.execute(task);
    }

    public static void handlePacket(ClientboundBlockUpdatePacket p) {
        FTBChunksClient.rerender(p.m_131749_());
    }

    static {
        minimapTextureId = -1;
        renderedDebugCount = 0;
        updateMinimap = false;
        alwaysRenderChunksOnMap = false;
    }
}

