/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import java.util.List;
import java.util.Random;
import mob_grinding_utils.MobGrindingUtils;
import mob_grinding_utils.network.MGUClientPackets;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;

public class BlockDelightfulDirt
extends Block {
    public BlockDelightfulDirt(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean shouldSnowCap(Level level, BlockPos pos) {
        return level.m_46861_(pos) && level.m_46468_() >= 13000L && level.m_46468_() <= 23000L;
    }

    public boolean shouldSpawnMob(Level level, BlockPos pos) {
        return level.m_46803_(pos.m_7494_()) >= 10 && level.m_8055_(pos.m_7494_()).m_60767_() == Material.f_76296_;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (this.shouldSnowCap(level, pos) || this.shouldSpawnMob(level, pos)) {
            level.m_186460_(pos, (Block)this, Mth.m_14072_((Random)this.RANDOM, (int)20, (int)60));
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (this.shouldSnowCap((Level)level, pos) || this.shouldSpawnMob((Level)level, pos)) {
            level.m_186460_(pos, (Block)this, Mth.m_14072_((Random)this.RANDOM, (int)20, (int)60));
        }
        return super.m_7417_(stateIn, facing, facingState, level, pos, facingPos);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (this.shouldSnowCap(level, pos) || this.shouldSpawnMob(level, pos)) {
            level.m_186460_(pos, (Block)this, Mth.m_14072_((Random)this.RANDOM, (int)20, (int)60));
        }
    }

    @Deprecated
    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random rand) {
        if (this.shouldSnowCap((Level)level, pos)) {
            BlockPos posUp = pos.m_7494_();
            BlockState blockstate = Blocks.f_50125_.m_49966_();
            if (level.m_8055_(posUp).m_60767_() == Material.f_76296_ && blockstate.m_60710_((LevelReader)level, posUp)) {
                level.m_7731_(posUp, blockstate, 11);
            }
        }
        if (!this.shouldSnowCap((Level)level, pos) && this.shouldSpawnMob((Level)level, pos)) {
            BlockPos posUp;
            AABB areaToCheck = new AABB(pos).m_82377_(5.0, 2.0, 5.0);
            int entityCount = level.m_6443_(Mob.class, areaToCheck, entity -> entity != null && entity.m_6095_().m_20674_() == MobCategory.CREATURE).size();
            if (entityCount < 8) {
                this.spawnMob(level, pos);
            }
            if (level.m_46467_() % 20L == 0L && level.m_8055_(posUp = pos.m_7494_()).m_60767_() == Material.f_76296_) {
                PlacedFeature placedfeature;
                if (rand.nextInt(8) == 0) {
                    List list = ((Biome)level.m_204166_(posUp).m_203334_()).m_47536_().m_47815_();
                    if (list.isEmpty()) {
                        return;
                    }
                    placedfeature = (PlacedFeature)((RandomPatchConfiguration)((ConfiguredFeature)list.get(0)).f_65378_()).f_191304_().m_203334_();
                } else {
                    placedfeature = (PlacedFeature)VegetationPlacements.f_195459_.m_203334_();
                }
                placedfeature.m_191782_((WorldGenLevel)level, level.m_7726_().m_8481_(), rand, posUp);
            }
        }
    }

    public void spawnMob(ServerLevel level, BlockPos pos) {
        List spawns = ((Biome)level.m_204166_(pos).m_203334_()).m_47518_().m_151798_(MobCategory.CREATURE).m_146338_();
        if (!spawns.isEmpty()) {
            int indexSize = spawns.size();
            EntityType type = ((MobSpawnSettings.SpawnerData)spawns.get((int)this.RANDOM.nextInt((int)indexSize))).f_48404_;
            if (type.m_204039_(MobGrindingUtils.NOSPAWN)) {
                return;
            }
            if (type == null || !NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.m_21752_((EntityType)type), (LevelReader)level, (BlockPos)pos.m_7494_(), (EntityType)type)) {
                return;
            }
            Mob entity = (Mob)type.m_20615_((Level)level);
            if (entity != null) {
                entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5);
                if (level.m_142425_((EntityTypeTest)entity.m_6095_(), entity.m_142469_(), EntitySelector.f_20402_).isEmpty() && level.m_45786_((Entity)entity)) {
                    entity.m_6518_((ServerLevelAccessor)level, level.m_6436_(pos), MobSpawnType.NATURAL, null, null);
                    level.m_7967_((Entity)entity);
                }
            }
        }
    }

    public boolean canSustainPlant(BlockState state, BlockGetter level, BlockPos pos, Direction facing, IPlantable plantable) {
        return true;
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return true;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return 200;
    }

    public boolean isFireSource(BlockState state, LevelReader level, BlockPos pos, Direction side) {
        return side == Direction.UP;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState stateIn, Level level, BlockPos pos, Random rand) {
        if (level.m_46467_() % 3L == 0L && level.m_8055_(pos.m_7494_()).m_60767_() == Material.f_76296_) {
            for (int i = 0; i < 4; ++i) {
                double d0 = pos.m_123341_();
                double d1 = (double)pos.m_123342_() + 1.0;
                double d2 = pos.m_123343_();
                double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
                double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
                double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
                MGUClientPackets.spawnGlitterParticles(d0 + d3, d1 + d4, d2 + d5, 0.0, 0.0, 0.0);
            }
        }
    }
}

