/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import java.lang.reflect.Method;
import mob_grinding_utils.MobGrindingUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.living.LivingDropsEvent;

public class BlockSpikes
extends DirectionalBlock {
    public static final VoxelShape SPIKES_AABB = Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    public static final Method xpPoints = BlockSpikes.getExperiencePoints();

    public BlockSpikes(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SPIKES_AABB;
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return Shapes.m_83144_();
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        return (BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)direction);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52588_});
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (!world.f_46443_ && entity instanceof LivingEntity) {
            entity.m_6469_(MobGrindingUtils.SPIKE_DAMAGE, 5.0f);
        }
    }

    public static void dropXP(LivingDropsEvent event) {
        LivingEntity entity = event.getEntityLiving();
        Level world = entity.m_20193_();
        if (entity != null && !world.f_46443_ && !event.isRecentlyHit() && event.getSource() == MobGrindingUtils.SPIKE_DAMAGE) {
            int xp = 0;
            try {
                xp = (Integer)xpPoints.invoke((Object)entity, FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)world)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (xp > 0) {
                int cap = ExperienceOrb.m_20782_((int)xp);
                xp -= cap;
                entity.m_20193_().m_7967_((Entity)new ExperienceOrb(entity.m_20193_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), cap));
            }
        }
    }

    public static Method getExperiencePoints() {
        Method method = null;
        try {
            method = LivingEntity.class.getDeclaredMethod("getExperienceReward", Player.class);
            method.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            method = LivingEntity.class.getDeclaredMethod("m_6552_", Player.class);
            method.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }
}

