/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.ModSounds;
import mob_grinding_utils.blocks.BlockTank;
import mob_grinding_utils.tile.TileEntityXPTap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class BlockXPTap
extends DirectionalBlock
implements EntityBlock {
    public static final VoxelShape XP_TAP_WEST_AABB = Block.m_49796_((double)7.0, (double)6.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    public static final VoxelShape XP_TAP_EAST_AABB = Block.m_49796_((double)0.0, (double)6.0, (double)4.0, (double)9.0, (double)16.0, (double)12.0);
    public static final VoxelShape XP_TAP_SOUTH_AABB = Block.m_49796_((double)4.0, (double)6.0, (double)0.0, (double)12.0, (double)16.0, (double)9.0);
    public static final VoxelShape XP_TAP_NORTH_AABB = Block.m_49796_((double)4.0, (double)6.0, (double)7.0, (double)12.0, (double)16.0, (double)16.0);
    public static final BooleanProperty POWERED = BooleanProperty.m_61465_((String)"powered");

    public BlockXPTap(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)f_52588_)) {
            default: {
                return XP_TAP_EAST_AABB;
            }
            case WEST: {
                return XP_TAP_WEST_AABB;
            }
            case SOUTH: {
                return XP_TAP_SOUTH_AABB;
            }
            case NORTH: 
        }
        return XP_TAP_NORTH_AABB;
    }

    public VoxelShape m_6079_(BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos) {
        switch ((Direction)state.m_61143_((Property)f_52588_)) {
            default: {
                return XP_TAP_EAST_AABB;
            }
            case WEST: {
                return XP_TAP_WEST_AABB;
            }
            case SOUTH: {
                return XP_TAP_SOUTH_AABB;
            }
            case NORTH: 
        }
        return XP_TAP_NORTH_AABB;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)direction)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.f_46443_) {
            boolean swap = (Boolean)state.m_61143_((Property)POWERED);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(!swap)), 3);
            float f = (Boolean)state.m_61143_((Property)POWERED) != false ? 0.6f : 0.5f;
            world.m_5594_(null, pos, ModSounds.TAP_SQUEAK, SoundSource.BLOCKS, 0.3f, f);
            TileEntityXPTap tileentity = (TileEntityXPTap)world.m_7702_(pos);
            tileentity.setActive(!swap);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        for (Direction enumfacing : Direction.values()) {
            if (!this.canPlaceAt(world, pos.m_142300_(enumfacing.m_122424_()), enumfacing)) continue;
            return true;
        }
        return false;
    }

    private boolean canPlaceAt(LevelReader world, BlockPos pos, Direction facing) {
        BlockState blockstate = world.m_8055_(pos);
        boolean isSide = facing.m_122434_().m_122479_();
        BlockEntity te = world.m_7702_(pos);
        if (te != null && te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).isPresent() && isSide) {
            return true;
        }
        return isSide && blockstate.m_60734_() instanceof BlockTank;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        Direction facing = (Direction)world.m_8055_(pos).m_61143_((Property)f_52588_);
        if (!this.canPlaceAt((LevelReader)world, pos.m_142300_(facing.m_122424_()), facing)) {
            BlockXPTap.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModBlocks.XP_TAP.getItem(), 1));
            world.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
        super.m_6861_(state, world, pos, block, fromPos, isMoving);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52588_, POWERED});
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new TileEntityXPTap(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.f_46443_ ? null : TileEntityXPTap::serverTick;
    }
}

