/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.block_set;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import net.mehvahdjukaar.selene.block_set.BlockTypeRegistry;
import net.mehvahdjukaar.selene.block_set.IBlockType;
import net.mehvahdjukaar.selene.block_set.wood.WoodType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockSetManager {
    private static boolean hasFilledBlockSets = false;
    private static final Map<Class<? extends IBlockType>, BlockTypeRegistry<?>> BLOCK_SET_CONTAINERS = new ConcurrentHashMap();
    private static final ConcurrentLinkedDeque<Runnable> FINDER_ADDER = new ConcurrentLinkedDeque();
    private static final ConcurrentLinkedDeque<Runnable> REMOVER_ADDER = new ConcurrentLinkedDeque();
    private static final Map<String, Pair<List<Runnable>, List<Consumer<RegistryEvent.Register<Item>>>>> LATE_REGISTRATION_QUEUE = new ConcurrentHashMap<String, Pair<List<Runnable>, List<Consumer<RegistryEvent.Register<Item>>>>>();

    public static <T extends IBlockType> void registerBlockSetDefinition(Class<T> type, BlockTypeRegistry<T> typeRegistry) {
        if (hasFilledBlockSets) {
            throw new UnsupportedOperationException(String.format("Tried to register block set definition %s for block type %s after registry events", typeRegistry, type));
        }
        BLOCK_SET_CONTAINERS.put(type, typeRegistry);
    }

    public static <T extends IBlockType> void addBlockTypeFinder(Class<T> type, IBlockType.SetFinder<T> blockFinder) {
        if (hasFilledBlockSets) {
            throw new UnsupportedOperationException(String.format("Tried to register block %s finder %s after registry events", type, blockFinder));
        }
        FINDER_ADDER.add(() -> {
            BlockTypeRegistry container = BlockSetManager.getBlockSet(type);
            container.addFinder(blockFinder);
        });
    }

    public static <T extends IBlockType> void addBlockTypeRemover(Class<T> type, ResourceLocation id) {
        if (hasFilledBlockSets) {
            throw new UnsupportedOperationException(String.format("Tried to remove block type %s for type %s after registry events", id, type));
        }
        REMOVER_ADDER.add(() -> {
            BlockTypeRegistry container = BlockSetManager.getBlockSet(type);
            container.addRemover(id);
        });
    }

    public static <T extends IBlockType> BlockTypeRegistry<T> getBlockSet(Class<T> type) {
        return BLOCK_SET_CONTAINERS.get(type);
    }

    @Deprecated
    public static <R extends IForgeRegistryEntry<R>> void addWoodRegistrationCallback(BlockSetRegistryCallback<WoodType, R> registrationFunction, Class<R> regType) {
        BlockSetManager.addBlockSetRegistrationCallback(registrationFunction, regType, WoodType.class);
    }

    public static <T extends IBlockType, R extends IForgeRegistryEntry<R>> void addBlockSetRegistrationCallback(BlockSetRegistryCallback<T, R> registrationFunction, Class<R> regType, Class<T> blockType) {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        if (regType == Block.class || regType == Item.class) {
            String modId = ModLoadingContext.get().getActiveContainer().getModId();
            Pair registrationQueues = LATE_REGISTRATION_QUEUE.computeIfAbsent(modId, s -> {
                bus.addGenericListener(Item.class, EventPriority.HIGHEST, BlockSetManager::registerLateBlockAndItems);
                return Pair.of(new ArrayList(), new ArrayList());
            });
            if (regType == Block.class) {
                Consumer<RegistryEvent.Register> eventConsumer = e -> {
                    Runnable lateRegistration = () -> {
                        IForgeRegistry registry = e.getRegistry();
                        if (registry instanceof ForgeRegistry) {
                            ForgeRegistry fr = (ForgeRegistry)registry;
                            boolean frozen = fr.isLocked();
                            fr.unfreeze();
                            registrationFunction.accept((RegistryEvent.Register)e, BlockSetManager.getBlockSet(blockType).getTypes().values());
                            if (frozen) {
                                fr.freeze();
                            }
                        }
                    };
                    ((List)registrationQueues.getFirst()).add(lateRegistration);
                };
                bus.addGenericListener(regType, EventPriority.HIGHEST, eventConsumer);
            } else {
                Consumer<RegistryEvent.Register> itemEvent = e -> registrationFunction.accept((RegistryEvent.Register)e, BlockSetManager.getBlockSet(blockType).getTypes().values());
                ((List)registrationQueues.getSecond()).add(itemEvent);
            }
        } else {
            Consumer<RegistryEvent.Register> eventConsumer = e -> registrationFunction.accept((RegistryEvent.Register)e, BlockSetManager.getBlockSet(blockType).getTypes().values());
            bus.addGenericListener(regType, eventConsumer);
        }
    }

    protected static void registerLateBlockAndItems(RegistryEvent.Register<Item> event) {
        String modId;
        Pair<List<Runnable>, List<Consumer<RegistryEvent.Register<Item>>>> registrationQueues;
        if (!hasFilledBlockSets) {
            BlockSetManager.initializeBlockSets();
            hasFilledBlockSets = true;
        }
        if ((registrationQueues = LATE_REGISTRATION_QUEUE.get(modId = ModLoadingContext.get().getActiveContainer().getModId())) != null) {
            List blockQueue = (List)registrationQueues.getFirst();
            blockQueue.forEach(Runnable::run);
            List itemQueue = (List)registrationQueues.getSecond();
            itemQueue.forEach(q -> q.accept(event));
        }
        LATE_REGISTRATION_QUEUE.remove(modId);
    }

    private static void initializeBlockSets() {
        FINDER_ADDER.forEach(Runnable::run);
        FINDER_ADDER.clear();
        BLOCK_SET_CONTAINERS.get(WoodType.class).buildAll();
        for (Map.Entry<Class<IBlockType>, BlockTypeRegistry<?>> c : BLOCK_SET_CONTAINERS.entrySet()) {
            c.getValue().buildAll();
        }
    }

    @FunctionalInterface
    public static interface BlockSetRegistryCallback<T extends IBlockType, R extends IForgeRegistryEntry<R>> {
        public void accept(RegistryEvent.Register<R> var1, Collection<T> var2);
    }
}

