/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.block_set;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.selene.block_set.IBlockType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class BlockTypeRegistry<T extends IBlockType> {
    protected boolean frozen = false;
    private final List<IBlockType.SetFinder<T>> finders = new ArrayList<IBlockType.SetFinder<T>>();
    private final List<ResourceLocation> notInclude = new ArrayList<ResourceLocation>();
    private final List<T> builder = new ArrayList<T>();

    public T getFromNBT(String name) {
        return (T)((IBlockType)this.getTypes().getOrDefault(new ResourceLocation(name), this.getDefaultType()));
    }

    public abstract T getDefaultType();

    public abstract Map<ResourceLocation, T> getTypes();

    public abstract Optional<T> detectTypeFromBlock(Block var1);

    protected abstract void saveTypes(ImmutableMap<ResourceLocation, T> var1);

    public void registerBlockType(T newType) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Tried to register wood types after registry events");
        }
        this.builder.add(newType);
    }

    public Collection<IBlockType.SetFinder<T>> getFinders() {
        return this.finders;
    }

    public void addFinder(IBlockType.SetFinder<T> finder) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Tried to register block type finder after registry events");
        }
        this.finders.add(finder);
    }

    public void addRemover(ResourceLocation id) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Tried remove a block type after registry events");
        }
        this.notInclude.add(id);
    }

    private void finalizeAndFreeze() {
        if (this.frozen) {
            throw new UnsupportedOperationException("Block types are already finalized");
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        this.builder.forEach(e -> {
            if (!linkedHashMap.containsKey(e.getId())) {
                linkedHashMap.put(e.getId(), e);
            }
        });
        this.saveTypes(ImmutableMap.copyOf(linkedHashMap));
        this.builder.clear();
        this.frozen = true;
    }

    public void buildAll() {
        if (!this.frozen) {
            this.registerBlockType(this.getDefaultType());
            Collection<IBlockType.SetFinder<T>> finders = this.getFinders();
            finders.stream().map(IBlockType.SetFinder::get).forEach(f -> f.ifPresent(this::registerBlockType));
            for (Block b : ForgeRegistries.BLOCKS) {
                this.detectTypeFromBlock(b).ifPresent(t -> {
                    if (!this.notInclude.contains(t.getId())) {
                        this.registerBlockType(t);
                    }
                });
            }
            this.finalizeAndFreeze();
        }
    }
}

