/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.block_set.leaves;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.selene.block_set.BlockTypeRegistry;
import net.mehvahdjukaar.selene.block_set.leaves.LeavesType;
import net.mehvahdjukaar.selene.block_set.wood.WoodType;
import net.mehvahdjukaar.selene.block_set.wood.WoodTypeRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import org.jetbrains.annotations.NotNull;

public class LeavesTypeRegistry
extends BlockTypeRegistry<LeavesType> {
    public static LeavesTypeRegistry INSTANCE;
    public static Map<ResourceLocation, LeavesType> LEAVES_TYPES;

    public LeavesTypeRegistry() {
        INSTANCE = this;
    }

    public static LeavesType fromNBT(String name) {
        return LEAVES_TYPES.getOrDefault(new ResourceLocation(name), LeavesType.OAK_LEAVES_TYPE);
    }

    @Override
    public LeavesType getDefaultType() {
        return LeavesType.OAK_LEAVES_TYPE;
    }

    @Override
    public Map<ResourceLocation, LeavesType> getTypes() {
        if (!this.frozen) {
            throw new UnsupportedOperationException("Tried to access wood types too early");
        }
        return LEAVES_TYPES;
    }

    @Override
    protected void saveTypes(ImmutableMap<ResourceLocation, LeavesType> types) {
        LEAVES_TYPES = types;
    }

    @Override
    public Optional<LeavesType> detectTypeFromBlock(@NotNull Block baseBlock) {
        BlockState state;
        Material mat;
        ResourceLocation baseRes = baseBlock.getRegistryName();
        String name = null;
        String path = baseRes.m_135815_();
        if (path.endsWith("_leaves")) {
            name = path.substring(0, path.length() - "_leaves".length());
        } else if (path.startsWith("leaves_")) {
            name = path.substring("leaves_".length());
        }
        if (name != null && !baseRes.m_135827_().equals("securitycraft") && baseBlock instanceof LeavesBlock && (mat = (state = baseBlock.m_49966_()).m_60767_()) == Material.f_76274_) {
            ResourceLocation id = new ResourceLocation(baseRes.m_135827_(), name);
            return Optional.of(new LeavesType(id, baseBlock, null));
        }
        return Optional.empty();
    }

    @Override
    public void buildAll() {
        if (!this.frozen) {
            for (WoodType v : WoodTypeRegistry.WOOD_TYPES.values()) {
                if (v.leaves == null) continue;
                this.registerBlockType(new LeavesType(v.id, v.leaves, v));
            }
        }
        super.buildAll();
    }

    static {
        LEAVES_TYPES = new LinkedHashMap<ResourceLocation, LeavesType>();
    }
}

