/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.fluids;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.mehvahdjukaar.selene.Selene;
import net.mehvahdjukaar.selene.fluids.SoftFluid;
import net.mehvahdjukaar.selene.network.ClientBoundSyncFluidsPacket;
import net.mehvahdjukaar.selene.util.DispenserHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class SoftFluidRegistry
extends SimpleJsonResourceReloadListener {
    public static final SoftFluidRegistry INSTANCE = new SoftFluidRegistry();
    private final HashMap<ResourceLocation, SoftFluid> idMap = new HashMap();
    private final HashMap<Item, SoftFluid> itemMap = new HashMap();
    private final HashMap<Fluid, SoftFluid> fluidMap = new HashMap();
    private boolean initializedDispenser = false;
    private int currentReload = 0;
    public static final SoftFluid EMPTY = SoftFluid.EMPTY;
    public static final FluidReference WATER = FluidReference.of("minecraft:water");
    public static final FluidReference LAVA = FluidReference.of("minecraft:lava");
    public static final FluidReference HONEY = FluidReference.of("minecraft:honey");
    public static final FluidReference MILK = FluidReference.of("minecraft:milk");
    public static final FluidReference MUSHROOM_STEW = FluidReference.of("minecraft:mushroom_stew");
    public static final FluidReference BEETROOT_SOUP = FluidReference.of("minecraft:beetroot_stew");
    public static final FluidReference RABBIT_STEW = FluidReference.of("minecraft:rabbit_stew");
    public static final FluidReference SUS_STEW = FluidReference.of("minecraft:suspicious_stew");
    public static final FluidReference POTION = FluidReference.of("minecraft:potion");
    public static final FluidReference DRAGON_BREATH = FluidReference.of("minecraft:dragon_breath");
    public static final FluidReference XP = FluidReference.of("minecraft:experience");
    public static final FluidReference SLIME = FluidReference.of("minecraft:slime");
    public static final FluidReference GHAST_TEAR = FluidReference.of("minecraft:ghast_tear");
    public static final FluidReference MAGMA_CREAM = FluidReference.of("minecraft:magma_cream");
    public static final FluidReference POWDERED_SNOW = FluidReference.of("minecraft:powder_snow");

    private SoftFluidRegistry() {
        super(new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create(), "soft_fluids");
    }

    public static Collection<SoftFluid> getRegisteredFluids() {
        return SoftFluidRegistry.INSTANCE.idMap.values();
    }

    public static SoftFluid get(String id) {
        return SoftFluidRegistry.INSTANCE.idMap.getOrDefault(new ResourceLocation(id), EMPTY);
    }

    public static SoftFluid get(ResourceLocation id) {
        return SoftFluidRegistry.INSTANCE.idMap.getOrDefault(id, EMPTY);
    }

    public static Optional<SoftFluid> getOptional(ResourceLocation id) {
        return Optional.ofNullable(SoftFluidRegistry.INSTANCE.idMap.getOrDefault(id, null));
    }

    public static SoftFluid fromForgeFluid(Fluid fluid) {
        return SoftFluidRegistry.INSTANCE.fluidMap.getOrDefault(fluid, EMPTY);
    }

    @Nonnull
    public static SoftFluid fromItem(Item filledContainerItem) {
        return SoftFluidRegistry.INSTANCE.itemMap.getOrDefault(filledContainerItem, EMPTY);
    }

    private static void register(SoftFluid s) {
        if (ModList.get().isLoaded(s.getRegistryName().m_135827_())) {
            for (Fluid f : s.getEquivalentFluids()) {
                if (!SoftFluidRegistry.INSTANCE.fluidMap.containsKey(f)) continue;
                SoftFluid old = SoftFluidRegistry.INSTANCE.fluidMap.get(f);
                if (old.isGenerated) continue;
                SoftFluidRegistry.INSTANCE.idMap.remove(old.getRegistryName());
                old.getFilledContainer(Items.f_42446_).ifPresent(SoftFluidRegistry.INSTANCE.itemMap::remove);
            }
            SoftFluidRegistry.registerUnchecked(s);
        }
    }

    private static void registerUnchecked(SoftFluid ... fluids) {
        Arrays.stream(fluids).forEach(s -> {
            s.getEquivalentFluids().forEach(f -> SoftFluidRegistry.INSTANCE.fluidMap.put((Fluid)f, (SoftFluid)s));
            s.getContainerList().getPossibleFilled().forEach(i -> {
                if (i != Items.f_42589_ || !s.getRegistryName().toString().equals("minecraft:water")) {
                    SoftFluidRegistry.INSTANCE.itemMap.put((Item)i, (SoftFluid)s);
                }
            });
            ResourceLocation key = s.getRegistryName();
            if (SoftFluidRegistry.INSTANCE.idMap.containsKey(key)) {
                SoftFluidRegistry.INSTANCE.idMap.put(key, SoftFluid.create(SoftFluidRegistry.INSTANCE.idMap.get(key), s));
            } else {
                SoftFluidRegistry.INSTANCE.idMap.put(key, (SoftFluid)s);
            }
        });
    }

    private static void convertAndRegisterAllForgeFluids() {
        for (Fluid f : ForgeRegistries.FLUIDS) {
            try {
                FlowingFluid flowingFluid;
                if (f == null || f instanceof FlowingFluid && (flowingFluid = (FlowingFluid)f).m_5613_() != f || f instanceof ForgeFlowingFluid.Flowing || f == Fluids.f_76191_ || SoftFluidRegistry.INSTANCE.fluidMap.containsKey(f) || f.getRegistryName() == null) continue;
                SoftFluidRegistry.registerUnchecked(new SoftFluid.Builder(f).build());
            }
            catch (Exception exception) {}
        }
    }

    public static void acceptClientFluids(ClientBoundSyncFluidsPacket packet) {
        SoftFluidRegistry.INSTANCE.idMap.clear();
        SoftFluidRegistry.INSTANCE.fluidMap.clear();
        SoftFluidRegistry.INSTANCE.itemMap.clear();
        packet.getFluids().forEach(SoftFluidRegistry::register);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        ++this.currentReload;
        this.idMap.clear();
        this.fluidMap.clear();
        this.itemMap.clear();
        for (Map.Entry<ResourceLocation, JsonElement> j : jsons.entrySet()) {
            Optional result = SoftFluid.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)j.getValue()).resultOrPartial(e -> Selene.LOGGER.error("Failed to parse soft fluid JSON object for {} : {}", j.getKey(), e));
            result.ifPresent(SoftFluidRegistry::register);
        }
        SoftFluidRegistry.convertAndRegisterAllForgeFluids();
        if (!this.initializedDispenser) {
            this.initializedDispenser = true;
            SoftFluidRegistry.getRegisteredFluids().forEach(DispenserHelper::registerFluidBehavior);
        }
        Selene.LOGGER.info("Registered {} Soft Fluids", (Object)this.idMap.size());
    }

    public static class FluidReference
    implements Supplier<SoftFluid> {
        private final Object lock = new Object();
        private SoftFluid value = null;
        private final ResourceLocation id;
        private int reloadNumber = -1;

        public static FluidReference of(String name) {
            return new FluidReference(new ResourceLocation(name));
        }

        public static FluidReference of(ResourceLocation name) {
            return new FluidReference(name);
        }

        private FluidReference(ResourceLocation id) {
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SoftFluid get() {
            Object object = this.lock;
            synchronized (object) {
                if (SoftFluidRegistry.INSTANCE.currentReload != this.reloadNumber) {
                    this.reloadNumber = SoftFluidRegistry.INSTANCE.currentReload;
                    this.value = SoftFluidRegistry.get(this.id);
                    if (this.value.isEmpty()) {
                        // empty if block
                    }
                }
                return this.value;
            }
        }
    }
}

